<?php
/**
 * Blog Leader Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/blog-leader', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_leader_blog',
		'attributes' => array(
			'posts_per_page' => array(
				'type' => 'string',
				'default' => '4',
			),
			'image_load_mode' => array(
				'type' => 'string',
				'default' => '',
			),
			'image_mode' => array(
				'type' => 'string',
				'default' => 'landscape',
			),
			'excerpt_length' => array(
				'type' => 'string',
				'default' => '30',
			),
			'excerpt_more' => array(
				'type' => 'boolean',
			),
			'excerpt_more_text' => array(
				'type' => 'string',
				'default' => 'read more',
			),
			'animation' => array(
				'type' => 'string',
				'default' => '',
			),
			'animation_delay' => array(
				'type' => 'number',
				'default' => 0,
			),
			'animation_duration' => array(
				'type' => 'string',
				'default' => 'normal',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),
			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'leader_style' => array(
				'type' => 'string',
				'default' => '',
			),
			'overlay_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'overlay_opacity' => array(
				'type' => 'string',
				'default' => '30',
			),
			'heading_tag' => array(
				'type' => 'string',
				'default' => 'h2',
			),
			'heading' => array(
				'type' => 'string',
				'default' => 'h2',
			),
			'small_post_heading' => array(
				'type' => 'string',
				'default' => 'h5',
			),
			'show_author' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'show_date' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'show_comments' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'show_like' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_leader_blog( $atts ) {
	ob_start();
	echo impeka_gutenberg_ext_locate_template( 'blog-leader.php', array( 'atts' => $atts ) );
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
