<?php
/**
 * Blog Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/blog', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_blog',
		'attributes' => array(
			'mode' => array(
				'type' => 'string',
				'default' => 'large',
			),
			'media_area' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'image_prio' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'image_load_mode' => array(
				'type' => 'string',
				'default' => '',
			),
			'image_width' => array(
				'type' => 'string',
				'default' => 'normal',
			),
			'image_mode' => array(
				'type' => 'string',
				'default' => 'landscape-large-wide',
			),
			'grid_image_mode' => array(
				'type' => 'string',
				'default' => 'landscape',
			),
			'masonry_image_mode' => array(
				'type' => 'string',
				'default' => 'medium',
			),
			'columns_large_screen' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns_tablet_landscape' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_tablet_portrait' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_mobile' => array(
				'type' => 'string',
				'default' => '1',
			),
			'item_gutter' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'gutter_size' => array(
				'type' => 'string',
				'default' => '40',
			),
			'auto_excerpt' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'excerpt_length_large' => array(
				'type' => 'string',
				'default' => '55',
			),
			'excerpt_length' => array(
				'type' => 'string',
				'default' => '30',
			),
			'excerpt_more' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'excerpt_more_text' => array(
				'type' => 'string',
				'default' => 'read more',
			),
			'animation' => array(
				'type' => 'string',
				'default' => '',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),
			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'el_id' => array(
				'type' => 'string',
				'default' => 'blog-default-id',
			),
			'style' => array(
				'type' => 'string',
				'default' => 'style-1',
			),
			'small_style' => array(
				'type' => 'string',
				'default' => 'style-small-1',
			),
			'custom_overview' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'heading_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'text_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'meta_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'bg_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'border_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'overlay_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'overlay_opacity' => array(
				'type' => 'string',
				'default' => '30',
			),
			'shadow' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'radius' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'indicator' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'indicator_text' => array(
				'type' => 'string',
				'default' => 'More',
			),
			'indicator_color' => array(
				'type' => 'string',
				'default' => 'primary-1',
			),
			'title_heading_tag' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'title_heading' => array(
				'type' => 'string',
				'default' => 'auto',
			),
			'posts_per_page' => array(
				'type' => 'string',
				'default' => '10',
			),
			'display_style' => array(
				'type' => 'string',
				'default' => 'pagination',
			),
			'display_large_style' => array(
				'type' => 'string',
				'default' => 'pagination',
			),
			'load_more_title' => array(
				'type' => 'string',
				'default' => 'Load More',
			),
			'link_type' => array(
				'type' => 'string',
				'default' => 'item',
			),
			'show_author' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'show_date' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'show_comments' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'show_like' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'show_categories' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'categories_mode' => array(
				'type' => 'string',
				'default' => 'all',
			),
			'filter' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'filter_all_text' => array(
				'type' => 'string',
				'default' => 'All',
			),
			'filter_order_by' => array(
				'type' => 'string',
				'default' => '',
			),
			'filter_order' => array(
				'type' => 'string',
				'default' => 'ASC',
			),
			'filter_style' => array(
				'type' => 'string',
				'default' => 'simple',
			),
			'filter_shape' => array(
				'type' => 'string',
				'default' => 'square',
			),
			'filter_color' => array(
				'type' => 'string',
				'default' => 'primary-1',
			),
			'filter_align' => array(
				'type' => 'string',
				'default' => 'left',
			),
			'filter_gototop' => array(
				'type' => 'string',
				'default' => 'yes',
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_blog( $atts ) {
	ob_start();
	echo impeka_gutenberg_ext_locate_template( 'blog.php', array( 'atts' => $atts ) );
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
