<?php
/**
 * List Title Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/list-title', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_list_title',
		'attributes' => array(
			'post_type' => array(
				'type' => 'string',
				'default' => 'post',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),

			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'overlay_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'overlay_opacity' => array(
				'type' => 'string',
				'default' => '10',
			),
			'heading_tag' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'heading' => array(
				'type' => 'string',
				'default' => 'h4',
			),
			'title_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'text_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'line_color' => array(
				'type' => 'string',
				'default' => 'primary-1',
			),
			'posts_per_page' => array(
				'type' => 'string',
				'default' => '12',
			),
			'display_style' => array(
				'type' => 'string',
				'default' => 'pagination',
			),
			'filter' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'filter_all_text' => array(
				'type' => 'string',
				'default' => 'All',
			),
			'filter_order_by' => array(
				'type' => 'string',
				'default' => '',
			),
			'filter_order' => array(
				'type' => 'string',
				'default' => 'ASC',
			),
			'filter_style' => array(
				'type' => 'string',
				'default' => 'simple',
			),
			'filter_shape' => array(
				'type' => 'string',
				'default' => 'square',
			),
			'filter_color' => array(
				'type' => 'string',
				'default' => 'primary-1',
			),
			'filter_align' => array(
				'type' => 'string',
				'default' => 'left',
			),
			'filter_gototop' => array(
				'type' => 'string',
				'default' => 'yes',
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'portfolio_categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'product_categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_list_title( $atts ) {
	ob_start();
	echo impeka_gutenberg_ext_locate_template( 'list-title.php', array( 'atts' => $atts ) );
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
