<?php
/**
 * Portfolio Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/portfolio-carousel', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_portfolio_carousel',
		'attributes' => array(
			'type' => array(
				'type' => 'string',
				'default' => 'classic',
			),
			'image_load_mode' => array(
				'type' => 'string',
				'default' => '',
			),
			'image_mode' => array(
				'type' => 'string',
				'default' => 'landscape',
			),
			'items_per_page' => array(
				'type' => 'string',
				'default' => '3',
			),
			'items_tablet_landscape' => array(
				'type' => 'string',
				'default' => '2',
			),
			'items_tablet_portrait' => array(
				'type' => 'string',
				'default' => '2',
			),
			'items_mobile' => array(
				'type' => 'string',
				'default' => '1',
			),
			'items_to_show' => array(
				'type' => 'string',
				'default' => '10',
			),
			'item_gutter' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'gutter_size' => array(
				'type' => 'string',
				'default' => '40',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),
			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'style' => array(
				'type' => 'string',
				'default' => 'style-1',
			),
			'image_effect' => array(
				'type' => 'string',
				'default' => '',
			),
			'overlay_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'overlay_opacity' => array(
				'type' => 'string',
				'default' => '20',
			),
			'shadow' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'radius' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'title_caption' => array(
				'type' => 'string',
				'default' => 'title-caption',
			),
			'title_heading_tag' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'title_heading' => array(
				'type' => 'string',
				'default' => 'h4',
			),
			'title_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'text_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'loop' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'auto_play' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'slideshow_speed' => array(
				'type' => 'number',
				'default' => 3000,
			),
			'pause_hover' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'nav_visibility' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'nav_icon' => array(
				'type' => 'string',
				'default' => 'arrow-1',
			),
			'nav_icon_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'nav_shape' => array(
				'type' => 'string',
				'default' => '',
			),
			'nav_shape_type' => array(
				'type' => 'string',
				'default' => 'simple',
			),
			'nav_shape_color' => array(
				'type' => 'string',
				'default' => 'white',
			),
			'pagination' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'pagination_speed' => array(
				'type' => 'number',
				'default' => 400,
			),
			'link_type' => array(
				'type' => 'string',
				'default' => 'item',
			),
			'image_popup_size' => array(
				'type' => 'string',
				'default' => 'extra-extra-large',
			),
			'overview_type' => array(
				'type' => 'string',
				'default' => '',
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_portfolio_carousel( $atts ) {
	ob_start();
	echo impeka_gutenberg_ext_locate_template( 'portfolio-carousel.php', array( 'atts' => $atts ) );
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
