<?php
/**
 * Portfolio Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/portfolio', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_portfolio',
		'attributes' => array(
			'mode' => array(
				'type' => 'string',
				'default' => 'grid',
			),
			'image_load_mode' => array(
				'type' => 'string',
				'default' => '',
			),
			'grid_image_mode' => array(
				'type' => 'string',
				'default' => 'landscape',
			),
			'masonry_image_mode' => array(
				'type' => 'string',
				'default' => '',
			),
			'columns_large_screen' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns_tablet_landscape' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_tablet_portrait' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_mobile' => array(
				'type' => 'string',
				'default' => '1',
			),
			'item_gutter' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'gutter_size' => array(
				'type' => 'string',
				'default' => '30',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),
			'animation' => array(
				'type' => 'string',
				'default' => '',
			),
			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'el_id' => array(
				'type' => 'string',
				'default' => 'portfolio-default-id',
			),
			'style' => array(
				'type' => 'string',
				'default' => 'style-1',
			),
			'indicator' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'indicator_text' => array(
				'type' => 'string',
				'default' => 'More',
			),
			'indicator_color' => array(
				'type' => 'string',
				'default' => 'primary-1',
			),
			'image_effect' => array(
				'type' => 'string',
				'default' => '',
			),
			'overlay_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'overlay_opacity' => array(
				'type' => 'string',
				'default' => '10',
			),
			'shadow' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'radius' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'title_caption' => array(
				'type' => 'string',
				'default' => 'title-caption',
			),
			'heading_auto_size' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'title_heading_tag' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'title_heading' => array(
				'type' => 'string',
				'default' => 'h4',
			),
			'title_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'title_bg_color' => array(
				'type' => 'string',
				'default' => 'transparent',
			),
			'text_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'text_bg_color' => array(
				'type' => 'string',
				'default' => 'transparent',
			),
			'items_per_page' => array(
				'type' => 'string',
				'default' => '12',
			),
			'display_style' => array(
				'type' => 'string',
				'default' => 'pagination',
			),
			'load_more_title' => array(
				'type' => 'string',
				'default' => 'Load More',
			),
			'link_type' => array(
				'type' => 'string',
				'default' => 'item',
			),
			'image_popup_size' => array(
				'type' => 'string',
				'default' => 'extra-extra-large',
			),
			'overview_type' => array(
				'type' => 'string',
				'default' => '',
			),
			'filter' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'filter_all_text' => array(
				'type' => 'string',
				'default' => 'All',
			),
			'filter_order_by' => array(
				'type' => 'string',
				'default' => '',
			),
			'filter_order' => array(
				'type' => 'string',
				'default' => 'ASC',
			),
			'filter_style' => array(
				'type' => 'string',
				'default' => 'simple',
			),
			'filter_shape' => array(
				'type' => 'string',
				'default' => 'square',
			),
			'filter_color' => array(
				'type' => 'string',
				'default' => 'primary-1',
			),
			'filter_align' => array(
				'type' => 'string',
				'default' => 'left',
			),
			'filter_gototop' => array(
				'type' => 'string',
				'default' => 'yes',
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_portfolio( $atts ) {
	ob_start();
	echo impeka_gutenberg_ext_locate_template( 'portfolio.php', array( 'atts' => $atts ) );
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
