<?php
/**
 * Products Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/products', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_products',
		'attributes' => array(
			'mode' => array(
				'type' => 'string',
				'default' => 'grid',
			),
			'grid_image_mode' => array(
				'type' => 'string',
				'default' => 'landscape',
			),
			'masonry_image_mode' => array(
				'type' => 'string',
				'default' => 'large',
			),
			'columns_large_screen' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns_tablet_landscape' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_tablet_portrait' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_mobile' => array(
				'type' => 'string',
				'default' => '1',
			),
			'item_gutter' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'gutter_size' => array(
				'type' => 'string',
				'default' => '30',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),
			'animation' => array(
				'type' => 'string',
				'default' => '',
			),
			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'el_id' => array(
				'type' => 'string',
				'default' => 'products-default-id',
			),
			'title_heading_tag' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'title_heading' => array(
				'type' => 'string',
				'default' => 'h4',
			),
			'hover_style' => array(
				'type' => 'string',
				'default' => 'hover-style-1',
			),
			'second_image_effect' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'text_color' => array(
				'type' => 'string',
				'default' => 'default',
			),
			'overlay_color' => array(
				'type' => 'string',
				'default' => 'white',
			),
			'overlay_opacity' => array(
				'type' => 'string',
				'default' => '90',
			),
			'items_per_page' => array(
				'type' => 'string',
				'default' => '12',
			),
			'display_style' => array(
				'type' => 'string',
				'default' => 'pagination',
			),
			'load_more_title' => array(
				'type' => 'string',
				'default' => 'Load More',
			),
			'link_type' => array(
				'type' => 'string',
				'default' => 'item',
			),
			'quick_view_title' => array(
				'type' => 'string',
				'default' => 'Quick View',
			),
			'filter' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'filter_all_text' => array(
				'type' => 'string',
				'default' => 'All',
			),
			'filter_order_by' => array(
				'type' => 'string',
				'default' => '',
			),
			'filter_order' => array(
				'type' => 'string',
				'default' => 'ASC',
			),
			'filter_style' => array(
				'type' => 'string',
				'default' => 'simple',
			),
			'filter_shape' => array(
				'type' => 'string',
				'default' => 'square',
			),
			'filter_color' => array(
				'type' => 'string',
				'default' => 'primary-1',
			),
			'filter_align' => array(
				'type' => 'string',
				'default' => 'left',
			),
			'filter_gototop' => array(
				'type' => 'string',
				'default' => 'yes',
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_products( $atts ) {
	ob_start();
	if ( class_exists( 'woocommerce' ) ) {
		echo impeka_gutenberg_ext_locate_template( 'products.php', array( 'atts' => $atts ) );
	} else {
		if( current_user_can( 'administrator' ) ) {
			echo esc_html__( 'WooCommerce is not activated!', 'impeka-gutenberg-extension' );
		}
	}
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
