<?php
/**
 * Testimonial Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/testimonial-carousel', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_testimonial_carousel',
		'attributes' => array(
			'style' => array(
				'type' => 'string',
				'default' => 'style-1',
			),
			'type' => array(
				'type' => 'string',
				'default' => 'classic',
			),
			'items_per_page' => array(
				'type' => 'string',
				'default' => '3',
			),
			'items_tablet_landscape' => array(
				'type' => 'string',
				'default' => '2',
			),
			'items_tablet_portrait' => array(
				'type' => 'string',
				'default' => '2',
			),
			'items_mobile' => array(
				'type' => 'string',
				'default' => '1',
			),
			'items_to_show' => array(
				'type' => 'string',
				'default' => '20',
			),
			'item_gutter' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'gutter_size' => array(
				'type' => 'string',
				'default' => '40',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),
			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'show_title' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'heading_tag' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'heading' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'title_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'text_style' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'text_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'bg_color' => array(
				'type' => 'string',
				'default' => 'white',
			),
			'show_image' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'align' => array(
				'type' => 'string',
				'default' => 'left',
			),
			'shadow' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'radius' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'loop' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'auto_play' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'slideshow_speed' => array(
				'type' => 'number',
				'default' => 3000,
			),
			'pause_hover' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'auto_height' => array(
				'type' => 'boolean',
				'default' => false,
			),
			'pagination' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'pagination_speed' => array(
				'type' => 'number',
				'default' => 400,
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_testimonial_carousel( $atts ) {
	ob_start();
	echo impeka_gutenberg_ext_locate_template( 'testimonial-carousel.php', array( 'atts' => $atts ) );
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
