<?php
/**
 * Testimonial Block
 *
 * @since   1.0
 * @package impeka
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

register_block_type(
	'impeka/testimonial', array(
		'editor_script' => 'impeka-gutenberg-ext-block-js',
		'render_callback'  => 'impeka_gutenberg_ext_render_callback_testimonial',
		'attributes' => array(
			'mode' => array(
				'type' => 'string',
				'default' => 'grid',
			),
			'columns_large_screen' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns' => array(
				'type' => 'string',
				'default' => '3',
			),
			'columns_tablet_landscape' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_tablet_portrait' => array(
				'type' => 'string',
				'default' => '2',
			),
			'columns_mobile' => array(
				'type' => 'string',
				'default' => '1',
			),
			'item_gutter' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'gutter_size' => array(
				'type' => 'string',
				'default' => '40',
			),
			'order_by' => array(
				'type' => 'string',
				'default' => 'date',
			),
			'order' => array(
				'type' => 'string',
				'default' => 'DESC',
			),
			'animation' => array(
				'type' => 'string',
				'default' => '',
			),
			'margin_bottom' => array(
				'type' => 'string',
				'default' => '',
			),
			'el_id' => array(
				'type' => 'string',
				'default' => 'testimonial-default-id',
			),
			'style' => array(
				'type' => 'string',
				'default' => 'style-4',
			),
			'show_title' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'heading_tag' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'heading' => array(
				'type' => 'string',
				'default' => 'h3',
			),
			'text_style' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'show_image' => array(
				'type' => 'boolean',
				'default' => true,
			),
			'title_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'text_color' => array(
				'type' => 'string',
				'default' => 'black',
			),
			'bg_color' => array(
				'type' => 'string',
				'default' => 'white',
			),
			'shadow' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'radius' => array(
				'type' => 'string',
				'default' => 'none',
			),
			'posts_per_page' => array(
				'type' => 'string',
				'default' => '20',
			),
			'display_style' => array(
				'type' => 'string',
				'default' => 'pagination',
			),
			'load_more_title' => array(
				'type' => 'string',
				'default' => 'Load More',
			),
			'exclude_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'categories' => array(
				'type' => 'array',
				'default' => [],
			),
			'include_posts' => array(
				'type' => 'string',
				'default' => '',
			),
			'className' => array(
				'type' => 'string',
			),
		),
	)
);


function impeka_gutenberg_ext_render_callback_testimonial( $atts ) {
	ob_start();
	echo impeka_gutenberg_ext_locate_template( 'testimonial.php', array( 'atts' => $atts ) );
	return ob_get_clean();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
