<?php
/*
 * Plugin Name: Impeka Gutenberg Extension
 * Description: This plugin adds custom blocks to gutenberg editor.
 * Author: Greatives Team
 * Author URI: http://greatives.eu
 * Version: 1.3.3
 * Text Domain: impeka-gutenberg-extension
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH' ) ) {
	define( 'IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_URL' ) ) {
	define( 'IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! class_exists( 'Impeka_Gutenberg_Extension_Plugin' ) ) {

	class Impeka_Gutenberg_Extension_Plugin {

		/**
		 * @action plugins_loaded
		 * @return Impeka_Gutenberg_Extension_Plugin
		 * @static
		 */
		public static function init() {
			static $instance = false;

			if ( ! $instance ) {
				load_plugin_textdomain( 'impeka-gutenberg-extension' , false , dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
				$instance = new Impeka_Gutenberg_Extension_Plugin;
			}
			return $instance;

		}

		private function __construct() {
			if ( class_exists( 'Impeka_Extension_Plugin') ) {
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'includes/impeka-gutenberg-ext-functions.php';

				// automatically load dependencies and version
				$asset_file = include( plugin_dir_path( __FILE__ ) . 'build/index.asset.php');

				wp_register_script(
					'impeka-gutenberg-ext-block-js',
					plugins_url( 'build/index.js', __FILE__ ),
					array( 'wp-blocks', 'wp-i18n', 'wp-element' ),
					$asset_file['version'],
					true
				);

				if ( function_exists( 'wp_set_script_translations' ) ) {
					wp_set_script_translations( 'impeka-gutenberg-ext-block-js', 'impeka-gutenberg-extension' );
				}

				//Dynamic Blocks
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/blog_params.php';
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/blog_carousel_params.php';
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/blog_leader_params.php';

				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/portfolio_params.php';
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/portfolio_carousel_params.php';
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/portfolio_broken_params.php';

				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/testimonial_params.php';
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/testimonial_carousel_params.php';

				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/products_params.php';
				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/products_carousel_params.php';

				require_once IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'blocks/list_title_params.php';
			}

		}

		public function impeka_gutenberg_extension_plugin() {
			$this->__construct();
		}
	}

	/**
	 * Initialize the Extension Plugin
	 */
	add_action( 'init' , array( 'Impeka_Gutenberg_Extension_Plugin' , 'init' ), 10 );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.

