<?php

/*
 *	Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */


function impeka_gutenberg_ext_block_category( $categories, $post ) {
	return array_merge(
		$categories,
		array(
			array(
				'slug' => 'impeka',
				'title' => esc_html__( 'Impeka', 'impeka-gutenberg-extension' ),
			),
		)
	);
}

if ( version_compare( get_bloginfo('version'), '5.8', '<' ) ) {
    add_filter( 'block_categories', 'impeka_gutenberg_ext_block_category', 10, 2 );
} else {
    add_filter( 'block_categories_all', 'impeka_gutenberg_ext_block_category', 10, 2 );
}

 /**
 * Helper function to get array value with fallback
 */
if ( !function_exists( 'impeka_gutenberg_ext_array_value' ) ) {
	function impeka_gutenberg_ext_array_value( $input_array, $id, $fallback = false, $param = false ) {

		if ( $fallback == false ) $fallback = '';
		$output = ( isset($input_array[$id]) && $input_array[$id] !== '' ) ? $input_array[$id] : $fallback;
		if ( !empty($input_array[$id]) && $param ) {
			$output = ( isset($input_array[$id][$param]) && $input_array[$id][$param] !== '' ) ? $input_array[$id][$param] : $fallback;
		}
		return $output;
	}
}

if ( !function_exists( 'impeka_gutenberg_ext_starts_with' ) ) {
	function impeka_gutenberg_ext_starts_with( $haystack, $needle ) {
		 $length = strlen($needle);
		 return (substr($haystack, 0, $length) === $needle);
	}
}

/**
 * Helper function to get custom fields with fallback
 */
if ( !function_exists( 'impeka_gutenberg_ext_post_meta' ) ) {
	function impeka_gutenberg_ext_post_meta( $id, $fallback = false ) {
		global $post;
		$post_id = $post->ID;
		if ( $fallback == false ) $fallback = '';
		$post_meta = get_post_meta( $post_id, $id, true );
		$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
		return $output;
	}
}

function impeka_gutenberg_ext_locate_template( $path, $params = null ) {
	$located = locate_template( array(
		'impeka-gutenberg-extension' . DIRECTORY_SEPARATOR . $path,
	) );
	$plugin_path = IMPEKA_GUTENBERG_EXT_PLUGIN_DIR_PATH . 'templates' . DIRECTORY_SEPARATOR . $path;
	if ( ! $located && file_exists( $plugin_path ) ) {
		$final_file = $plugin_path;
	} elseif ( $located ) {
		$final_file = $located;
	}
	if( is_array( $params ) && count( $params ) ) {
		extract( $params );
	}
	ob_start();
	$final_file = apply_filters( 'impeka_gutenberg_ext_locate_template', $final_file, $params, $path );
	include( $final_file );
	return ob_get_clean();
}

 /**
 * Generates dimension string to concat in attribute style
 */
function impeka_gutenberg_ext_build_dimension( $dimension, $value ) {
	$fixed_dimension = '';

	if( ! empty( $dimension ) &&  ! empty( $value )  ) {
		$fixed_dimension .= $dimension . ': '.(preg_match('/(px|em|\%|pt|cm)$/', $value) ? $value : $value.'px').';';
	}
	return $fixed_dimension;
}

 /**
 * Generates margin-bottom string to concat in attribute style
 */
function impeka_gutenberg_ext_build_margin_bottom_style( $margin_bottom ) {
	$style = '';
	if( $margin_bottom != '' ) {
		$style .= 'margin-bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $margin_bottom) ? $margin_bottom : $margin_bottom .'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

 /**
 * Generates padding-top string to concat in attribute style
 */
function impeka_gutenberg_ext_build_padding_top_style( $padding_top ) {
	$style = '';
	if( $padding_top != '' ) {
		$style .= 'padding-top: '.(preg_match('/(px|em|\%|pt|cm)$/', $padding_top) ? $padding_top : $padding_top.'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

 /**
 * Generates padding-bottom string to concat in attribute style
 */
function impeka_gutenberg_ext_build_padding_bottom_style( $padding_bottom ) {
	$style = '';
	if( $padding_bottom != '' ) {
		$style .= 'padding-bottom: '.(preg_match('/(px|em|\%|pt|cm)$/', $padding_bottom) ? $padding_bottom : $padding_bottom.'px').';';
		$style = esc_attr( $style );
	}
	return $style;
}

function impeka_gutenberg_ext_unautop( $s ) {
    $s = str_replace("<p>", "", $s);
    $s = str_replace("</p>", "\n\n", $s);
    return $s;
}
function impeka_gutenberg_ext_auto_br( $s ) {
    $s = str_replace("<p>", "", $s);
    $s = str_replace("</p>", "<br>", $s);
    return $s;
}

 /**
 * Theme Classes
 */
function impeka_gutenberg_print_filters( $atts = array() ) {
	if ( function_exists( 'impeka_grve_print_filters' ) ) {
		impeka_grve_print_filters( $atts );
	}
}
function impeka_gutenberg_print_pagination( $params = array() ) {
	if ( function_exists( 'impeka_grve_paginate_links' ) ) {
		impeka_grve_paginate_links( 'element', $params );
	}
}
function impeka_gutenberg_ext_get_grid_layout_atts( $params = array() ) {
	if ( function_exists( 'impeka_grve_get_grid_layout_atts' ) ) {
		return impeka_grve_get_grid_layout_atts( $params );
	} else {
		return array();
	}
}
function impeka_gutenberg_ext_post_bg_image_container( $options = array() ) {
	if ( function_exists( 'impeka_grve_print_post_bg_image_container' ) ) {
		impeka_grve_print_post_bg_image_container( $options );
	}
}
function impeka_gutenberg_ext_get_video_icon( $color = 'white', $position = '' ) {
	if ( function_exists( 'impeka_grve_get_video_icon' ) ) {
		return impeka_grve_get_video_icon( $color, $position );
	}
}
function impeka_gutenberg_ext_print_image_filters( $atts = array() ) {
	if ( function_exists( 'impeka_grve_print_image_filters' ) ) {
		impeka_grve_print_image_filters( $atts );
	}
}

function impeka_gutenberg_ext_build_svg_icon( $icon_options = array() ) {
	if ( function_exists( 'impeka_grve_build_svg_icon' ) ) {
		return impeka_grve_build_svg_icon( $icon_options );
	}
}

function impeka_gutenberg_ext_get_svg_icon( $icon = 'arrow-1' ) {
	if ( function_exists('impeka_grve_get_svg_icon') ) {
		return impeka_grve_get_svg_icon( $icon );
	}
}
function impeka_gutenberg_ext_print_close_icon( $icon_color = 'white' ) {
	if ( function_exists('impeka_grve_print_close_icon') ) {
		return impeka_grve_print_close_icon( $icon_color );
	}
}
function impeka_gutenberg_ext_get_blog_class( $blog_mode = 'large'  ) {
	if ( function_exists('impeka_grve_excerpt') ) {
		return impeka_grve_get_blog_class( $blog_mode );
	}
	return "";
}

function impeka_gutenberg_ext_excerpt( $excerpt_length = '15', $excerpt_more = "", $excerpt_more_text = "" ) {
	if ( function_exists('impeka_grve_excerpt') ) {
		return impeka_grve_excerpt( $excerpt_length, $excerpt_more, $excerpt_more_text );
	}
	return "";
}
function impeka_gutenberg_ext_get_image_size( $image_mode = 'full', $index = 1 ) {
	if ( function_exists( 'impeka_grve_get_image_size' ) ) {
		return impeka_grve_get_image_size( $image_mode, $index );
	} else {
		return $image_mode;
	}
}
function impeka_gutenberg_ext_get_fallback_image_attr( $size = '' ) {
	$image_atts = array();
	if ( function_exists( 'impeka_grve_get_fallback_image_attr' ) ) {
		return impeka_grve_get_fallback_image_attr( $size );
	} else {
		return $image_atts;
	}
}
function impeka_gutenberg_ext_get_attachment_image( $id, $size = 'thumbnail', $icon = false, $attr = '' ) {
	if ( function_exists( 'impeka_grve_get_attachment_image' ) ) {
		return impeka_grve_get_attachment_image( $id, $size , $icon, $attr );
	} else {
		return wp_get_attachment_image( $id, $size , $icon, $attr );
	}
}
function impeka_gutenberg_ext_the_post_thumbnail( $size = 'thumbnail', $attr = '' ) {
	if ( function_exists( 'impeka_grve_the_post_thumbnail' ) ) {
		impeka_grve_the_post_thumbnail( $size , $attr );
	} else {
		the_post_thumbnail( $size, $attr );
	}
}
function impeka_gutenberg_ext_get_fallback_image( $size = '', $mode = '', $url= '' ) {
	if ( function_exists( 'impeka_grve_get_fallback_image' ) ) {
		return impeka_grve_get_fallback_image( $size, $mode, $url );
	}
	return '';
}
function impeka_gutenberg_ext_get_fallback_image_wrapper( $size = '', $mode = '', $url= '' ) {
	if ( function_exists( 'impeka_grve_get_fallback_image_wrapper' ) ) {
		return impeka_grve_get_fallback_image_wrapper( $size, $mode, $url );
	}
	return '';
}
function impeka_gutenberg_ext_get_custom_masonry_data( $size = 'square' ) {
	if ( function_exists( 'impeka_grve_get_custom_masonry_data' ) ) {
		return impeka_grve_get_custom_masonry_data( $size );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}
function impeka_gutenberg_ext_get_masonry_data( $index, $columns ) {
	if ( function_exists( 'impeka_grve_get_masonry_data' ) ) {
		return impeka_grve_get_masonry_data( $index, $columns );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}
function impeka_gutenberg_ext_get_broken_grid_data( $index, $layout ) {
	if ( function_exists( 'impeka_grve_get_broken_grid_data' ) ) {
		return impeka_grve_get_broken_grid_data( $index, $layout );
	}
	return array(
		'class' => "grve-image-square",
		'image_size' => 'impeka-grve-small-square',
	);
}
function impeka_gutenberg_ext_print_structured_data() {
	if( function_exists( 'impeka_grve_print_post_structured_data' ) ) {
		impeka_grve_print_post_structured_data();
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
