// edit.js

import { grveSelectOptions, grveGetColorArray } from '../utilities';
import get from 'lodash/get';
import apiFetch from '@wordpress/api-fetch';
import ServerSideRender from '@wordpress/server-side-render';

import { addQueryArgs } from '@wordpress/url';
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { QueryControls, TextControl, SelectControl, ToggleControl, PanelBody } from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';

const CATEGORIES_LIST_QUERY = {
	per_page: -1,
	hide_empty: true,
	_fields: 'id, name ,slug',
};

export default class ImpekaBlogCarouselEdit extends Component {
	constructor() {
		super( ...arguments );
		this.state = {
			categoriesList: [],

		};
	}
	componentDidMount() {
		this.isStillMounted = true;
		this.fetchRequest = apiFetch( {
			path: addQueryArgs( '/wp/v2/categories', CATEGORIES_LIST_QUERY ),

		} ).then(
			( categoriesList ) => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList } );
				}
			}
		).catch(
			() => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList: [] } );
				}
			}
		);
	}
	componentWillUnmount() {
		this.isStillMounted = false;
	}
    render() {

		const { categoriesList } = this.state;
		const { attributes, setAttributes, className } = this.props;
		const {
			type, media_area, image_load_mode, image_mode,
			items_per_page, items_tablet_landscape, items_tablet_portrait, items_mobile, posts_per_page,
			item_gutter, gutter_size,
			excerpt_length, excerpt_more, excerpt_more_text,
			order_by, order, margin_bottom,
			style, heading_color, text_color, meta_color, bg_color, border_color, overlay_color, overlay_opacity,
			shadow, radius,
			title_heading_tag, title_heading,
			loop, auto_play, slideshow_speed, pause_hover,
			nav_visibility, nav_icon, nav_icon_color, nav_shape, nav_shape_type, nav_shape_color,
			pagination, pagination_speed,
			link_type, show_author, show_date, show_comments, show_like, show_categories, categories_mode,
			exclude_posts, categories, include_posts,
		} = attributes;

		const categoryQueryControls = () => {
			const categorySuggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			const suggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			return ( <QueryControls
				categorySuggestions={ categorySuggestions }
				selectedCategories={ attributes.categories }
				onCategoryChange={ ( tokens ) => {
					const allCategories = tokens.map( ( token ) =>
						typeof token === 'string' ? suggestions[ token ] : token
					);
					setAttributes( { categories: allCategories } );
				} }
			/> );
		};

		return (
			<Fragment>
				<InspectorControls key="inspector">
					<PanelBody title={ __( 'General', 'impeka-gutenberg-extension' ) } initialOpen={ true } >
						<SelectControl
							label={ __( 'Carousel Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Carousel Type.', 'impeka-gutenberg-extension' ) }
							value={ type }
							options={
								[
									{ value: 'classic', label: __( 'Classic', 'impeka-gutenberg-extension' ) },
									{ value: 'advanced', label: __( 'Advanced', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { type: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Media Area Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select if you want to enable/disable media area', 'impeka-gutenberg-extension' ) }
							checked={ media_area }
							onChange={ val => { setAttributes( { media_area: ! media_area } ); } }
						/>
						{ media_area && (
						<SelectControl
							label={ __( 'Image Load Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable Lazy load.', 'impeka-gutenberg-extension' ) }
							value={ image_load_mode }
							options={
								grveSelectOptions[ "image_load_mode" ]
							}
							onChange={ val => { setAttributes( { image_load_mode: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Image Size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Image Size.', 'impeka-gutenberg-extension' ) }
							value={ image_mode }
							options={
								[
									{ value: 'square', label: __( 'Square Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape', label: __( 'Landscape Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape-medium', label: __( 'Landscape Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait', label: __( 'Portrait Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait-medium', label: __( 'Portrait Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'large', label: __( 'Resize ( Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium_large', label: __( 'Resize ( Medium Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium', label: __( 'Resize ( Medium )', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { image_mode: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items per page', 'impeka-gutenberg-extension' ) }
							help={ __( 'Number of items per page', 'impeka-gutenberg-extension' ) }
							value={ items_per_page }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { items_per_page: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Tablet Landscape', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on tablet devices, landscape orientation.', 'impeka-gutenberg-extension' ) }
							value={ items_tablet_landscape }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { items_tablet_landscape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Tablet Portrait', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on tablet devices, portrait orientation.', 'impeka-gutenberg-extension' ) }
							value={ items_tablet_portrait }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { items_tablet_portrait: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Mobile', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on mobile devices.', 'impeka-gutenberg-extension' ) }
							value={ items_mobile }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
								]
							}
							onChange={ val => { setAttributes( { items_mobile: val } ); } }
						/>
						<TextControl
							label={ __( 'Items to show', 'impeka-gutenberg-extension' ) }
							help={ __( 'Maximum Items to Show', 'impeka-gutenberg-extension' ) }
							value={ posts_per_page }
							onChange={ val => { setAttributes( { posts_per_page: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Gutter between items', 'impeka-gutenberg-extension' ) }
							help={ __( 'Add gutter among items.', 'impeka-gutenberg-extension' ) }
							checked={ item_gutter }
							onChange={ val => { setAttributes( { item_gutter: ! item_gutter } ); } }
						/>
						{ item_gutter && (
						<TextControl
							label={ __( 'Gutter Size', 'impeka-gutenberg-extension' ) }
							value={ gutter_size }
							onChange={ val => { setAttributes( { gutter_size: val } ); } }
						/>
						)}
						<TextControl
							label={ __( 'Excerpt length', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type how many words you want to display in your post excerpts.', 'impeka-gutenberg-extension' ) }
							value={ excerpt_length }
							onChange={ val => { setAttributes( { excerpt_length: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Read More', 'impeka-gutenberg-extension' ) }
							help={ __( 'Adds a read more button after the excerpt.', 'impeka-gutenberg-extension' ) }
							checked={ excerpt_more }
							onChange={ val => { setAttributes( { excerpt_more: ! excerpt_more } ); } }
						/>
						{ excerpt_more && (
						<TextControl
							label={ __( 'Read more text', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type your read more text.', 'impeka-gutenberg-extension' ) }
							value={ excerpt_more_text }
							onChange={ val => { setAttributes( { excerpt_more_text: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Order by', 'impeka-gutenberg-extension' ) }
							value={ order_by }
							options={
								grveSelectOptions[ "order_by" ]
							}
							onChange={ val => { setAttributes( { order_by: val } ); } }
						/>
						{ ( 'rand' != order_by && 'post__in' != order_by ) && (
						<SelectControl
							label={ __( 'Order', 'impeka-gutenberg-extension' ) }
							value={ order }
							options={
								grveSelectOptions[ "order" ]
							}
							onChange={ val => { setAttributes( { order: val } ); } }
						/>
						)}
						<TextControl
							label={ __( 'Bottom margin', 'impeka-gutenberg-extension' ) }
							help={ __( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-gutenberg-extension' ) }
							value={ margin_bottom }
							onChange={ val => { setAttributes( { margin_bottom: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Styles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Post Style.', 'impeka-gutenberg-extension' ) }
							value={ style }
							options={
								[
									{ value: 'style-1', label: __( 'Style 1', 'impeka-gutenberg-extension' ) },
									{ value: 'style-2', label: __( 'Style 2', 'impeka-gutenberg-extension' ) },
									{ value: 'style-3', label: __( 'Style 3', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { style: val } ); } }
						/>
						{ ( 'style-2' == style || 'style-3' == style ) && (
						<Fragment>
						<SelectControl
							label={ __( 'Heading Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the heading color.', 'impeka-gutenberg-extension' ) }
							value={ heading_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { heading_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Text Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the text color.', 'impeka-gutenberg-extension' ) }
							value={ text_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { text_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Meta Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the meta color.', 'impeka-gutenberg-extension' ) }
							value={ meta_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { meta_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Background Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the background color.', 'impeka-gutenberg-extension' ) }
							value={ bg_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { bg_color: val } ); } }
						/>
						</Fragment>
						)}
						{ ( 'style-2' == style ) && (
						<SelectControl
							label={ __( 'Border Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the border color.', 'impeka-gutenberg-extension' ) }
							value={ border_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { border_color: val } ); } }
						/>
						)}
						{ ( 'style-3' == style ) && (
						<SelectControl
							label={ __( 'Overlay Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the overlay color.', 'impeka-gutenberg-extension' ) }
							value={ overlay_color }
							options={ grveGetColorArray( ['default', 'primary', 'gradient', 'standard'] ) }
							onChange={ val => { setAttributes( { overlay_color: val } ); } }
						/>
						)}
						{ ( 'style-3' == style ) && (
						<SelectControl
							label={ __( 'Overlay Opacity', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the opacity for the overlay.', 'impeka-gutenberg-extension' ) }
							value={ overlay_opacity }
							options={ grveSelectOptions[ "overlay_opacity" ] }
							onChange={ val => { setAttributes( { overlay_opacity: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Shadow', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose shadow.', 'impeka-gutenberg-extension' ) }
							value={ shadow }
							options={ grveSelectOptions[ "shadow" ] }
							onChange={ val => { setAttributes( { shadow: val } ); } }
						/>
						<SelectControl
							label={ __( 'Border Radius', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose border radius', 'impeka-gutenberg-extension' ) }
							value={ radius }
							options={ grveSelectOptions[ "radius" ] }
							onChange={ val => { setAttributes( { radius: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Titles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Post Title Tag', 'impeka-gutenberg-extension' ) }
							help={ __( 'Post Title Tag for SEO.', 'impeka-gutenberg-extension' ) }
							value={ title_heading_tag }
							options={ grveSelectOptions[ "heading_tag" ] }
							onChange={ val => { setAttributes( { title_heading_tag: val } ); } }
						/>
						<SelectControl
							label={ __( 'Post Title Size/Typography', 'impeka-gutenberg-extension' ) }
							help={ __( 'Post Title size and typography, defined in Theme Options - Typography Options', 'impeka-gutenberg-extension' ) }
							value={ title_heading }
							options={ grveSelectOptions[ "heading_auto" ] }
							onChange={ val => { setAttributes( { title_heading: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Navigation & Pagination', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<ToggleControl
							label={ __( 'Loop', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable loop.', 'impeka-gutenberg-extension' ) }
							checked={ loop }
							onChange={ val => { setAttributes( { loop: ! loop } ); } }
						/>
						<ToggleControl
							label={ __( 'Autoplay', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable autoplay.', 'impeka-gutenberg-extension' ) }
							checked={ auto_play }
							onChange={ val => { setAttributes( { auto_play: ! auto_play } ); } }
						/>
						{ 'classic' == type && (
						<TextControl
							label={ __( 'Slideshow Speed', 'impeka-gutenberg-extension' ) }
							help={ __( 'Slideshow Speed in ms.', 'impeka-gutenberg-extension' ) }
							value={ slideshow_speed }
							onChange={ val => { setAttributes( { slideshow_speed: val } ); } }
						/>
						)}
						{ 'classic' == type && (
						<ToggleControl
							label={ __( 'Pause on Hover', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable pause on hover.', 'impeka-gutenberg-extension' ) }
							checked={ pause_hover }
							onChange={ val => { setAttributes( { pause_hover: ! pause_hover } ); } }
						/>
						)}
						<ToggleControl
							label={ __( 'Navigation', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable navigation.', 'impeka-gutenberg-extension' ) }
							checked={ nav_visibility }
							onChange={ val => { setAttributes( { nav_visibility: ! nav_visibility } ); } }
						/>
						{ nav_visibility && (
						<SelectControl
							label={ __( 'Navigation Icon', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation icon.', 'impeka-gutenberg-extension' ) }
							value={ nav_icon }
							options={ grveSelectOptions[ "nav_icon" ] }
							onChange={ val => { setAttributes( { nav_icon: val } ); } }
						/>
						)}
						{ nav_visibility && (
						<SelectControl
							label={ __( 'Icon Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation icon color.', 'impeka-gutenberg-extension' ) }
							value={ nav_icon_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { nav_icon_color: val } ); } }
						/>
						)}
						{ nav_visibility && (
						<SelectControl
							label={ __( 'Navigation Shape', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation shape.', 'impeka-gutenberg-extension' ) }
							value={ nav_shape }
							options={ grveSelectOptions[ "nav_shape" ] }
							onChange={ val => { setAttributes( { nav_shape: val } ); } }
						/>
						)}
						{ ( nav_visibility && '' != nav_shape ) && (
						<SelectControl
							label={ __( 'Navigation Shape Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation shape type.', 'impeka-gutenberg-extension' ) }
							value={ nav_shape_type }
							options={ grveSelectOptions[ "nav_shape_type" ] }
							onChange={ val => { setAttributes( { nav_shape_type: val } ); } }
						/>
						)}
						{ ( nav_visibility && '' != nav_shape ) && (
						<SelectControl
							label={ __( 'Navigation Shape Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation shape color.', 'impeka-gutenberg-extension' ) }
							value={ nav_shape_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { nav_shape_color: val } ); } }
						/>
						)}
						<ToggleControl
							label={ __( 'Pagination', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable pagination.', 'impeka-gutenberg-extension' ) }
							checked={ pagination }
							onChange={ val => { setAttributes( { pagination: ! pagination } ); } }
						/>
						{ ( 'classic' == type && pagination ) && (
						<TextControl
							label={ __( 'Pagination Speed', 'impeka-gutenberg-extension' ) }
							help={ __( 'Pagination Speed in ms.', 'impeka-gutenberg-extension' ) }
							value={ pagination_speed }
							onChange={ val => { setAttributes( { pagination_speed: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Extras', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Link Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the link type of your post items.', 'impeka-gutenberg-extension' ) }
							value={ link_type }
							options={
								[
									{ value: 'item', label: __( 'Classic Post', 'impeka-gutenberg-extension' ) },
									{ value: 'quick-view', label: __( 'Quick View', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { link_type: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Author Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the author field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_author }
							onChange={ val => { setAttributes( { show_author: ! show_author } ); } }
						/>
						<ToggleControl
							label={ __( 'Date Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the date field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_date }
							onChange={ val => { setAttributes( { show_date: ! show_date } ); } }
						/>
						<ToggleControl
							label={ __( 'Comments Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the comments field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_comments }
							onChange={ val => { setAttributes( { show_comments: ! show_comments } ); } }
						/>
						<ToggleControl
							label={ __( 'Like Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the like field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_like }
							onChange={ val => { setAttributes( { show_like: ! show_like } ); } }
						/>
						<ToggleControl
							label={ __( 'Categories Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the like field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_categories }
							onChange={ val => { setAttributes( { show_categories: ! show_categories } ); } }
						/>
						{ show_categories && (
						<SelectControl
							label={ __( 'Categories Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your category mode.', 'impeka-gutenberg-extension' ) }
							value={ categories_mode }
							options={
								[
									{ value: 'all', label: __( 'All', 'impeka-gutenberg-extension' ) },
									{ value: 'one', label: __( 'First / Primary', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { categories_mode: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Categories', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Exclude Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-gutenberg-extension' ) }
							value={ exclude_posts }
							onChange={ val => { setAttributes( { exclude_posts: val } ); } }
						/>
						{ categoryQueryControls() }
						<TextControl
							label={ __( 'Include Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-gutenberg-extension' ) }
							value={ include_posts }
							onChange={ val => { setAttributes( { include_posts: val } ); } }
						/>
					</PanelBody>
				</InspectorControls>
				<ServerSideRender block="impeka/blog-carousel" attributes={ attributes } />
			</Fragment>
		);
    }
}