/**
 * BLOCK: Blog Leader
 *
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */

//Import Edit
import edit from "./edit";

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;

registerBlockType( 'impeka/blog-leader', {
	title: __( 'Blog Leader', 'impeka-gutenberg-extension' ),
	icon: <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24" viewBox="0 0 24 24" width="24"><g><rect fill="none" height="24" width="24"/><g><path d="M2,4v16h20V4H2z M20,8.67h-2.5V6H20V8.67z M17.5,10.67H20v2.67h-2.5V10.67z M4,6h11.5v12H4V6z M17.5,18v-2.67H20V18H17.5z"/></g></g></svg>,
	category: 'impeka',
	keywords: [
		__( 'Blog Leader', 'impeka-gutenberg-extension' ),
		__( 'blog leader', 'impeka-gutenberg-extension' ),
		__( 'Impeka', 'impeka-gutenberg-extension' ),
		__( 'impeka', 'impeka-gutenberg-extension' ),
	],
	edit: edit,
	save: ( ) => {
		return null;
	},
} );
