// edit.js

import { grveSelectOptions, grveGetColorArray } from '../utilities';
import get from 'lodash/get';
import apiFetch from '@wordpress/api-fetch';
import ServerSideRender from '@wordpress/server-side-render';

import { addQueryArgs } from '@wordpress/url';
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { QueryControls, TextControl, SelectControl, ToggleControl, PanelBody } from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';

const CATEGORIES_LIST_QUERY = {
	per_page: -1,
	hide_empty: true,
	_fields: 'id, name ,slug',
};

export default class ImpekaBlogEdit extends Component {
	constructor() {
		super( ...arguments );
		this.state = {
			categoriesList: [],

		};
	}
	componentDidMount() {
		this.isStillMounted = true;
		this.fetchRequest = apiFetch( {
			path: addQueryArgs( '/wp/v2/categories', CATEGORIES_LIST_QUERY ),

		} ).then(
			( categoriesList ) => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList } );
				}
			}
		).catch(
			() => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList: [] } );
				}
			}
		);
	}
	componentWillUnmount() {
		this.isStillMounted = false;
	}
    render() {

		const { categoriesList } = this.state;
		const { attributes, setAttributes, className } = this.props;
		const {
			mode, media_area, image_load_mode, image_prio, image_width, image_mode, grid_image_mode, masonry_image_mode,
			columns_large_screen, columns, columns_tablet_landscape, columns_tablet_portrait, columns_mobile,
			item_gutter, gutter_size,
			auto_excerpt, excerpt_length_large, excerpt_length, excerpt_more, excerpt_more_text,
			animation,
			order_by, order, margin_bottom, el_id,
			style, small_style, custom_overview,
			heading_color, text_color, meta_color, bg_color, border_color, overlay_color, overlay_opacity,
			shadow, radius,
			indicator, indicator_text, indicator_color,
			title_heading_tag, title_heading,
			posts_per_page, display_style, display_large_style, load_more_title,
			link_type, show_author, show_date, show_comments, show_like, show_categories, categories_mode,
			filter, filter_all_text, filter_order_by, filter_order, filter_style, filter_shape, filter_color, filter_align, filter_gototop,
			exclude_posts, categories, include_posts,
		} = attributes;

		const categoryQueryControls = () => {
			const categorySuggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			const suggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			return ( <QueryControls
				categorySuggestions={ categorySuggestions }
				selectedCategories={ attributes.categories }
				onCategoryChange={ ( tokens ) => {
					const allCategories = tokens.map( ( token ) =>
						typeof token === 'string' ? suggestions[ token ] : token
					);
					setAttributes( { categories: allCategories } );
				} }
			/> );
		};

		return (
			<Fragment>
				<InspectorControls key="inspector">
					<PanelBody title={ __( 'General', 'impeka-gutenberg-extension' ) } initialOpen={ true } >
						<SelectControl
							label={ __( 'Blog Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Blog Mode.', 'impeka-gutenberg-extension' ) }
							value={ mode }
							options={
								[
									{ value: 'large', label: __( 'Large Media', 'impeka-gutenberg-extension' ) },
									{ value: 'small', label: __( 'Small Media', 'impeka-gutenberg-extension' ) },
									{ value: 'masonry', label: __( 'Masonry', 'impeka-gutenberg-extension' ) },
									{ value: 'grid', label: __( 'Grid', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { mode: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Media Area Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select if you want to enable/disable media area', 'impeka-gutenberg-extension' ) }
							checked={ media_area }
							onChange={ val => { setAttributes( { media_area: ! media_area } ); } }
						/>
						{ media_area && (
						<SelectControl
							label={ __( 'Image Load Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable Lazy load.', 'impeka-gutenberg-extension' ) }
							value={ image_load_mode }
							options={
								grveSelectOptions[ "image_load_mode" ]
							}
							onChange={ val => { setAttributes( { image_load_mode: val } ); } }
						/>
						)}
						{ media_area && (
						<ToggleControl
							label={ __( 'Featured Image Priority', 'impeka-gutenberg-extension' ) }
							help={ __( 'Featured image is displayed instead of media element', 'impeka-gutenberg-extension' ) }
							checked={ image_prio }
							onChange={ val => { setAttributes( { image_prio: val } ); } }
						/>
						)}
						{ 'large' == mode && (
						<SelectControl
							label={ __( 'Image Width', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the feature image width.', 'impeka-gutenberg-extension' ) }
							value={ image_width }
							options={
								[
									{ value: 'normal', label: __( 'Normal', 'impeka-gutenberg-extension' ) },
									{ value: 'wide', label: __( 'Wide', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { image_width: val } ); } }
						/>
						)}
						{ 'large' == mode && (
						<SelectControl
							label={ __( 'Image Size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Image Size.', 'impeka-gutenberg-extension' ) }
							value={ grid_image_mode }
							options={
								[
									{ value: 'square', label: __( 'Square Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape', label: __( 'Landscape Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape-medium', label: __( 'Landscape Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait', label: __( 'Portrait Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait-medium', label: __( 'Portrait Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'large', label: __( 'Resize ( Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium_large', label: __( 'Resize ( Medium Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium', label: __( 'Resize ( Medium )', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { grid_image_mode: val } ); } }
						/>
						)}
						{ ( 'small' == mode || 'grid' == mode ) && (
						<SelectControl
							label={ __( 'Grid Image size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Image Size.', 'impeka-gutenberg-extension' ) }
							value={ image_mode }
							options={
								[
									{ value: 'landscape-large-wide', label: __( 'Landscape Large Wide Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape-medium', label: __( 'Landscape Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'extra-extra-large', label: __( 'Resize ( Extra Extra Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'large', label: __( 'Resize ( Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium_large', label: __( 'Resize ( Medium Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium', label: __( 'Resize ( Medium )', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { image_mode: val } ); } }
						/>
						)}
						{ 'masonry' == mode && (
						<SelectControl
							label={ __( 'Masonry Image Size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Image Size.', 'impeka-gutenberg-extension' ) }
							value={ masonry_image_mode }
							options={
								[
									{ value: 'large', label: __( 'Resize ( Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium_large', label: __( 'Resize ( Medium Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium', label: __( 'Resize ( Medium )', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { masonry_image_mode: val } ); } }
						/>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && (
						<Fragment>
						<SelectControl
							label={ __( 'Large Screen Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the number of columns for large screens.', 'impeka-gutenberg-extension' ) }
							value={ columns_large_screen }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
								]
							}
							onChange={ val => { setAttributes( { columns_large_screen: val } ); } }
						/>
						<SelectControl
							label={ __( 'Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the number of columns for normal screens.', 'impeka-gutenberg-extension' ) }
							value={ columns }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
								]
							}
							onChange={ val => { setAttributes( { columns: val } ); } }
						/>
						<SelectControl
							label={ __( 'Tablet Landscape Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on tablet devices, landscape orientation.', 'impeka-gutenberg-extension' ) }
							value={ columns_tablet_landscape }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { columns_tablet_landscape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Tablet Portrait Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on tablet devices, portrait orientation.', 'impeka-gutenberg-extension' ) }
							value={ columns_tablet_portrait }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { columns_tablet_portrait: val } ); } }
						/>
						<SelectControl
							label={ __( 'Mobile Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on mobile devices.', 'impeka-gutenberg-extension' ) }
							value={ columns_mobile }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
								]
							}
							onChange={ val => { setAttributes( { columns_mobile: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Gutter between items', 'impeka-gutenberg-extension' ) }
							help={ __( 'Add gutter among items.', 'impeka-gutenberg-extension' ) }
							checked={ item_gutter }
							onChange={ val => { setAttributes( { item_gutter: ! item_gutter } ); } }
						/>
						{ item_gutter && (
						<TextControl
							label={ __( 'Gutter Size', 'impeka-gutenberg-extension' ) }
							value={ gutter_size }
							onChange={ val => { setAttributes( { gutter_size: val } ); } }
						/>
						)}
						</Fragment>
						)}
						{ ( 'large' == mode ) && (
						<ToggleControl
							label={ __( 'Auto excerpt', 'impeka-gutenberg-extension' ) }
							help={ __( 'Adds automatic excerpt to all posts in Large Media style. If auto excerpt is not selected, blog will show all content, a desired \'cut-off\' point can be inserted in each post with more quicktag.', 'impeka-gutenberg-extension' ) }
							checked={ auto_excerpt }
							onChange={ val => { setAttributes( { auto_excerpt: ! auto_excerpt } ); } }
						/>
						)}
						{ ( 'large' == mode && auto_excerpt ) && (
						<TextControl
							label={ __( 'Excerpt length', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type how many words you want to display in your post excerpts.', 'impeka-gutenberg-extension' ) }
							value={ excerpt_length_large }
							onChange={ val => { setAttributes( { excerpt_length_large: val } ); } }
						/>
						)}
						{ ( 'small' == mode || 'grid' == mode || 'masonry' == mode ) && (
						<TextControl
							label={ __( 'Excerpt length', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type how many words you want to display in your post excerpts.', 'impeka-gutenberg-extension' ) }
							value={ excerpt_length }
							onChange={ val => { setAttributes( { excerpt_length: val } ); } }
						/>
						)}
						<ToggleControl
							label={ __( 'Read More', 'impeka-gutenberg-extension' ) }
							help={ __( 'Adds a read more button after the excerpt.', 'impeka-gutenberg-extension' ) }
							checked={ excerpt_more }
							onChange={ val => { setAttributes( { excerpt_more: ! excerpt_more } ); } }
						/>
						{ excerpt_more && (
						<TextControl
							label={ __( 'Read more text', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type your read more text.', 'impeka-gutenberg-extension' ) }
							value={ excerpt_more_text }
							onChange={ val => { setAttributes( { excerpt_more_text: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Animation', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'impeka-gutenberg-extension' ) }
							value={ animation }
							options={
								grveSelectOptions[ "animation" ]
							}
							onChange={ val => { setAttributes( { animation: val } ); } }
						/>
						<SelectControl
							label={ __( 'Order by', 'impeka-gutenberg-extension' ) }
							value={ order_by }
							options={
								grveSelectOptions[ "order_by" ]
							}
							onChange={ val => { setAttributes( { order_by: val } ); } }
						/>
						{ ( 'rand' != order_by && 'post__in' != order_by ) && (
						<SelectControl
							label={ __( 'Order', 'impeka-gutenberg-extension' ) }
							value={ order }
							options={
								grveSelectOptions[ "order" ]
							}
							onChange={ val => { setAttributes( { order: val } ); } }
						/>
						)}
						<TextControl
							label={ __( 'Bottom margin', 'impeka-gutenberg-extension' ) }
							help={ __( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-gutenberg-extension' ) }
							value={ margin_bottom }
							onChange={ val => { setAttributes( { margin_bottom: val } ); } }
						/>
						<TextControl
							label={ __( 'Element ID', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter element ID (Note: make sure it is unique)', 'impeka-gutenberg-extension' ) }
							value={ el_id }
							onChange={ val => { setAttributes( { el_id: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Styles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						{ ( 'grid' == mode || 'masonry' == mode ) && (
						<SelectControl
							label={ __( 'Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Post Style.', 'impeka-gutenberg-extension' ) }
							value={ style }
							options={
								[
									{ value: 'style-1', label: __( 'Style 1', 'impeka-gutenberg-extension' ) },
									{ value: 'style-2', label: __( 'Style 2', 'impeka-gutenberg-extension' ) },
									{ value: 'style-3', label: __( 'Style 3', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { style: val } ); } }
						/>
						)}
						{ ( 'small' == mode ) && (
						<SelectControl
							label={ __( 'Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Post Style.', 'impeka-gutenberg-extension' ) }
							value={ small_style }
							options={
								[
									{ value: 'style-small-1', label: __( 'Style 1', 'impeka-gutenberg-extension' ) },
									{ value: 'style-small-2', label: __( 'Style 2', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { small_style: val } ); } }
						/>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && (
						<ToggleControl
							label={ __( 'Custom Overview Style', 'impeka-gutenberg-extension' ) }
							checked={ custom_overview }
							onChange={ val => { setAttributes( { custom_overview: ! custom_overview } ); } }
						/>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && ( 'style-2' == style || 'style-3' == style ) && (
						<Fragment>
						<SelectControl
							label={ __( 'Heading Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the heading color.', 'impeka-gutenberg-extension' ) }
							value={ heading_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { heading_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Text Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the text color.', 'impeka-gutenberg-extension' ) }
							value={ text_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { text_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Meta Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the meta color.', 'impeka-gutenberg-extension' ) }
							value={ meta_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { meta_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Background Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the background color.', 'impeka-gutenberg-extension' ) }
							value={ bg_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { bg_color: val } ); } }
						/>
						</Fragment>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && ( 'style-2' == style ) && (
						<SelectControl
							label={ __( 'Border Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the border color.', 'impeka-gutenberg-extension' ) }
							value={ border_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { border_color: val } ); } }
						/>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && ( 'style-3' == style ) && (
						<SelectControl
							label={ __( 'Overlay Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the overlay color.', 'impeka-gutenberg-extension' ) }
							value={ overlay_color }
							options={ grveGetColorArray( ['default', 'primary', 'gradient', 'standard'] ) }
							onChange={ val => { setAttributes( { overlay_color: val } ); } }
						/>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && ( 'style-3' == style ) && (
						<SelectControl
							label={ __( 'Overlay Opacity', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the opacity for the overlay.', 'impeka-gutenberg-extension' ) }
							value={ overlay_opacity }
							options={ grveSelectOptions[ "overlay_opacity" ] }
							onChange={ val => { setAttributes( { overlay_opacity: val } ); } }
						/>

						)}
						<SelectControl
							label={ __( 'Shadow', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose shadow.', 'impeka-gutenberg-extension' ) }
							value={ shadow }
							options={ grveSelectOptions[ "shadow" ] }
							onChange={ val => { setAttributes( { shadow: val } ); } }
						/>
						<SelectControl
							label={ __( 'Border Radius', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose border radius', 'impeka-gutenberg-extension' ) }
							value={ radius }
							options={ grveSelectOptions[ "radius" ] }
							onChange={ val => { setAttributes( { radius: val } ); } }
						/>
						{ ( 'grid' == mode || 'masonry' == mode ) && ( 'style-2' == style || 'style-3' == style ) && (
						<SelectControl
							label={ __( 'Indicator', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the indicator.', 'impeka-gutenberg-extension' ) }
							value={ indicator }
							options={ grveSelectOptions[ "indicator" ] }
							onChange={ val => { setAttributes( { indicator: val } ); } }
						/>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && ( 'style-2' == style || 'style-3' == style ) && ( 'text' == indicator ) && (
						<TextControl
							label={ __( 'Indicator Text', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type your indicator text.', 'impeka-gutenberg-extension' ) }
							value={ indicator_text }
							onChange={ val => { setAttributes( { indicator_text: val } ); } }
						/>
						)}
						{ ( 'grid' == mode || 'masonry' == mode ) && ( 'style-2' == style || 'style-3' == style ) && ( 'none' != indicator ) && (
						<SelectControl
							label={ __( 'Indicator Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the indicator color.', 'impeka-gutenberg-extension' ) }
							value={ indicator_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { indicator_color: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Titles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Post Title Tag', 'impeka-gutenberg-extension' ) }
							help={ __( 'Post Title Tag for SEO.', 'impeka-gutenberg-extension' ) }
							value={ title_heading_tag }
							options={ grveSelectOptions[ "heading_tag" ] }
							onChange={ val => { setAttributes( { title_heading_tag: val } ); } }
						/>
						<SelectControl
							label={ __( 'Post Title Size/Typography', 'impeka-gutenberg-extension' ) }
							help={ __( 'Post Title size and typography, defined in Theme Options - Typography Options', 'impeka-gutenberg-extension' ) }
							value={ title_heading }
							options={ grveSelectOptions[ "heading_auto" ] }
							onChange={ val => { setAttributes( { title_heading: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Pagination', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Posts per page', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter how many posts per page you want to display.', 'impeka-gutenberg-extension' ) }
							value={ posts_per_page }
							onChange={ val => { setAttributes( { posts_per_page: val } ); } }
						/>
						{ ( 'large' != mode ) && (
						<SelectControl
							label={ __( 'Display Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select Show All or define your pagination style.', 'impeka-gutenberg-extension' ) }
							value={ display_style }
							options={ grveSelectOptions[ "display_style" ] }
							onChange={ val => { setAttributes( { display_style: val } ); } }
						/>
						)}
						{ ( 'load-more' == display_style ) && (
						<TextControl
							label={ __( 'Load More Title', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title for load more.', 'impeka-gutenberg-extension' ) }
							value={ load_more_title }
							onChange={ val => { setAttributes( { load_more_title: val } ); } }
						/>
						)}
						{ ( 'large' == mode ) && (
						<SelectControl
							label={ __( 'Display Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select Show All or define your pagination style.', 'impeka-gutenberg-extension' ) }
							value={ display_large_style }
							options={ grveSelectOptions[ "display_large_style" ] }
							onChange={ val => { setAttributes( { display_large_style: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Extras', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Link Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the link type of your post items.', 'impeka-gutenberg-extension' ) }
							value={ link_type }
							options={
								[
									{ value: 'item', label: __( 'Classic Post', 'impeka-gutenberg-extension' ) },
									{ value: 'quick-view', label: __( 'Quick View', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { link_type: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Author Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the author field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_author }
							onChange={ val => { setAttributes( { show_author: ! show_author } ); } }
						/>
						<ToggleControl
							label={ __( 'Date Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the date field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_date }
							onChange={ val => { setAttributes( { show_date: ! show_date } ); } }
						/>
						<ToggleControl
							label={ __( 'Comments Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the comments field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_comments }
							onChange={ val => { setAttributes( { show_comments: ! show_comments } ); } }
						/>
						<ToggleControl
							label={ __( 'Like Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the like field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_like }
							onChange={ val => { setAttributes( { show_like: ! show_like } ); } }
						/>
						<ToggleControl
							label={ __( 'Categories Field Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable the like field of your blog overview.', 'impeka-gutenberg-extension' ) }
							checked={ show_categories }
							onChange={ val => { setAttributes( { show_categories: ! show_categories } ); } }
						/>
						{ show_categories && (
						<SelectControl
							label={ __( 'Categories Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your category mode.', 'impeka-gutenberg-extension' ) }
							value={ categories_mode }
							options={
								[
									{ value: 'all', label: __( 'All', 'impeka-gutenberg-extension' ) },
									{ value: 'one', label: __( 'First / Primary', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { categories_mode: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Filters', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						{ ( 'grid' == mode || 'masonry' == mode ) && (
						<Fragment>
						<ToggleControl
							label={ __( 'Filter', 'impeka-gutenberg-extension' ) }
							help={ __( 'If selected, an isotope filter will be displayed.', 'impeka-gutenberg-extension' ) }
							checked={ filter }
							onChange={ val => { setAttributes( { filter: ! filter } ); } }
						/>
						{ filter && (
						<Fragment>
						<TextControl
							label={ __( 'Filter All Text', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the text to show all filters ( Default is: All ).', 'impeka-gutenberg-extension' ) }
							value={ filter_all_text }
							onChange={ val => { setAttributes( { filter_all_text: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Order By', 'impeka-gutenberg-extension' ) }
							value={ filter_order_by }
							options={ grveSelectOptions[ "filter_order_by" ] }
							onChange={ val => { setAttributes( { filter_order_by: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Order', 'impeka-gutenberg-extension' ) }
							value={ filter_order }
							options={ grveSelectOptions[ "filter_order" ] }
							onChange={ val => { setAttributes( { filter_order: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Style', 'impeka-gutenberg-extension' ) }
							value={ filter_style }
							options={ grveSelectOptions[ "filter_style" ] }
							onChange={ val => { setAttributes( { filter_style: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Shape', 'impeka-gutenberg-extension' ) }
							value={ filter_shape }
							options={ grveSelectOptions[ "filter_shape" ] }
							onChange={ val => { setAttributes( { filter_shape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Color', 'impeka-gutenberg-extension' ) }
							value={ filter_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { filter_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Align', 'impeka-gutenberg-extension' ) }
							value={ filter_align }
							options={ grveSelectOptions[ "filter_align" ] }
							onChange={ val => { setAttributes( { filter_align: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Go To Top', 'impeka-gutenberg-extension' ) }
							value={ filter_gototop }
							options={ grveSelectOptions[ "filter_gototop" ] }
							onChange={ val => { setAttributes( { filter_gototop: val } ); } }
						/>
						</Fragment>
						)}
						</Fragment>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Categories', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Exclude Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-gutenberg-extension' ) }
							value={ exclude_posts }
							onChange={ val => { setAttributes( { exclude_posts: val } ); } }
						/>
						{ categoryQueryControls() }
						<TextControl
							label={ __( 'Include Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-gutenberg-extension' ) }
							value={ include_posts }
							onChange={ val => { setAttributes( { include_posts: val } ); } }
						/>
					</PanelBody>
				</InspectorControls>
				<ServerSideRender block="impeka/blog" attributes={ attributes } />
			</Fragment>
		);
    }
}