/**
 * BLOCK: List Title
 *
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */

//Import Edit
import edit from "./edit";

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;

registerBlockType( 'impeka/list-title', {
	title: __( 'List Title', 'impeka-gutenberg-extension' ),
	icon: <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M4 5v13h17V5H4zm10 2v3.5h-3V7h3zM6 7h3v3.5H6V7zm0 9v-3.5h3V16H6zm5 0v-3.5h3V16h-3zm8 0h-3v-3.5h3V16zm-3-5.5V7h3v3.5h-3z"/></svg>,
	category: 'impeka',
	keywords: [
		__( 'List Title', 'impeka-gutenberg-extension' ),
		__( 'list', 'impeka-gutenberg-extension' ),
		__( 'title', 'impeka-gutenberg-extension' ),
		__( 'Impeka', 'impeka-gutenberg-extension' ),
		__( 'impeka', 'impeka-gutenberg-extension' ),
	],
	edit: edit,
	save: ( ) => {
		return null;
	},
} );
