// edit.js

import { grveSelectOptions, grveGetColorArray } from '../utilities';
import get from 'lodash/get';
import apiFetch from '@wordpress/api-fetch';
import ServerSideRender from '@wordpress/server-side-render';

import { addQueryArgs } from '@wordpress/url';
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { QueryControls, TextControl, SelectControl, ToggleControl, PanelBody } from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';

const CATEGORIES_LIST_QUERY = {
	per_page: -1,
	hide_empty: true,
	_fields: 'id, name ,slug',
};

export default class ImpekaPortfolioBrokenEdit extends Component {
	constructor() {
		super( ...arguments );
		this.state = {
			categoriesList: [],

		};
	}
	componentDidMount() {
		this.isStillMounted = true;
		this.fetchRequest = apiFetch( {
			path: addQueryArgs( '/wp/v2/portfolio_category', CATEGORIES_LIST_QUERY ),

		} ).then(
			( categoriesList ) => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList } );
				}
			}
		).catch(
			() => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList: [] } );
				}
			}
		);
	}
	componentWillUnmount() {
		this.isStillMounted = false;
	}
    render() {

		const { categoriesList } = this.state;
		const { attributes, setAttributes, className } = this.props;
		const {
			layout, image_load_mode,
			order_by, order,
			animation,
			margin_bottom, el_id,
			style, indicator, indicator_text, indicator_color,
			image_effect, overlay_color, overlay_opacity,
			shadow, radius,
			title_caption,
			title_heading_tag, title_heading, title_color, title_bg_color, text_color, text_bg_color,
			items_per_page, display_style, load_more_title,
			link_type, image_popup_size, overview_type,
			exclude_posts, categories, include_posts,
		} = attributes;

		const categoryQueryControls = () => {
			const categorySuggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			const suggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			return ( <QueryControls
				categorySuggestions={ categorySuggestions }
				selectedCategories={ attributes.categories }
				onCategoryChange={ ( tokens ) => {
					const allCategories = tokens.map( ( token ) =>
						typeof token === 'string' ? suggestions[ token ] : token
					);
					setAttributes( { categories: allCategories } );
				} }
			/> );
		};

		return (
			<Fragment>
				<InspectorControls key="inspector">
					<PanelBody title={ __( 'General', 'impeka-gutenberg-extension' ) } initialOpen={ true } >
						<SelectControl
							label={ __( 'Portfolio Layout', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your portfolio layout.', 'impeka-gutenberg-extension' ) }
							value={ layout }
							options={
								[
									{ value: 'layout-1', label: __( 'Layout 1', 'impeka-gutenberg-extension' ) },
									{ value: 'layout-2', label: __( 'Layout 2', 'impeka-gutenberg-extension' ) },
									{ value: 'layout-3', label: __( 'Layout 3', 'impeka-gutenberg-extension' ) },
									{ value: 'layout-4', label: __( 'Layout 4', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { layout: val } ); } }
						/>
						<SelectControl
							label={ __( 'Image Load Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable Lazy load.', 'impeka-gutenberg-extension' ) }
							value={ image_load_mode }
							options={
								grveSelectOptions[ "image_load_mode" ]
							}
							onChange={ val => { setAttributes( { image_load_mode: val } ); } }
						/>
						<SelectControl
							label={ __( 'Order by', 'impeka-gutenberg-extension' ) }
							value={ order_by }
							options={
								grveSelectOptions[ "order_by" ]
							}
							onChange={ val => { setAttributes( { order_by: val } ); } }
						/>
						{ ( 'rand' != order_by && 'post__in' != order_by ) && (
						<SelectControl
							label={ __( 'Order', 'impeka-gutenberg-extension' ) }
							value={ order }
							options={
								grveSelectOptions[ "order" ]
							}
							onChange={ val => { setAttributes( { order: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Animation', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'impeka-gutenberg-extension' ) }
							value={ animation }
							options={
								grveSelectOptions[ "animation" ]
							}
							onChange={ val => { setAttributes( { animation: val } ); } }
						/>
						<TextControl
							label={ __( 'Bottom margin', 'impeka-gutenberg-extension' ) }
							help={ __( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-gutenberg-extension' ) }
							value={ margin_bottom }
							onChange={ val => { setAttributes( { margin_bottom: val } ); } }
						/>
						<TextControl
							label={ __( 'Element ID', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter element ID (Note: make sure it is unique)', 'impeka-gutenberg-extension' ) }
							value={ el_id }
							onChange={ val => { setAttributes( { el_id: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Styles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Portfolio Style.', 'impeka-gutenberg-extension' ) }
							value={ style }
							options={
								[
									{ value: 'style-1', label: __( 'Text below image', 'impeka-gutenberg-extension' ) },
									{ value: 'style-2', label: __( 'Split text on hover', 'impeka-gutenberg-extension' ) },
									{ value: 'style-3', label: __( 'Text on media', 'impeka-gutenberg-extension' ) },
									{ value: 'style-4', label: __( 'Tilt media on hover', 'impeka-gutenberg-extension' ) },
									{ value: 'style-5', label: __( 'Cursor effect', 'impeka-gutenberg-extension' ) },
									{ value: 'style-6', label: __( 'Mouse move effect', 'impeka-gutenberg-extension' ) },
									{ value: 'style-7', label: __( 'Gradient Overlay', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { style: val } ); } }
						/>
						{ ( 'style-5' != style ) && (
						<SelectControl
							label={ __( 'Indicator', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the indicator.', 'impeka-gutenberg-extension' ) }
							value={ indicator }
							options={ grveSelectOptions[ "indicator" ] }
							onChange={ val => { setAttributes( { indicator: val } ); } }
						/>
						)}
						{ ( 'style-5' != style ) && ( 'text' == indicator ) && (
						<TextControl
							label={ __( 'Indicator Text', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type your indicator text.', 'impeka-gutenberg-extension' ) }
							value={ indicator_text }
							onChange={ val => { setAttributes( { indicator_text: val } ); } }
						/>
						)}
						{ ( 'style-5' != style ) && ( 'none' != indicator ) && (
						<SelectControl
							label={ __( 'Indicator Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the indicator color.', 'impeka-gutenberg-extension' ) }
							value={ indicator_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { indicator_color: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Image Effect', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the grayscale effect.', 'impeka-gutenberg-extension' ) }
							value={ image_effect }
							options={ grveSelectOptions[ "image_effect" ] }
							onChange={ val => { setAttributes( { image_effect: val } ); } }
						/>
						{ ( 'style-7' != style ) && (
						<SelectControl
							label={ __( 'Overlay Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the overlay color.', 'impeka-gutenberg-extension' ) }
							value={ overlay_color }
							options={ grveGetColorArray( ['default', 'primary', 'gradient', 'standard', 'dominant'] ) }
							onChange={ val => { setAttributes( { overlay_color: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Overlay Opacity', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the opacity for the overlay.', 'impeka-gutenberg-extension' ) }
							value={ overlay_opacity }
							options={ grveSelectOptions[ "overlay_opacity" ] }
							onChange={ val => { setAttributes( { overlay_opacity: val } ); } }
						/>
						<SelectControl
							label={ __( 'Shadow', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose shadow.', 'impeka-gutenberg-extension' ) }
							value={ shadow }
							options={ grveSelectOptions[ "shadow" ] }
							onChange={ val => { setAttributes( { shadow: val } ); } }
						/>
						<SelectControl
							label={ __( 'Border Radius', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose border radius', 'impeka-gutenberg-extension' ) }
							value={ radius }
							options={ grveSelectOptions[ "radius" ] }
							onChange={ val => { setAttributes( { radius: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Titles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Image Title & Description Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Define the visibility for your title / description.', 'impeka-gutenberg-extension' ) }
							value={ title_caption }
							options={ grveSelectOptions[ "title_caption" ] }
							onChange={ val => { setAttributes( { title_caption: val } ); } }
						/>
						{ ( 'title-caption' == title_caption || 'title-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Portfolio Title Tag', 'impeka-gutenberg-extension' ) }
							help={ __( 'Portfolio Title Tag for SEO.', 'impeka-gutenberg-extension' ) }
							value={ title_heading_tag }
							options={ grveSelectOptions[ "heading_tag" ] }
							onChange={ val => { setAttributes( { title_heading_tag: val } ); } }
						/>
						)}
						{ ( 'title-caption' == title_caption || 'title-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Portfolio Title Size/Typography', 'impeka-gutenberg-extension' ) }
							help={ __( 'Portfolio Title size and typography, defined in Theme Options - Typography Options', 'impeka-gutenberg-extension' ) }
							value={ title_heading }
							options={ grveSelectOptions[ "heading" ] }
							onChange={ val => { setAttributes( { title_heading: val } ); } }
						/>
						)}
						{ ( 'title-caption' == title_caption || 'title-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Title Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the title color.', 'impeka-gutenberg-extension' ) }
							value={ title_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { title_color: val } ); } }
						/>
						)}
						{ ( 'style-5' == style ) && ( 'title-caption' == title_caption || 'title-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Title Background Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the title background color', 'impeka-gutenberg-extension' ) }
							value={ title_bg_color }
							options={ grveGetColorArray( ['transparent', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { title_bg_color: val } ); } }
						/>
						)}
						{ ( 'title-caption' == title_caption || 'caption-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Description/Text Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the description/text color.', 'impeka-gutenberg-extension' ) }
							value={ text_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { text_color: val } ); } }
						/>
						)}
						{ ( 'style-5' == style ) && ( 'title-caption' == title_caption || 'caption-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Description/Text Background Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the description/text background color', 'impeka-gutenberg-extension' ) }
							value={ text_bg_color }
							options={ grveGetColorArray( ['transparent', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { text_bg_color: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Pagination', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Items per page', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter how many items per page you want to display.', 'impeka-gutenberg-extension' ) }
							value={ items_per_page }
							onChange={ val => { setAttributes( { items_per_page: val } ); } }
						/>
						<SelectControl
							label={ __( 'Display Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select Show All or define your pagination style.', 'impeka-gutenberg-extension' ) }
							value={ display_style }
							options={ grveSelectOptions[ "display_style" ] }
							onChange={ val => { setAttributes( { display_style: val } ); } }
						/>
						{ ( 'load-more' == display_style ) && (
						<TextControl
							label={ __( 'Load More Title', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title for load more.', 'impeka-gutenberg-extension' ) }
							value={ load_more_title }
							onChange={ val => { setAttributes( { load_more_title: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Extras', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Link Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the link type of your post items.', 'impeka-gutenberg-extension' ) }
							value={ link_type }
							options={
								[
									{ value: 'item', label: __( 'Classic Portfolio', 'impeka-gutenberg-extension' ) },
									{ value: 'quick-view', label: __( 'Quick View', 'impeka-gutenberg-extension' ) },
									{ value: 'popup', label: __( 'Gallery Usage', 'impeka-gutenberg-extension' ) },
									{ value: 'custom-link', label: __( 'Custom Link', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { link_type: val } ); } }
						/>
						{ ( 'popup' != link_type ) && (
						<SelectControl
							label={ __( 'Image Popup Size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select size for your popup image.', 'impeka-gutenberg-extension' ) }
							value={ image_popup_size }
							options={ grveSelectOptions[ "image_popup_size" ] }
							onChange={ val => { setAttributes( { image_popup_size: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Overview Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the overview type of your portfolio items.', 'impeka-gutenberg-extension' ) }
							value={ overview_type }
							options={
								[
									{ value: '', label: __( 'Default', 'impeka-gutenberg-extension' ) },
									{ value: 'custom-overview', label: __( 'Custom Overview', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { overview_type: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Categories', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Exclude Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-gutenberg-extension' ) }
							value={ exclude_posts }
							onChange={ val => { setAttributes( { exclude_posts: val } ); } }
						/>
						{ categoryQueryControls() }
						<TextControl
							label={ __( 'Include Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-gutenberg-extension' ) }
							value={ include_posts }
							onChange={ val => { setAttributes( { include_posts: val } ); } }
						/>
					</PanelBody>
				</InspectorControls>
				<ServerSideRender block="impeka/portfolio-broken" attributes={ attributes } />
			</Fragment>
		);
    }
}