// edit.js

import { grveSelectOptions, grveGetColorArray } from '../utilities';
import get from 'lodash/get';
import apiFetch from '@wordpress/api-fetch';
import ServerSideRender from '@wordpress/server-side-render';

import { addQueryArgs } from '@wordpress/url';
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { QueryControls, TextControl, SelectControl, ToggleControl, PanelBody } from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';

const CATEGORIES_LIST_QUERY = {
	per_page: -1,
	hide_empty: true,
	_fields: 'id, name ,slug',
};

export default class ImpekaPortfolioCarouselEdit extends Component {
	constructor() {
		super( ...arguments );
		this.state = {
			categoriesList: [],

		};
	}
	componentDidMount() {
		this.isStillMounted = true;
		this.fetchRequest = apiFetch( {
			path: addQueryArgs( '/wp/v2/portfolio_category', CATEGORIES_LIST_QUERY ),

		} ).then(
			( categoriesList ) => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList } );
				}
			}
		).catch(
			() => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList: [] } );
				}
			}
		);
	}
	componentWillUnmount() {
		this.isStillMounted = false;
	}
    render() {

		const { categoriesList } = this.state;
		const { attributes, setAttributes, className } = this.props;
		const {
			type, image_load_mode, image_mode,
			items_per_page, items_tablet_landscape, items_tablet_portrait, items_mobile, items_to_show,
			item_gutter, gutter_size,
			order_by, order, margin_bottom,
			style, image_effect, overlay_color, overlay_opacity,
			shadow, radius,
			title_caption, title_heading_tag, title_heading, title_color, text_color,
			loop, auto_play, slideshow_speed, pause_hover,
			nav_visibility, nav_icon, nav_icon_color, nav_shape, nav_shape_type, nav_shape_color,
			pagination, pagination_speed,
			link_type, image_popup_size, overview_type,
			exclude_posts, categories, include_posts,
		} = attributes;

		const categoryQueryControls = () => {
			const categorySuggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			const suggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			return ( <QueryControls
				categorySuggestions={ categorySuggestions }
				selectedCategories={ attributes.categories }
				onCategoryChange={ ( tokens ) => {
					const allCategories = tokens.map( ( token ) =>
						typeof token === 'string' ? suggestions[ token ] : token
					);
					setAttributes( { categories: allCategories } );
				} }
			/> );
		};

		return (
			<Fragment>
				<InspectorControls key="inspector">
					<PanelBody title={ __( 'General', 'impeka-gutenberg-extension' ) } initialOpen={ true } >
						<SelectControl
							label={ __( 'Carousel Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Carousel Type.', 'impeka-gutenberg-extension' ) }
							value={ type }
							options={
								[
									{ value: 'classic', label: __( 'Classic', 'impeka-gutenberg-extension' ) },
									{ value: 'advanced', label: __( 'Advanced', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { type: val } ); } }
						/>
						<SelectControl
							label={ __( 'Image Load Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable Lazy load.', 'impeka-gutenberg-extension' ) }
							value={ image_load_mode }
							options={
								grveSelectOptions[ "image_load_mode" ]
							}
							onChange={ val => { setAttributes( { image_load_mode: val } ); } }
						/>
						<SelectControl
							label={ __( 'Image Size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Image Size.', 'impeka-gutenberg-extension' ) }
							value={ image_mode }
							options={
								[
									{ value: 'square', label: __( 'Square Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape', label: __( 'Landscape Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape-medium', label: __( 'Landscape Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait', label: __( 'Portrait Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait-medium', label: __( 'Portrait Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'large', label: __( 'Resize ( Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium_large', label: __( 'Resize ( Medium Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium', label: __( 'Resize ( Medium )', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { image_mode: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items per page', 'impeka-gutenberg-extension' ) }
							help={ __( 'Number of items per page', 'impeka-gutenberg-extension' ) }
							value={ items_per_page }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
									{ value: '6', label: '6' },
								]
							}
							onChange={ val => { setAttributes( { items_per_page: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Tablet Landscape', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on tablet devices, landscape orientation.', 'impeka-gutenberg-extension' ) }
							value={ items_tablet_landscape }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { items_tablet_landscape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Tablet Portrait', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on tablet devices, portrait orientation.', 'impeka-gutenberg-extension' ) }
							value={ items_tablet_portrait }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { items_tablet_portrait: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Mobile', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on mobile devices.', 'impeka-gutenberg-extension' ) }
							value={ items_mobile }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
								]
							}
							onChange={ val => { setAttributes( { items_mobile: val } ); } }
						/>
						<TextControl
							label={ __( 'Items to show', 'impeka-gutenberg-extension' ) }
							help={ __( 'Maximum Items to Show', 'impeka-gutenberg-extension' ) }
							value={ items_to_show }
							onChange={ val => { setAttributes( { items_to_show: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Gutter between items', 'impeka-gutenberg-extension' ) }
							help={ __( 'Add gutter among items.', 'impeka-gutenberg-extension' ) }
							checked={ item_gutter }
							onChange={ val => { setAttributes( { item_gutter: ! item_gutter } ); } }
						/>
						{ item_gutter && (
						<TextControl
							label={ __( 'Gutter Size', 'impeka-gutenberg-extension' ) }
							value={ gutter_size }
							onChange={ val => { setAttributes( { gutter_size: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Order by', 'impeka-gutenberg-extension' ) }
							value={ order_by }
							options={
								grveSelectOptions[ "order_by" ]
							}
							onChange={ val => { setAttributes( { order_by: val } ); } }
						/>
						{ ( 'rand' != order_by && 'post__in' != order_by ) && (
						<SelectControl
							label={ __( 'Order', 'impeka-gutenberg-extension' ) }
							value={ order }
							options={
								grveSelectOptions[ "order" ]
							}
							onChange={ val => { setAttributes( { order: val } ); } }
						/>
						)}
						<TextControl
							label={ __( 'Bottom margin', 'impeka-gutenberg-extension' ) }
							help={ __( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-gutenberg-extension' ) }
							value={ margin_bottom }
							onChange={ val => { setAttributes( { margin_bottom: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Styles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Portfolio Style.', 'impeka-gutenberg-extension' ) }
							value={ style }
							options={
								[
									{ value: 'style-1', label: __( 'Text below image', 'impeka-gutenberg-extension' ) },
									{ value: 'style-2', label: __( 'Split text on hover', 'impeka-gutenberg-extension' ) },
									{ value: 'style-3', label: __( 'Text on media', 'impeka-gutenberg-extension' ) },
									{ value: 'style-6', label: __( 'Mouse move effect', 'impeka-gutenberg-extension' ) },
									{ value: 'style-7', label: __( 'Gradient Overlay', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { style: val } ); } }
						/>
						<SelectControl
							label={ __( 'Image Effect', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the grayscale effect.', 'impeka-gutenberg-extension' ) }
							value={ image_effect }
							options={ grveSelectOptions[ "image_effect" ] }
							onChange={ val => { setAttributes( { image_effect: val } ); } }
						/>
						{ ( 'style-7' != style ) && (
						<SelectControl
							label={ __( 'Overlay Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the overlay color.', 'impeka-gutenberg-extension' ) }
							value={ overlay_color }
							options={ grveGetColorArray( ['default', 'primary', 'gradient', 'standard', 'dominant'] ) }
							onChange={ val => { setAttributes( { overlay_color: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Overlay Opacity', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the opacity for the overlay.', 'impeka-gutenberg-extension' ) }
							value={ overlay_opacity }
							options={ grveSelectOptions[ "overlay_opacity" ] }
							onChange={ val => { setAttributes( { overlay_opacity: val } ); } }
						/>
						<SelectControl
							label={ __( 'Shadow', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose shadow.', 'impeka-gutenberg-extension' ) }
							value={ shadow }
							options={ grveSelectOptions[ "shadow" ] }
							onChange={ val => { setAttributes( { shadow: val } ); } }
						/>
						<SelectControl
							label={ __( 'Border Radius', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose border radius', 'impeka-gutenberg-extension' ) }
							value={ radius }
							options={ grveSelectOptions[ "radius" ] }
							onChange={ val => { setAttributes( { radius: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Titles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Image Title & Description Visibility', 'impeka-gutenberg-extension' ) }
							help={ __( 'Define the visibility for your title / description.', 'impeka-gutenberg-extension' ) }
							value={ title_caption }
							options={ grveSelectOptions[ "title_caption" ] }
							onChange={ val => { setAttributes( { title_caption: val } ); } }
						/>
						{ ( 'title-caption' == title_caption || 'title-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Portfolio Title Tag', 'impeka-gutenberg-extension' ) }
							help={ __( 'Portfolio Title Tag for SEO.', 'impeka-gutenberg-extension' ) }
							value={ title_heading_tag }
							options={ grveSelectOptions[ "heading_tag" ] }
							onChange={ val => { setAttributes( { title_heading_tag: val } ); } }
						/>
						)}
						{ ( 'title-caption' == title_caption || 'title-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Portfolio Title Size/Typography', 'impeka-gutenberg-extension' ) }
							help={ __( 'Portfolio Title size and typography, defined in Theme Options - Typography Options', 'impeka-gutenberg-extension' ) }
							value={ title_heading }
							options={ grveSelectOptions[ "heading" ] }
							onChange={ val => { setAttributes( { title_heading: val } ); } }
						/>
						)}
						{ ( 'title-caption' == title_caption || 'title-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Title Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the title color.', 'impeka-gutenberg-extension' ) }
							value={ title_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { title_color: val } ); } }
						/>
						)}
						{ ( 'title-caption' == title_caption || 'caption-only' == title_caption ) && (
						<SelectControl
							label={ __( 'Description/Text Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the description/text color.', 'impeka-gutenberg-extension' ) }
							value={ text_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { text_color: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Navigation & Pagination', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<ToggleControl
							label={ __( 'Loop', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable loop.', 'impeka-gutenberg-extension' ) }
							checked={ loop }
							onChange={ val => { setAttributes( { loop: ! loop } ); } }
						/>
						<ToggleControl
							label={ __( 'Autoplay', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable autoplay.', 'impeka-gutenberg-extension' ) }
							checked={ auto_play }
							onChange={ val => { setAttributes( { auto_play: ! auto_play } ); } }
						/>
						{ 'classic' == type && (
						<TextControl
							label={ __( 'Slideshow Speed', 'impeka-gutenberg-extension' ) }
							help={ __( 'Slideshow Speed in ms.', 'impeka-gutenberg-extension' ) }
							value={ slideshow_speed }
							onChange={ val => { setAttributes( { slideshow_speed: val } ); } }
						/>
						)}
						{ 'classic' == type && (
						<ToggleControl
							label={ __( 'Pause on Hover', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable pause on hover.', 'impeka-gutenberg-extension' ) }
							checked={ pause_hover }
							onChange={ val => { setAttributes( { pause_hover: ! pause_hover } ); } }
						/>
						)}
						<ToggleControl
							label={ __( 'Navigation', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable navigation.', 'impeka-gutenberg-extension' ) }
							checked={ nav_visibility }
							onChange={ val => { setAttributes( { nav_visibility: ! nav_visibility } ); } }
						/>
						{ nav_visibility && (
						<SelectControl
							label={ __( 'Navigation Icon', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation icon.', 'impeka-gutenberg-extension' ) }
							value={ nav_icon }
							options={ grveSelectOptions[ "nav_icon" ] }
							onChange={ val => { setAttributes( { nav_icon: val } ); } }
						/>
						)}
						{ nav_visibility && (
						<SelectControl
							label={ __( 'Icon Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation icon color.', 'impeka-gutenberg-extension' ) }
							value={ nav_icon_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { nav_icon_color: val } ); } }
						/>
						)}
						{ nav_visibility && (
						<SelectControl
							label={ __( 'Navigation Shape', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation shape.', 'impeka-gutenberg-extension' ) }
							value={ nav_shape }
							options={ grveSelectOptions[ "nav_shape" ] }
							onChange={ val => { setAttributes( { nav_shape: val } ); } }
						/>
						)}
						{ ( nav_visibility && '' != nav_shape ) && (
						<SelectControl
							label={ __( 'Navigation Shape Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation shape type.', 'impeka-gutenberg-extension' ) }
							value={ nav_shape_type }
							options={ grveSelectOptions[ "nav_shape_type" ] }
							onChange={ val => { setAttributes( { nav_shape_type: val } ); } }
						/>
						)}
						{ ( nav_visibility && '' != nav_shape ) && (
						<SelectControl
							label={ __( 'Navigation Shape Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Navigation shape color.', 'impeka-gutenberg-extension' ) }
							value={ nav_shape_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { nav_shape_color: val } ); } }
						/>
						)}
						<ToggleControl
							label={ __( 'Pagination', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable pagination.', 'impeka-gutenberg-extension' ) }
							checked={ pagination }
							onChange={ val => { setAttributes( { pagination: ! pagination } ); } }
						/>
						{ ( 'classic' == type && pagination ) && (
						<TextControl
							label={ __( 'Pagination Speed', 'impeka-gutenberg-extension' ) }
							help={ __( 'Pagination Speed in ms.', 'impeka-gutenberg-extension' ) }
							value={ pagination_speed }
							onChange={ val => { setAttributes( { pagination_speed: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Extras', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Link Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the link type of your post items.', 'impeka-gutenberg-extension' ) }
							value={ link_type }
							options={
								[
									{ value: 'item', label: __( 'Classic Portfolio', 'impeka-gutenberg-extension' ) },
									{ value: 'quick-view', label: __( 'Quick View', 'impeka-gutenberg-extension' ) },
									{ value: 'popup', label: __( 'Gallery Usage', 'impeka-gutenberg-extension' ) },
									{ value: 'custom-link', label: __( 'Custom Link', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { link_type: val } ); } }
						/>
						{ ( 'popup' != link_type ) && (
						<SelectControl
							label={ __( 'Image Popup Size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select size for your popup image.', 'impeka-gutenberg-extension' ) }
							value={ image_popup_size }
							options={ grveSelectOptions[ "image_popup_size" ] }
							onChange={ val => { setAttributes( { image_popup_size: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Overview Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the overview type of your portfolio items.', 'impeka-gutenberg-extension' ) }
							value={ overview_type }
							options={
								[
									{ value: '', label: __( 'Default', 'impeka-gutenberg-extension' ) },
									{ value: 'custom-overview', label: __( 'Custom Overview', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { overview_type: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Categories', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Exclude Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-gutenberg-extension' ) }
							value={ exclude_posts }
							onChange={ val => { setAttributes( { exclude_posts: val } ); } }
						/>
						{ categoryQueryControls() }
						<TextControl
							label={ __( 'Include Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-gutenberg-extension' ) }
							value={ include_posts }
							onChange={ val => { setAttributes( { include_posts: val } ); } }
						/>
					</PanelBody>
				</InspectorControls>
				<ServerSideRender block="impeka/portfolio-carousel" attributes={ attributes } />
			</Fragment>
		);
    }
}