/**
 * BLOCK: Products Carousel
 *
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */

//Import Edit
import edit from "./edit";

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;

registerBlockType( 'impeka/products-carousel', {
	title: __( 'Products Carousel', 'impeka-gutenberg-extension' ),
	icon: <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M2 6h4v11H2zm5 13h10V4H7v15zM9 6h6v11H9V6zm9 0h4v11h-4z"/></svg>,
	category: 'impeka',
	keywords: [
		__( 'Products Carousel', 'impeka-gutenberg-extension' ),
		__( 'carousel', 'impeka-gutenberg-extension' ),
		__( 'products', 'impeka-gutenberg-extension' ),
		__( 'Impeka', 'impeka-gutenberg-extension' ),
		__( 'impeka', 'impeka-gutenberg-extension' ),
	],
	edit: edit,
	save: ( ) => {
		return null;
	},
} );
