// edit.js

import { grveSelectOptions, grveGetColorArray } from '../utilities';
import get from 'lodash/get';
import apiFetch from '@wordpress/api-fetch';
import ServerSideRender from '@wordpress/server-side-render';

import { addQueryArgs } from '@wordpress/url';
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { QueryControls, TextControl, SelectControl, ToggleControl, PanelBody } from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';

const CATEGORIES_LIST_QUERY = {
	per_page: -1,
	hide_empty: true,
	_fields: 'id, name ,slug',
};

export default class ImpekaProductsEdit extends Component {
	constructor() {
		super( ...arguments );
		this.state = {
			categoriesList: [],

		};
	}
	componentDidMount() {
		this.isStillMounted = true;
		this.fetchRequest = apiFetch( {
			path: addQueryArgs( '/wc/v2/products/categories', CATEGORIES_LIST_QUERY ),

		} ).then(
			( categoriesList ) => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList } );
				}
			}
		).catch(
			() => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList: [] } );
				}
			}
		);
	}
	componentWillUnmount() {
		this.isStillMounted = false;
	}
    render() {

		const { categoriesList } = this.state;
		const { attributes, setAttributes, className } = this.props;
		const {
			mode, grid_image_mode, masonry_image_mode,
			columns_large_screen, columns, columns_tablet_landscape, columns_tablet_portrait, columns_mobile,
			item_gutter, gutter_size,
			order_by, order,
			animation,
			margin_bottom, el_id,
			title_heading_tag, title_heading,
			hover_style, second_image_effect,
			text_color, overlay_color, overlay_opacity,
			items_per_page, display_style, load_more_title,
			link_type, quick_view_title,
			filter, filter_all_text, filter_order_by, filter_order, filter_style, filter_shape, filter_color, filter_align, filter_gototop,
			exclude_posts, categories, include_posts,
		} = attributes;

		const categoryQueryControls = () => {
			const categorySuggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			const suggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			return ( <QueryControls
				categorySuggestions={ categorySuggestions }
				selectedCategories={ attributes.categories }
				onCategoryChange={ ( tokens ) => {
					const allCategories = tokens.map( ( token ) =>
						typeof token === 'string' ? suggestions[ token ] : token
					);
					setAttributes( { categories: allCategories } );
				} }
			/> );
		};

		return (
			<Fragment>
				<InspectorControls key="inspector">
					<PanelBody title={ __( 'General', 'impeka-gutenberg-extension' ) } initialOpen={ true } >
						<SelectControl
							label={ __( 'Products Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Products Mode.', 'impeka-gutenberg-extension' ) }
							value={ mode }
							options={
								[
									{ value: 'masonry', label: __( 'Masonry', 'impeka-gutenberg-extension' ) },
									{ value: 'grid', label: __( 'Grid', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { mode: val } ); } }
						/>
						{ ( 'grid' == mode ) && (
						<SelectControl
							label={ __( 'Grid Image size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Image Size.', 'impeka-gutenberg-extension' ) }
							value={ grid_image_mode }
							options={
								[
									{ value: 'square', label: __( 'Square Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape', label: __( 'Landscape Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'landscape-medium', label: __( 'Landscape Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait', label: __( 'Portrait Small Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'portrait-medium', label: __( 'Portrait Medium Crop', 'impeka-gutenberg-extension' ) },
									{ value: 'large', label: __( 'Resize ( Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium_large', label: __( 'Resize ( Medium Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium', label: __( 'Resize ( Medium )', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { grid_image_mode: val } ); } }
						/>
						)}
						{ 'masonry' == mode && (
						<SelectControl
							label={ __( 'Masonry Image Size', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Image Size.', 'impeka-gutenberg-extension' ) }
							value={ masonry_image_mode }
							options={
								[
									{ value: 'large', label: __( 'Resize ( Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium_large', label: __( 'Resize ( Medium Large )', 'impeka-gutenberg-extension' ) },
									{ value: 'medium', label: __( 'Resize ( Medium )', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { masonry_image_mode: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Large Screen Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the number of columns for large screens.', 'impeka-gutenberg-extension' ) }
							value={ columns_large_screen }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
								]
							}
							onChange={ val => { setAttributes( { columns_large_screen: val } ); } }
						/>
						<SelectControl
							label={ __( 'Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the number of columns for normal screens.', 'impeka-gutenberg-extension' ) }
							value={ columns }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
								]
							}
							onChange={ val => { setAttributes( { columns: val } ); } }
						/>
						<SelectControl
							label={ __( 'Tablet Landscape Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on tablet devices, landscape orientation.', 'impeka-gutenberg-extension' ) }
							value={ columns_tablet_landscape }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { columns_tablet_landscape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Tablet Portrait Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on tablet devices, portrait orientation.', 'impeka-gutenberg-extension' ) }
							value={ columns_tablet_portrait }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { columns_tablet_portrait: val } ); } }
						/>
						<SelectControl
							label={ __( 'Mobile Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on mobile devices.', 'impeka-gutenberg-extension' ) }
							value={ columns_mobile }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
								]
							}
							onChange={ val => { setAttributes( { columns_mobile: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Gutter between items', 'impeka-gutenberg-extension' ) }
							help={ __( 'Add gutter among items.', 'impeka-gutenberg-extension' ) }
							checked={ item_gutter }
							onChange={ val => { setAttributes( { item_gutter: ! item_gutter } ); } }
						/>
						{ item_gutter && (
						<TextControl
							label={ __( 'Gutter Size', 'impeka-gutenberg-extension' ) }
							value={ gutter_size }
							onChange={ val => { setAttributes( { gutter_size: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Order by', 'impeka-gutenberg-extension' ) }
							value={ order_by }
							options={
								grveSelectOptions[ "order_by" ]
							}
							onChange={ val => { setAttributes( { order_by: val } ); } }
						/>
						{ ( 'rand' != order_by && 'post__in' != order_by ) && (
						<SelectControl
							label={ __( 'Order', 'impeka-gutenberg-extension' ) }
							value={ order }
							options={
								grveSelectOptions[ "order" ]
							}
							onChange={ val => { setAttributes( { order: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Animation', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'impeka-gutenberg-extension' ) }
							value={ animation }
							options={
								grveSelectOptions[ "animation" ]
							}
							onChange={ val => { setAttributes( { animation: val } ); } }
						/>
						<TextControl
							label={ __( 'Bottom margin', 'impeka-gutenberg-extension' ) }
							help={ __( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-gutenberg-extension' ) }
							value={ margin_bottom }
							onChange={ val => { setAttributes( { margin_bottom: val } ); } }
						/>
						<TextControl
							label={ __( 'Element ID', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter element ID (Note: make sure it is unique)', 'impeka-gutenberg-extension' ) }
							value={ el_id }
							onChange={ val => { setAttributes( { el_id: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Titles & Hovers', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Title Tag', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title Tag for SEO.', 'impeka-gutenberg-extension' ) }
							value={ title_heading_tag }
							options={ grveSelectOptions[ "heading_tag" ] }
							onChange={ val => { setAttributes( { title_heading_tag: val } ); } }
						/>
						<SelectControl
							label={ __( 'Title Size/Typography', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-gutenberg-extension' ) }
							value={ title_heading }
							options={ grveSelectOptions[ "heading" ] }
							onChange={ val => { setAttributes( { title_heading: val } ); } }
						/>
						<SelectControl
							label={ __( 'Hover Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your hover style.', 'impeka-gutenberg-extension' ) }
							value={ hover_style }
							options={
								[
									{ value: 'hover-style-1', label: __( 'Text below image', 'impeka-gutenberg-extension' ) },
									{ value: 'hover-style-2', label: __( 'Split text on hover', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { hover_style: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Second Image Effect', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose if you want second image effect.', 'impeka-gutenberg-extension' ) }
							checked={ second_image_effect }
							onChange={ val => { setAttributes( { second_image_effect: ! second_image_effect } ); } }
						/>
						<SelectControl
							label={ __( 'Text Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose text color.', 'impeka-gutenberg-extension' ) }
							value={ text_color }
							options={ grveGetColorArray( ['default', 'primary', 'standard'] ) }
							onChange={ val => { setAttributes( { text_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Overlay Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the overlay color.', 'impeka-gutenberg-extension' ) }
							value={ overlay_color }
							options={ grveGetColorArray( ['primary', 'standard'] ) }
							onChange={ val => { setAttributes( { overlay_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Overlay Opacity', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the opacity for the overlay.', 'impeka-gutenberg-extension' ) }
							value={ overlay_opacity }
							options={ grveSelectOptions[ "overlay_opacity" ] }
							onChange={ val => { setAttributes( { overlay_opacity: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Pagination', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Items per page', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter how many items per page you want to display.', 'impeka-gutenberg-extension' ) }
							value={ items_per_page }
							onChange={ val => { setAttributes( { items_per_page: val } ); } }
						/>
						<SelectControl
							label={ __( 'Display Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select Show All or define your pagination style.', 'impeka-gutenberg-extension' ) }
							value={ display_style }
							options={ grveSelectOptions[ "display_style" ] }
							onChange={ val => { setAttributes( { display_style: val } ); } }
						/>
						{ ( 'load-more' == display_style ) && (
						<TextControl
							label={ __( 'Load More Title', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title for load more.', 'impeka-gutenberg-extension' ) }
							value={ load_more_title }
							onChange={ val => { setAttributes( { load_more_title: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Extras', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Link Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the link type of your product items.', 'impeka-gutenberg-extension' ) }
							value={ link_type }
							options={
								[
									{ value: 'item', label: __( 'Classic Product', 'impeka-gutenberg-extension' ) },
									{ value: 'quick-view', label: __( 'Quick View', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { link_type: val } ); } }
						/>
						{ ( 'quick-view' == link_type ) && (
						<TextControl
							label={ __( 'Quick View Title', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title for quick view.', 'impeka-gutenberg-extension' ) }
							value={ quick_view_title }
							onChange={ val => { setAttributes( { quick_view_title: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Filters', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<ToggleControl
							label={ __( 'Filter', 'impeka-gutenberg-extension' ) }
							help={ __( 'If selected, an isotope filter will be displayed.', 'impeka-gutenberg-extension' ) }
							checked={ filter }
							onChange={ val => { setAttributes( { filter: ! filter } ); } }
						/>
						{ filter && (
						<Fragment>
						<TextControl
							label={ __( 'Filter All Text', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the text to show all filters ( Default is: All ).', 'impeka-gutenberg-extension' ) }
							value={ filter_all_text }
							onChange={ val => { setAttributes( { filter_all_text: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Order By', 'impeka-gutenberg-extension' ) }
							value={ filter_order_by }
							options={ grveSelectOptions[ "filter_order_by" ] }
							onChange={ val => { setAttributes( { filter_order_by: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Order', 'impeka-gutenberg-extension' ) }
							value={ filter_order }
							options={ grveSelectOptions[ "filter_order" ] }
							onChange={ val => { setAttributes( { filter_order: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Style', 'impeka-gutenberg-extension' ) }
							value={ filter_style }
							options={ grveSelectOptions[ "filter_style" ] }
							onChange={ val => { setAttributes( { filter_style: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Shape', 'impeka-gutenberg-extension' ) }
							value={ filter_shape }
							options={ grveSelectOptions[ "filter_shape" ] }
							onChange={ val => { setAttributes( { filter_shape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Color', 'impeka-gutenberg-extension' ) }
							value={ filter_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { filter_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Align', 'impeka-gutenberg-extension' ) }
							value={ filter_align }
							options={ grveSelectOptions[ "filter_align" ] }
							onChange={ val => { setAttributes( { filter_align: val } ); } }
						/>
						<SelectControl
							label={ __( 'Filter Go To Top', 'impeka-gutenberg-extension' ) }
							value={ filter_gototop }
							options={ grveSelectOptions[ "filter_gototop" ] }
							onChange={ val => { setAttributes( { filter_gototop: val } ); } }
						/>
						</Fragment>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Categories', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Exclude Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-gutenberg-extension' ) }
							value={ exclude_posts }
							onChange={ val => { setAttributes( { exclude_posts: val } ); } }
						/>
						{ categoryQueryControls() }
						<TextControl
							label={ __( 'Include Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-gutenberg-extension' ) }
							value={ include_posts }
							onChange={ val => { setAttributes( { include_posts: val } ); } }
						/>
					</PanelBody>
				</InspectorControls>
				<ServerSideRender block="impeka/products" attributes={ attributes } />
			</Fragment>
		);
    }
}