// edit.js

import { grveSelectOptions, grveGetColorArray } from '../utilities';
import get from 'lodash/get';
import apiFetch from '@wordpress/api-fetch';
import ServerSideRender from '@wordpress/server-side-render';

import { addQueryArgs } from '@wordpress/url';
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { QueryControls, TextControl, SelectControl, ToggleControl, PanelBody } from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';

const CATEGORIES_LIST_QUERY = {
	per_page: -1,
	hide_empty: true,
	_fields: 'id, name ,slug',
};

export default class ImpekaTestimonialCarouselEdit extends Component {
	constructor() {
		super( ...arguments );
		this.state = {
			categoriesList: [],

		};
	}
	componentDidMount() {
		this.isStillMounted = true;
		this.fetchRequest = apiFetch( {
			path: addQueryArgs( '/wp/v2/testimonial_category', CATEGORIES_LIST_QUERY ),

		} ).then(
			( categoriesList ) => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList } );
				}
			}
		).catch(
			() => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList: [] } );
				}
			}
		);
	}
	componentWillUnmount() {
		this.isStillMounted = false;
	}
    render() {

		const { categoriesList } = this.state;
		const { attributes, setAttributes, className } = this.props;
		const {
			style, type,
			items_per_page, items_tablet_landscape, items_tablet_portrait, items_mobile, items_to_show,
			item_gutter, gutter_size,
			order_by, order, margin_bottom,
			show_title, heading_tag, heading, title_color, text_color, text_style, bg_color,
			show_image, align,
			shadow, radius,
			loop, auto_play, slideshow_speed, pause_hover, auto_height,
			pagination, pagination_speed,
			exclude_posts, categories, include_posts,
		} = attributes;

		const categoryQueryControls = () => {
			const categorySuggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			const suggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			return ( <QueryControls
				categorySuggestions={ categorySuggestions }
				selectedCategories={ attributes.categories }
				onCategoryChange={ ( tokens ) => {
					const allCategories = tokens.map( ( token ) =>
						typeof token === 'string' ? suggestions[ token ] : token
					);
					setAttributes( { categories: allCategories } );
				} }
			/> );
		};

		return (
			<Fragment>
				<InspectorControls key="inspector">
					<PanelBody title={ __( 'General', 'impeka-gutenberg-extension' ) } initialOpen={ true } >
						<SelectControl
							label={ __( 'Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your testimonial Style.', 'impeka-gutenberg-extension' ) }
							value={ style }
							options={
								[
									{ value: 'style-1', label: __( 'Style 1 ( Classic )', 'impeka-gutenberg-extension' ) },
									{ value: 'style-2', label: __( 'Style 2 ( Classic )', 'impeka-gutenberg-extension' ) },
									{ value: 'style-3', label: __( 'Style 3 ( Classic )', 'impeka-gutenberg-extension' ) },
									{ value: 'style-4', label: __( 'Style 4', 'impeka-gutenberg-extension' ) },
									{ value: 'style-5', label: __( 'Style 5', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { style: val } ); } }
						/>
						{ ( 'style-4' == style || 'style-5' == style ) && (
						<Fragment>
						<SelectControl
							label={ __( 'Carousel Type', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Carousel Type.', 'impeka-gutenberg-extension' ) }
							value={ type }
							options={
								[
									{ value: 'classic', label: __( 'Classic', 'impeka-gutenberg-extension' ) },
									{ value: 'advanced', label: __( 'Advanced', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { type: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items per page', 'impeka-gutenberg-extension' ) }
							help={ __( 'Number of items per page', 'impeka-gutenberg-extension' ) }
							value={ items_per_page }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
								]
							}
							onChange={ val => { setAttributes( { items_per_page: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Tablet Landscape', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on tablet devices, landscape orientation.', 'impeka-gutenberg-extension' ) }
							value={ items_tablet_landscape }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { items_tablet_landscape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Tablet Portrait', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on tablet devices, portrait orientation.', 'impeka-gutenberg-extension' ) }
							value={ items_tablet_portrait }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { items_tablet_portrait: val } ); } }
						/>
						<SelectControl
							label={ __( 'Items Mobile', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select number of items on mobile devices.', 'impeka-gutenberg-extension' ) }
							value={ items_mobile }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
								]
							}
							onChange={ val => { setAttributes( { items_mobile: val } ); } }
						/>
						</Fragment>
						)}
						<TextControl
							label={ __( 'Items to show', 'impeka-gutenberg-extension' ) }
							help={ __( 'Maximum Items to Show', 'impeka-gutenberg-extension' ) }
							value={ items_to_show }
							onChange={ val => { setAttributes( { items_to_show: val } ); } }
						/>
						{ ( 'classic' == type ) && ( 'style-4' == style || 'style-5' == style ) && (
						<ToggleControl
							label={ __( 'Gutter between items', 'impeka-gutenberg-extension' ) }
							help={ __( 'Add gutter among items.', 'impeka-gutenberg-extension' ) }
							checked={ item_gutter }
							onChange={ val => { setAttributes( { item_gutter: ! item_gutter } ); } }
						/>
						)}
						{ item_gutter && ( 'classic' == type ) && ( 'style-4' == style || 'style-5' == style ) && (
						<TextControl
							label={ __( 'Gutter Size', 'impeka-gutenberg-extension' ) }
							value={ gutter_size }
							onChange={ val => { setAttributes( { gutter_size: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Order by', 'impeka-gutenberg-extension' ) }
							value={ order_by }
							options={
								grveSelectOptions[ "order_by" ]
							}
							onChange={ val => { setAttributes( { order_by: val } ); } }
						/>
						{ ( 'rand' != order_by && 'post__in' != order_by ) && (
						<SelectControl
							label={ __( 'Order', 'impeka-gutenberg-extension' ) }
							value={ order }
							options={
								grveSelectOptions[ "order" ]
							}
							onChange={ val => { setAttributes( { order: val } ); } }
						/>
						)}
						<TextControl
							label={ __( 'Bottom margin', 'impeka-gutenberg-extension' ) }
							help={ __( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-gutenberg-extension' ) }
							value={ margin_bottom }
							onChange={ val => { setAttributes( { margin_bottom: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Styles & Titles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<ToggleControl
							label={ __( 'Show Item Title', 'impeka-gutenberg-extension' ) }
							checked={ show_title }
							onChange={ val => { setAttributes( { show_title: ! show_title } ); } }
						/>
						{ show_title && (
						<SelectControl
							label={ __( 'Title Tag', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title Tag for SEO.', 'impeka-gutenberg-extension' ) }
							value={ heading_tag }
							options={ grveSelectOptions[ "heading_tag" ] }
							onChange={ val => { setAttributes( { heading_tag: val } ); } }
						/>
						)}
						{ show_title && (
						<SelectControl
							label={ __( 'Title Size/Typography', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-gutenberg-extension' ) }
							value={ heading }
							options={ grveSelectOptions[ "heading" ] }
							onChange={ val => { setAttributes( { heading: val } ); } }
						/>
						)}
						{ show_title && ( 'style-4' == style || 'style-5' == style ) && (
						<SelectControl
							label={ __( 'Title Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the title color.', 'impeka-gutenberg-extension' ) }
							value={ title_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { title_color: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Text Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your text style', 'impeka-gutenberg-extension' ) }
							value={ text_style }
							options={ grveSelectOptions[ "text_style" ] }
							onChange={ val => { setAttributes( { text_style: val } ); } }
						/>
						{ ( 'style-4' == style || 'style-5' == style ) && (
						<SelectControl
							label={ __( 'Text Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the text color.', 'impeka-gutenberg-extension' ) }
							value={ text_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { text_color: val } ); } }
						/>
						)}
						{ ( 'style-4' == style || 'style-5' == style ) && (
						<SelectControl
							label={ __( 'Background Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the background color.', 'impeka-gutenberg-extension' ) }
							value={ bg_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { bg_color: val } ); } }
						/>
						)}
						{ ( 'style-2' != style && 'style-3' != style ) && (
						<ToggleControl
							label={ __( 'Show Featured Image', 'impeka-gutenberg-extension' ) }
							checked={ show_image }
							onChange={ val => { setAttributes( { show_image: ! show_image } ); } }
						/>
						)}
						{ ( 'style-4' != style && 'style-5' != style ) && (
						<SelectControl
							label={ __( 'Alignment', 'impeka-gutenberg-extension' ) }
							value={ align }
							options={
								[
									{ value: 'left', label: __( 'Left', 'impeka-gutenberg-extension' ) },
									{ value: 'center', label: __( 'Center', 'impeka-gutenberg-extension' ) },
									{ value: 'right', label: __( 'Right', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { align: val } ); } }
						/>
						)}
						{ ( 'style-4' == style || 'style-5' == style ) && (
						<SelectControl
							label={ __( 'Shadow', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose shadow.', 'impeka-gutenberg-extension' ) }
							value={ shadow }
							options={ grveSelectOptions[ "shadow" ] }
							onChange={ val => { setAttributes( { shadow: val } ); } }
						/>
						)}
						{ ( 'advanced' == type ) && (
						<SelectControl
							label={ __( 'Border Radius', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose border radius', 'impeka-gutenberg-extension' ) }
							value={ radius }
							options={ grveSelectOptions[ "radius" ] }
							onChange={ val => { setAttributes( { radius: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Navigation & Pagination', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<ToggleControl
							label={ __( 'Loop', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable loop.', 'impeka-gutenberg-extension' ) }
							checked={ loop }
							onChange={ val => { setAttributes( { loop: ! loop } ); } }
						/>
						<ToggleControl
							label={ __( 'Autoplay', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable autoplay.', 'impeka-gutenberg-extension' ) }
							checked={ auto_play }
							onChange={ val => { setAttributes( { auto_play: ! auto_play } ); } }
						/>
						<TextControl
							label={ __( 'Slideshow Speed', 'impeka-gutenberg-extension' ) }
							help={ __( 'Slideshow Speed in ms ( Only available for classic type ).', 'impeka-gutenberg-extension' ) }
							value={ slideshow_speed }
							onChange={ val => { setAttributes( { slideshow_speed: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Pause on Hover', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable pause on hover ( Only available for classic type ).', 'impeka-gutenberg-extension' ) }
							checked={ pause_hover }
							onChange={ val => { setAttributes( { pause_hover: ! pause_hover } ); } }
						/>
						<ToggleControl
							label={ __( 'Auto Height', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select if you want smooth auto height.', 'impeka-gutenberg-extension' ) }
							checked={ auto_height }
							onChange={ val => { setAttributes( { auto_height: ! auto_height } ); } }
						/>
						<ToggleControl
							label={ __( 'Pagination', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enable or Disable pagination.', 'impeka-gutenberg-extension' ) }
							checked={ pagination }
							onChange={ val => { setAttributes( { pagination: ! pagination } ); } }
						/>
						{ pagination && (
						<TextControl
							label={ __( 'Pagination Speed', 'impeka-gutenberg-extension' ) }
							help={ __( 'Pagination Speed in ms ( Only available for classic type ).', 'impeka-gutenberg-extension' ) }
							value={ pagination_speed }
							onChange={ val => { setAttributes( { pagination_speed: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Categories', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Exclude Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-gutenberg-extension' ) }
							value={ exclude_posts }
							onChange={ val => { setAttributes( { exclude_posts: val } ); } }
						/>
						{ categoryQueryControls() }
						<TextControl
							label={ __( 'Include Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-gutenberg-extension' ) }
							value={ include_posts }
							onChange={ val => { setAttributes( { include_posts: val } ); } }
						/>
					</PanelBody>
				</InspectorControls>
				<ServerSideRender block="impeka/testimonial-carousel" attributes={ attributes } />
			</Fragment>
		);
    }
}