// edit.js

import { grveSelectOptions, grveGetColorArray } from '../utilities';
import get from 'lodash/get';
import apiFetch from '@wordpress/api-fetch';
import ServerSideRender from '@wordpress/server-side-render';

import { addQueryArgs } from '@wordpress/url';
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { QueryControls, TextControl, SelectControl, ToggleControl, PanelBody } from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';

const CATEGORIES_LIST_QUERY = {
	per_page: -1,
	hide_empty: true,
	_fields: 'id, name ,slug',
};

export default class ImpekaTestimonialEdit extends Component {
	constructor() {
		super( ...arguments );
		this.state = {
			categoriesList: [],

		};
	}
	componentDidMount() {
		this.isStillMounted = true;
		this.fetchRequest = apiFetch( {
			path: addQueryArgs( '/wp/v2/testimonial_category', CATEGORIES_LIST_QUERY ),

		} ).then(
			( categoriesList ) => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList } );
				}
			}
		).catch(
			() => {
				if ( this.isStillMounted ) {
					this.setState( { categoriesList: [] } );
				}
			}
		);
	}
	componentWillUnmount() {
		this.isStillMounted = false;
	}
    render() {

		const { categoriesList } = this.state;
		const { attributes, setAttributes, className } = this.props;
		const {
			mode,
			columns_large_screen, columns, columns_tablet_landscape, columns_tablet_portrait, columns_mobile,
			item_gutter, gutter_size,
			order_by, order,
			animation,
			margin_bottom, el_id,
			style, show_title, heading_tag, heading, title_color, text_color, text_style, bg_color, show_image,
			shadow, radius,
			posts_per_page, display_style, load_more_title,
			exclude_posts, categories, include_posts,
		} = attributes;

		const categoryQueryControls = () => {
			const categorySuggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			const suggestions = categoriesList.reduce(
				( accumulator, category ) => ( {
					...accumulator,
					[ category.name ]: category,
				} ),
				{}
			);
			return ( <QueryControls
				categorySuggestions={ categorySuggestions }
				selectedCategories={ attributes.categories }
				onCategoryChange={ ( tokens ) => {
					const allCategories = tokens.map( ( token ) =>
						typeof token === 'string' ? suggestions[ token ] : token
					);
					setAttributes( { categories: allCategories } );
				} }
			/> );
		};

		return (
			<Fragment>
				<InspectorControls key="inspector">
					<PanelBody title={ __( 'General', 'impeka-gutenberg-extension' ) } initialOpen={ true } >
						<SelectControl
							label={ __( 'Testimonial Mode', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your Testimonial Mode.', 'impeka-gutenberg-extension' ) }
							value={ mode }
							options={
								[
									{ value: 'masonry', label: __( 'Masonry', 'impeka-gutenberg-extension' ) },
									{ value: 'grid', label: __( 'Grid', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { mode: val } ); } }
						/>
						<SelectControl
							label={ __( 'Large Screen Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the number of columns for large screens.', 'impeka-gutenberg-extension' ) }
							value={ columns_large_screen }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
								]
							}
							onChange={ val => { setAttributes( { columns_large_screen: val } ); } }
						/>
						<SelectControl
							label={ __( 'Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select the number of columns for normal screens.', 'impeka-gutenberg-extension' ) }
							value={ columns }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
									{ value: '5', label: '5' },
								]
							}
							onChange={ val => { setAttributes( { columns: val } ); } }
						/>
						<SelectControl
							label={ __( 'Tablet Landscape Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on tablet devices, landscape orientation.', 'impeka-gutenberg-extension' ) }
							value={ columns_tablet_landscape }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { columns_tablet_landscape: val } ); } }
						/>
						<SelectControl
							label={ __( 'Tablet Portrait Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on tablet devices, portrait orientation.', 'impeka-gutenberg-extension' ) }
							value={ columns_tablet_portrait }
							options={
								[
									{ value: '2', label: '2' },
									{ value: '3', label: '3' },
									{ value: '4', label: '4' },
								]
							}
							onChange={ val => { setAttributes( { columns_tablet_portrait: val } ); } }
						/>
						<SelectControl
							label={ __( 'Mobile Columns', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select responsive column on mobile devices.', 'impeka-gutenberg-extension' ) }
							value={ columns_mobile }
							options={
								[
									{ value: '1', label: '1' },
									{ value: '2', label: '2' },
								]
							}
							onChange={ val => { setAttributes( { columns_mobile: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Gutter between items', 'impeka-gutenberg-extension' ) }
							help={ __( 'Add gutter among items.', 'impeka-gutenberg-extension' ) }
							checked={ item_gutter }
							onChange={ val => { setAttributes( { item_gutter: ! item_gutter } ); } }
						/>
						{ item_gutter && (
						<TextControl
							label={ __( 'Gutter Size', 'impeka-gutenberg-extension' ) }
							value={ gutter_size }
							onChange={ val => { setAttributes( { gutter_size: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Order by', 'impeka-gutenberg-extension' ) }
							value={ order_by }
							options={
								grveSelectOptions[ "order_by" ]
							}
							onChange={ val => { setAttributes( { order_by: val } ); } }
						/>
						{ ( 'rand' != order_by && 'post__in' != order_by ) && (
						<SelectControl
							label={ __( 'Order', 'impeka-gutenberg-extension' ) }
							value={ order }
							options={
								grveSelectOptions[ "order" ]
							}
							onChange={ val => { setAttributes( { order: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Animation', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'impeka-gutenberg-extension' ) }
							value={ animation }
							options={
								grveSelectOptions[ "animation" ]
							}
							onChange={ val => { setAttributes( { animation: val } ); } }
						/>
						<TextControl
							label={ __( 'Bottom margin', 'impeka-gutenberg-extension' ) }
							help={ __( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka-gutenberg-extension' ) }
							value={ margin_bottom }
							onChange={ val => { setAttributes( { margin_bottom: val } ); } }
						/>
						<TextControl
							label={ __( 'Element ID', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter element ID (Note: make sure it is unique)', 'impeka-gutenberg-extension' ) }
							value={ el_id }
							onChange={ val => { setAttributes( { el_id: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Styles & Titles', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<SelectControl
							label={ __( 'Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your testimonial Style.', 'impeka-gutenberg-extension' ) }
							value={ style }
							options={
								[
									{ value: 'style-4', label: __( 'Style 4', 'impeka-gutenberg-extension' ) },
									{ value: 'style-5', label: __( 'Style 5', 'impeka-gutenberg-extension' ) },
								]
							}
							onChange={ val => { setAttributes( { style: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Show Item Title', 'impeka-gutenberg-extension' ) }
							checked={ show_title }
							onChange={ val => { setAttributes( { show_title: ! show_title } ); } }
						/>
						{ show_title && (
						<SelectControl
							label={ __( 'Title Tag', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title Tag for SEO.', 'impeka-gutenberg-extension' ) }
							value={ heading_tag }
							options={ grveSelectOptions[ "heading_tag" ] }
							onChange={ val => { setAttributes( { heading_tag: val } ); } }
						/>
						)}
						{ show_title && (
						<SelectControl
							label={ __( 'Title Size/Typography', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-gutenberg-extension' ) }
							value={ heading }
							options={ grveSelectOptions[ "heading" ] }
							onChange={ val => { setAttributes( { heading: val } ); } }
						/>
						)}
						{ show_title && (
						<SelectControl
							label={ __( 'Title Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the title color.', 'impeka-gutenberg-extension' ) }
							value={ title_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { title_color: val } ); } }
						/>
						)}
						<SelectControl
							label={ __( 'Text Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select your text style', 'impeka-gutenberg-extension' ) }
							value={ text_style }
							options={ grveSelectOptions[ "text_style" ] }
							onChange={ val => { setAttributes( { text_style: val } ); } }
						/>
						<SelectControl
							label={ __( 'Text Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the text color.', 'impeka-gutenberg-extension' ) }
							value={ text_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { text_color: val } ); } }
						/>
						<SelectControl
							label={ __( 'Background Color', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose the background color.', 'impeka-gutenberg-extension' ) }
							value={ bg_color }
							options={ grveGetColorArray() }
							onChange={ val => { setAttributes( { bg_color: val } ); } }
						/>
						<ToggleControl
							label={ __( 'Show Featured Image', 'impeka-gutenberg-extension' ) }
							checked={ show_image }
							onChange={ val => { setAttributes( { show_image: ! show_image } ); } }
						/>
						<SelectControl
							label={ __( 'Shadow', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose shadow.', 'impeka-gutenberg-extension' ) }
							value={ shadow }
							options={ grveSelectOptions[ "shadow" ] }
							onChange={ val => { setAttributes( { shadow: val } ); } }
						/>
						<SelectControl
							label={ __( 'Border Radius', 'impeka-gutenberg-extension' ) }
							help={ __( 'Choose border radius', 'impeka-gutenberg-extension' ) }
							value={ radius }
							options={ grveSelectOptions[ "radius" ] }
							onChange={ val => { setAttributes( { radius: val } ); } }
						/>
					</PanelBody>
					<PanelBody title={ __( 'Pagination', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Items per page', 'impeka-gutenberg-extension' ) }
							help={ __( 'Enter how many items per page you want to display.', 'impeka-gutenberg-extension' ) }
							value={ posts_per_page }
							onChange={ val => { setAttributes( { posts_per_page: val } ); } }
						/>
						<SelectControl
							label={ __( 'Display Style', 'impeka-gutenberg-extension' ) }
							help={ __( 'Select Show All or define your pagination style.', 'impeka-gutenberg-extension' ) }
							value={ display_style }
							options={ grveSelectOptions[ "display_style" ] }
							onChange={ val => { setAttributes( { display_style: val } ); } }
						/>
						{ ( 'load-more' == display_style ) && (
						<TextControl
							label={ __( 'Load More Title', 'impeka-gutenberg-extension' ) }
							help={ __( 'Title for load more.', 'impeka-gutenberg-extension' ) }
							value={ load_more_title }
							onChange={ val => { setAttributes( { load_more_title: val } ); } }
						/>
						)}
					</PanelBody>
					<PanelBody title={ __( 'Categories', 'impeka-gutenberg-extension' ) } initialOpen={ false } >
						<TextControl
							label={ __( 'Exclude Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-gutenberg-extension' ) }
							value={ exclude_posts }
							onChange={ val => { setAttributes( { exclude_posts: val } ); } }
						/>
						{ categoryQueryControls() }
						<TextControl
							label={ __( 'Include Posts', 'impeka-gutenberg-extension' ) }
							help={ __( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-gutenberg-extension' ) }
							value={ include_posts }
							onChange={ val => { setAttributes( { include_posts: val } ); } }
						/>
					</PanelBody>
				</InspectorControls>
				<ServerSideRender block="impeka/testimonial" attributes={ attributes } />
			</Fragment>
		);
    }
}