// utilities.js


const { __ } = wp.i18n;

export const grveSelectOptions = {
	"image_load_mode": [
		{ value: '', label: __( 'Inherit', 'impeka-gutenberg-extension' ) },
		{ value: 'off', label: __( 'Off', 'impeka-gutenberg-extension' ) },
		{ value: 'native-lazyload', label: __( 'Native Lazyload', 'impeka-gutenberg-extension' ) },
		{ value: 'lazyload', label: __( 'Theme Lazyload', 'impeka-gutenberg-extension' ) },
	],
	"image_effect": [
		{ value: '', label: __( 'None', 'impeka-gutenberg-extension' ) },
		{ value: 'grayscale-image', label: __( 'Grayscale Image', 'impeka-gutenberg-extension' ) },
		{ value: 'grayscale-image-hover', label: __( 'Colored on Hover', 'impeka-gutenberg-extension' ) },
	],
	"image_popup_size": [
		{ value: 'full', label: __( 'Full', 'impeka-gutenberg-extension' ) },
		{ value: 'extra-extra-large', label: __( 'Extra Extra Large', 'impeka-gutenberg-extension' ) },
		{ value: 'extra-large', label: __( 'Extra Large', 'impeka-gutenberg-extension' ) },
	],
	"title_caption": [
		{ value: 'none', label: __( 'None', 'impeka-gutenberg-extension' ) },
		{ value: 'title-caption', label: __( 'Title and Description', 'impeka-gutenberg-extension' ) },
		{ value: 'title-only', label: __( 'Title Only', 'impeka-gutenberg-extension' ) },
		{ value: 'caption-only', label: __( 'Description Only', 'impeka-gutenberg-extension' ) },
	],
	"animation": [
		{ value: '', label: __( 'No', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in', label: __( 'Fade In', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-up', label: __( 'Fade In Up', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-up-big', label: __( 'Fade In Up Big', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-down', label: __( 'Fade In Down', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-down-big', label: __( 'Fade In Down Big', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-left', label: __( 'Fade In Left', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-left-big', label: __( 'Fade In Left Big', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-right', label: __( 'Fade In Right', 'impeka-gutenberg-extension' ) },
		{ value: 'fade-in-right-big', label: __( 'Fade In Right Big', 'impeka-gutenberg-extension' ) },
		{ value: 'zoom-in', label: __( 'Zoom In', 'impeka-gutenberg-extension' ) },
	],
	"animation_duration": [
		{ value: 'very-fast', label: __( 'Very Fast', 'impeka-gutenberg-extension' ) },
		{ value: 'fast', label: __( 'Fast', 'impeka-gutenberg-extension' ) },
		{ value: 'normal', label: __( 'Normal', 'impeka-gutenberg-extension' ) },
		{ value: 'slow', label: __( 'Slow', 'impeka-gutenberg-extension' ) },
		{ value: 'very-slow', label: __( 'Very Slow', 'impeka-gutenberg-extension' ) },
	],
	"order_by": [
		{ value: 'date', label: __( 'Date', 'impeka-gutenberg-extension' ) },
		{ value: 'modified', label: __( 'Last modified date', 'impeka-gutenberg-extension' ) },
		{ value: 'comment_count', label: __( 'Number of comments', 'impeka-gutenberg-extension' ) },
		{ value: 'title', label: __( 'Title', 'impeka-gutenberg-extension' ) },
		{ value: 'author', label: __( 'Author', 'impeka-gutenberg-extension' ) },
		{ value: 'rand', label: __( 'Random', 'impeka-gutenberg-extension' ) },
		{ value: 'menu_order', label: __( 'Post Order', 'impeka-gutenberg-extension' ) },
		{ value: 'post__in', label: __( 'Post In', 'impeka-gutenberg-extension' ) },
	],
	"order": [
		{ value: 'DESC', label: __( 'Descending', 'impeka-gutenberg-extension' ) },
		{ value: 'ASC', label: __( 'Ascending', 'impeka-gutenberg-extension' ) },
	],
	"overlay_opacity": [
		{ value: '0', label: '0%' },
		{ value: '10', label: '10%' },
		{ value: '20', label: '20%' },
		{ value: '30', label: '30%' },
		{ value: '40', label: '40%' },
		{ value: '50', label: '50%' },
		{ value: '60', label: '60%' },
		{ value: '70', label: '70%' },
		{ value: '80', label: '80%' },
		{ value: '90', label: '90%' },
		{ value: '100', label: '100%' },
	],
	"heading_tag": [
		{ value: 'h1', label: 'h1' },
		{ value: 'h2', label: 'h2' },
		{ value: 'h3', label: 'h3' },
		{ value: 'h4', label: 'h4' },
		{ value: 'h5', label: 'h5' },
		{ value: 'h6', label: 'h6' },
		{ value: 'div', label: 'div' },
	],
	"heading": [
		{ value: 'h1', label: 'h1' },
		{ value: 'h2', label: 'h2' },
		{ value: 'h3', label: 'h3' },
		{ value: 'h4', label: 'h4' },
		{ value: 'h5', label: 'h5' },
		{ value: 'h6', label: 'h6' },
		{ value: 'leader-text', label: __( 'Leader Text', 'impeka-gutenberg-extension' ) },
		{ value: 'subtitle-text', label: __( 'Subtitle Text', 'impeka-gutenberg-extension' ) },
		{ value: 'small-text', label: __( 'Small Text', 'impeka-gutenberg-extension' ) },
		{ value: 'link-text', label: __( 'Link Text', 'impeka-gutenberg-extension' ) },
	],
	"text_style": [
		{ value: 'none', label: __( 'None', 'impeka-gutenberg-extension' ) },
		{ value: 'leader-text', label: __( 'Leader Text', 'impeka-gutenberg-extension' ) },
		{ value: 'subtitle-text', label: __( 'Subtitle Text', 'impeka-gutenberg-extension' ) },
		{ value: 'small-text', label: __( 'Small Text', 'impeka-gutenberg-extension' ) },
		{ value: 'quote-text', label: __( 'Quote Text', 'impeka-gutenberg-extension' ) },
	],
	"heading_auto": [
		{ value: 'auto', label: __( 'Auto', 'impeka-gutenberg-extension' ) },
		{ value: 'h1', label: 'h1' },
		{ value: 'h2', label: 'h2' },
		{ value: 'h3', label: 'h3' },
		{ value: 'h4', label: 'h4' },
		{ value: 'h5', label: 'h5' },
		{ value: 'h6', label: 'h6' },
		{ value: 'leader-text', label: __( 'Leader Text', 'impeka-gutenberg-extension' ) },
		{ value: 'subtitle-text', label: __( 'Subtitle Text', 'impeka-gutenberg-extension' ) },
		{ value: 'small-text', label: __( 'Small Text', 'impeka-gutenberg-extension' ) },
		{ value: 'link-text', label: __( 'Link Text', 'impeka-gutenberg-extension' ) },
	],
	"shadow": [
		{ value: 'none', label: __( 'None', 'impeka-gutenberg-extension' ) },
		{ value: 'small', label: __( 'Small', 'impeka-gutenberg-extension' ) },
		{ value: 'medium', label: __( 'Medium', 'impeka-gutenberg-extension' ) },
		{ value: 'large', label: __( 'Large', 'impeka-gutenberg-extension' ) },
	],
	"radius": [
		{ value: 'none', label: __( 'None', 'impeka-gutenberg-extension' ) },
		{ value: '3', label: __( 'Radius 3px', 'impeka-gutenberg-extension' ) },
		{ value: '5', label: __( 'Radius 5px', 'impeka-gutenberg-extension' ) },
		{ value: '10', label: __( 'Radius 10px', 'impeka-gutenberg-extension' ) },
		{ value: '15', label: __( 'Radius 15px', 'impeka-gutenberg-extension' ) },
		{ value: '20', label: __( 'Radius 20px', 'impeka-gutenberg-extension' ) },
		{ value: '25', label: __( 'Radius 25px', 'impeka-gutenberg-extension' ) },
		{ value: '30', label: __( 'Radius 30px', 'impeka-gutenberg-extension' ) },
		{ value: '35', label: __( 'Radius 35px', 'impeka-gutenberg-extension' ) },
	],
	"display_style": [
		{ value: '', label: __( 'Show All', 'impeka-gutenberg-extension' ) },
		{ value: 'pagination', label: __( 'Pagination', 'impeka-gutenberg-extension' ) },
		{ value: 'load-more', label: __( 'Load More', 'impeka-gutenberg-extension' ) },
		{ value: 'infinite-scroll', label: __( 'Infinite Scroll', 'impeka-gutenberg-extension' ) },
	],
	"display_simple_style": [
		{ value: '', label: __( 'Show All', 'impeka-gutenberg-extension' ) },
		{ value: 'pagination', label: __( 'Pagination', 'impeka-gutenberg-extension' ) },
	],
	"display_large_style": [
		{ value: '', label: __( 'Show All', 'impeka-gutenberg-extension' ) },
		{ value: 'pagination', label: __( 'Pagination', 'impeka-gutenberg-extension' ) },
	],
	"filter_order_by": [
		{ value: '', label: __( 'Default ( Unordered )', 'impeka-gutenberg-extension' ) },
		{ value: 'id', label: __( 'ID', 'impeka-gutenberg-extension' ) },
		{ value: 'slug', label: __( 'Slug', 'impeka-gutenberg-extension' ) },
		{ value: 'title', label: __( 'Title', 'impeka-gutenberg-extension' ) },
	],
	"filter_order": [
		{ value: 'DESC', label: __( 'Descending', 'impeka-gutenberg-extension' ) },
		{ value: 'ASC', label: __( 'Ascending', 'impeka-gutenberg-extension' ) },
	],
	"filter_style": [
		{ value: 'simple', label: __( 'Simple', 'impeka-gutenberg-extension' ) },
		{ value: 'button', label: __( 'Button', 'impeka-gutenberg-extension' ) },
		{ value: 'classic', label: __( 'Classic', 'impeka-gutenberg-extension' ) },
		{ value: 'splitted', label: __( 'Splitted', 'impeka-gutenberg-extension' ) },
		{ value: 'count', label: __( 'Count', 'impeka-gutenberg-extension' ) },
	],
	"filter_shape": [
		{ value: 'square', label: __( 'Square', 'impeka-gutenberg-extension' ) },
		{ value: 'round', label: __( 'Round', 'impeka-gutenberg-extension' ) },
		{ value: 'extra-round', label: __( 'Extra Round', 'impeka-gutenberg-extension' ) },
	],
	"filter_align": [
		{ value: 'left', label: __( 'Left', 'impeka-gutenberg-extension' ) },
		{ value: 'center', label: __( 'Center', 'impeka-gutenberg-extension' ) },
		{ value: 'right', label: __( 'Right', 'impeka-gutenberg-extension' ) },
	],
	"filter_gototop": [
		{ value: 'yes', label: __( 'Yes', 'impeka-gutenberg-extension' ) },
		{ value: 'no', label: __( 'No', 'impeka-gutenberg-extension' ) },
	],
	"indicator": [
		{ value: 'none', label: __( 'None', 'impeka-gutenberg-extension' ) },
		{ value: 'arrow', label: __( 'Arrow', 'impeka-gutenberg-extension' ) },
		{ value: 'plus', label: __( 'Plus', 'impeka-gutenberg-extension' ) },
		{ value: 'text', label: __( 'Text', 'impeka-gutenberg-extension' ) },
	],
	"nav_icon": [
		{ value: 'arrow-1', label: __( 'Arrow 1', 'impeka-gutenberg-extension' ) },
		{ value: 'arrow-2', label: __( 'Arrow 2', 'impeka-gutenberg-extension' ) },
		{ value: 'arrow-3', label: __( 'Arrow 3', 'impeka-gutenberg-extension' ) },
	],
	"nav_shape": [
		{ value: '', label: __( 'None', 'impeka-gutenberg-extension' ) },
		{ value: 'square', label: __( 'Square', 'impeka-gutenberg-extension' ) },
		{ value: 'round', label: __( 'Round', 'impeka-gutenberg-extension' ) },
		{ value: 'circle', label: __( 'Circle', 'impeka-gutenberg-extension' ) },
	],
};



export const grveGetColorArray = ( colors ) => {
	var colorOptions = [];

	if ( !colors ) {
		colors = [ 'primary', 'standard' ];
	}
	for (const group of colors) {
		if ( grveSelectColors[ group ] ) {
			colorOptions = colorOptions.concat( grveSelectColors[ group ] );
		}
	}
	return colorOptions;
}

const grveSelectColors = {
	"none": [
		{ value: 'none', label: __( 'None', 'impeka-gutenberg-extension' ) },
	],
	"default": [
		{ value: 'default', label: __( 'Default', 'impeka-gutenberg-extension' ) },
	],
	"inherit": [
		{ value: 'inherit', label: __( 'Inherit', 'impeka-gutenberg-extension' ) },
	],
	"transparent": [
		{ value: 'transparent', label: __( 'Transparent', 'impeka-gutenberg-extension' ) },
	],
	"primary": [
		{ value: 'primary-1', label: __( 'Primary 1', 'impeka-gutenberg-extension' ) },
		{ value: 'primary-2', label: __( 'Primary 2', 'impeka-gutenberg-extension' ) },
		{ value: 'primary-3', label: __( 'Primary 3', 'impeka-gutenberg-extension' ) },
		{ value: 'primary-4', label: __( 'Primary 4', 'impeka-gutenberg-extension' ) },
		{ value: 'primary-5', label: __( 'Primary 5', 'impeka-gutenberg-extension' ) },
		{ value: 'primary-6', label: __( 'Primary 6', 'impeka-gutenberg-extension' ) },
	],
	"gradient": [
		{ value: 'gradient-1', label: __( 'Gradient 1', 'impeka-gutenberg-extension' ) },
		{ value: 'gradient-2', label: __( 'Gradient 2', 'impeka-gutenberg-extension' ) },
		{ value: 'gradient-3', label: __( 'Gradient 3', 'impeka-gutenberg-extension' ) },
	],
	"single-gradient": [
		{ value: 'gradient', label: __( 'Gradient', 'impeka-gutenberg-extension' ) },
	],
	"black-white": [
		{ value: 'black', label: __( 'Black', 'impeka-gutenberg-extension' ) },
		{ value: 'white', label: __( 'White', 'impeka-gutenberg-extension' ) },
	],
	"standard": [
		{ value: 'green', label: __( 'Green', 'impeka-gutenberg-extension' ) },
		{ value: 'orange', label: __( 'Orange', 'impeka-gutenberg-extension' ) },
		{ value: 'red', label: __( 'Red', 'impeka-gutenberg-extension' ) },
		{ value: 'blue', label: __( 'Blue', 'impeka-gutenberg-extension' ) },
		{ value: 'aqua', label: __( 'Aqua', 'impeka-gutenberg-extension' ) },
		{ value: 'purple', label: __( 'Purple', 'impeka-gutenberg-extension' ) },
		{ value: 'black', label: __( 'Black', 'impeka-gutenberg-extension' ) },
		{ value: 'grey', label: __( 'Grey', 'impeka-gutenberg-extension' ) },
		{ value: 'dark-grey', label: __( 'Dark Grey', 'impeka-gutenberg-extension' ) },
		{ value: 'light-grey', label: __( 'Light Grey', 'impeka-gutenberg-extension' ) },
		{ value: 'white', label: __( 'White', 'impeka-gutenberg-extension' ) },

	],
	"custom": [
		{ value: 'custom', label: __( 'Custom', 'impeka-gutenberg-extension' ) },
	],
	"dominant": [
		{ value: 'dominant', label: __( 'Image Dominant', 'impeka-gutenberg-extension' ) },
	],
}