<?php
/**
 * Blog Carousel Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-carousel' );
if ( !empty ( $className ) ) {
	$element_classes[] = $className;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_gutenberg_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$auto_play = $auto_play ? 'yes' : 'no';
$pagination = $pagination ? 'yes' : 'no';
$loop = $loop ? 'yes' : 'no';
$pause_hover = $pause_hover ? 'yes' : 'no';
$item_gutter = $item_gutter ? 'yes' : 'no';

//Carousel Wrapper
$carousel_attributes = array();
$carousel_attributes[] = 'data-items="' . esc_attr( $items_per_page ) . '"';
$carousel_attributes[] = 'data-items-tablet-landscape="' . esc_attr( $items_tablet_landscape ) . '"';
$carousel_attributes[] = 'data-items-tablet-portrait="' . esc_attr( $items_tablet_portrait ) . '"';
$carousel_attributes[] = 'data-items-mobile="' . esc_attr( $items_mobile ) . '"';
$carousel_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$carousel_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$carousel_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
if ( 'classic' == $type ) {
	$carousel_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
	$carousel_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
	$carousel_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
}
if ( 'classic' == $type && 'yes' == $item_gutter ) {
	$carousel_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
}
$carousel_classes = array( 'grve-carousel-element', 'grve-blog-carousel', 'grve-blog-columns' );
if ( 'classic' == $type && 'yes' == $item_gutter && '0' != $gutter_size ) {
	$carousel_classes[] = 'grve-with-gap';
}
if ( 'classic' == $type ) {
	$carousel_classes[] = 'grve-classic-carousel';
} else {
	$carousel_classes[] = 'grve-flickity-carousel';
	$carousel_classes[] = 'flickity';
}
$carousel_class_string = implode( ' ', $carousel_classes );
$carousel_attributes[] = 'class="' . esc_attr( $carousel_class_string ) . '"';

//Query args
$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}
$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'post',
		'post_status'=>'publish',
		'posts_per_page' => $posts_per_page,
		'post__in' => $include_ids,
		'paged' => 1,
		'ignore_sticky_posts' => 1,
		'orderby' => $order_by,
		'order' => $order,
	);
} else {
	$args = array(
		'post_type' => 'post',
		'post_status'=>'publish',
		'posts_per_page' => $posts_per_page,
		'post__not_in' => $exclude_ids,
		'paged' => 1,
		'ignore_sticky_posts' => 1,
		'orderby' => $order_by,
		'order' => $order,
	);
	if ( isset( $categories ) ) {
		$args['category__in'] = array_column( $categories, 'id' );
	}
}
$query = new WP_Query( $args );
if ( $query->have_posts() ) :

$blog_params = array(
	'mode' => 'carousel',
	'style' => $style,
	'heading_color' => $heading_color,
	'text_color' => $text_color,
	'meta_color' => $meta_color,
	'bg_color' => $bg_color,
	'border_color' => $border_color,
	'overlay_color' => $overlay_color,
	'overlay_opacity' => $overlay_opacity,
	'shadow' => $shadow,
	'radius' => $radius,
	'media_area' => $media_area,
	'image_prio' => 'yes',
	'image_mode' => $image_mode,
	'heading_tag' => $title_heading_tag,
	'heading' => $title_heading,
	'excerpt_length' => $excerpt_length,
	'excerpt_more' => $excerpt_more,
	'excerpt_more_text' => $excerpt_more_text,
	'link_type' => $link_type,
	'author_visibility' => $show_author,
	'date_visibility' => $show_date,
	'comments_visibility' => $show_comments,
	'like_visibility' => $show_like,
	'categories_visibility' => $show_categories,
	'categories_mode' => $categories_mode,
	'image_load_mode' => $image_load_mode,
);

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-carousel-wrapper">
		<?php get_template_part( 'templates/navigation/carousel-nav', '', $atts ); ?>
		<div <?php echo implode( ' ', $carousel_attributes ); ?>>
<?php

while ( $query->have_posts() ) : $query->the_post();

	$blog_params['post_format'] = get_post_format();
	if ( function_exists( 'impeka_grve_get_blog_style' ) ) {
		$blog_style = impeka_grve_get_blog_style( $blog_params );
	}
?>
			<article <?php post_class( "grve-carousel-item" ); ?> itemscope itemType="http://schema.org/BlogPosting">
				<?php get_template_part( 'templates/post/' . $blog_style . '/loop-post-content', get_post_format(), $blog_params ); ?>
			</article>
<?php
endwhile;
?>
		</div>
	</div>
</div>
<?php
else :
	get_template_part( 'templates/post/post', 'none' );
endif;

wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
