<?php
/**
 * Blog Template
 */

extract( $atts );

if ( empty( $el_id ) ) {
	$el_id = 'blog-default-id';
}

//Element Wrapper
$wrapper_params = array(
	'mode' => $mode,
	'columns_large_screen' => $columns_large_screen,
	'columns' => $columns,
	'columns_tablet_landscape' => $columns_tablet_landscape,
	'columns_tablet_portrait' => $columns_tablet_portrait,
	'columns_mobile' => $columns_mobile,
	'gutter' => $item_gutter,
	'gutter_size' => $gutter_size,
	'display_style' => $display_style,
	'animation' => $animation,
);
$wrapper_attributes = impeka_gutenberg_ext_get_grid_layout_atts( $wrapper_params );

$item_gutter = $item_gutter ? 'yes' : 'no';

//Element Classes
$element_classes = array( 'grve-element' );
$element_classes[] = impeka_gutenberg_ext_get_blog_class( $mode );
if ( 'yes' == $item_gutter && '0' != $gutter_size ) {
	$element_classes[] = 'grve-with-gap';
}
if ( !empty ( $className ) ) {
	$element_classes[] =  $className;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
$css_style = impeka_gutenberg_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$paged = 1;

$disable_pagination = '';
if ( 'large' == $mode ) {
	if ( empty( $display_large_style ) ) {
		$disable_pagination = 'yes';
	}
} else {
	if ( empty( $display_style ) ) {
		$disable_pagination = 'yes';
	}
}

if ( 'yes' != $disable_pagination ) {
	if ( get_query_var( 'paged' ) ) {
		$paged = get_query_var( 'paged' );
	} elseif ( get_query_var( 'page' ) ) {
		$paged = get_query_var( 'page' );
	}
}

$category_ids = array();
if( ! empty( $categories ) ) {
	$category_ids = array_column( $categories, 'id' );
}

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'post',
		'post_status'=>'publish',
		'posts_per_page' => $posts_per_page,
		'post__in' => $include_ids,
		'paged' => $paged,
		'ignore_sticky_posts' => 1,
		'orderby' => $order_by,
		'order' => $order,
	);
	$filter = 'no';
} else {
	$args = array(
		'post_type' => 'post',
		'post_status'=>'publish',
		'posts_per_page' => $posts_per_page,
		'post__not_in' => $exclude_ids,
		'paged' => $paged,
		'ignore_sticky_posts' => 1,
		'orderby' => $order_by,
		'order' => $order,
	);
	if ( isset( $categories ) ) {
		$args['category__in'] = $category_ids;
	}
}

$query = new WP_Query( $args );

if ( 'large' == $mode ) {
	$filter = 'no';
}

if ( $query->have_posts() ) :

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php
//Category Filter
if ( 'yes' == $filter ) {

	$filter_atts = array(
		'query' => $query,
		'category_name' => 'category',
		'category_ids' => $category_ids,
		'filter_all_text' => $filter_all_text,
		'filter_style' => $filter_style,
		'filter_shape' => $filter_shape,
		'filter_color' => $filter_color,
		'filter_align' => $filter_align,
		'filter_order_by' => $filter_order_by,
		'filter_order' => $filter_order,
		'filter_gototop' => $filter_gototop,
	);
	impeka_gutenberg_print_filters( $filter_atts );

}
if ( 'large' == $mode ) {
?>
	<div class="grve-standard-container">
<?php
} else {
?>
	<div class="grve-isotope-container">
		<div class="grve-grid-sizer"></div>
<?php
}

$blog_params = array(
	'mode' => $mode,
	'style' => $style,
	'small_style' => $small_style,
	'custom_overview' => $custom_overview,
	'heading_color' => $heading_color,
	'text_color' => $text_color,
	'meta_color' => $meta_color,
	'bg_color' => $bg_color,
	'border_color' => $border_color,
	'overlay_color' => $overlay_color,
	'overlay_opacity' => $overlay_opacity,
	'style' => $style,
	'shadow' => $shadow,
	'radius' => $radius,
	'media_area' => $media_area,
	'image_width' => $image_width,
	'image_prio' => $image_prio,
	'image_mode' => $image_mode,
	'grid_image_mode' => $grid_image_mode,
	'masonry_image_mode' => $masonry_image_mode,
	'heading_tag' => $title_heading_tag,
	'heading' => $title_heading,
	'auto_excerpt' => $auto_excerpt,
	'excerpt_length_large' => $excerpt_length_large,
	'excerpt_length' => $excerpt_length,
	'excerpt_more' => $excerpt_more,
	'excerpt_more_text' => $excerpt_more_text,
	'link_type' => $link_type,
	'author_visibility' => $show_author,
	'date_visibility' => $show_date,
	'comments_visibility' => $show_comments,
	'like_visibility' => $show_like,
	'categories_visibility' => $show_categories,
	'categories_mode' => $categories_mode,
	'indicator' => $indicator,
	'indicator_text' => $indicator_text,
	'indicator_color' => $indicator_color,
	'image_load_mode' => $image_load_mode,
);


$outer_wrapper_class = '';
$inner_wrapper_attributes = array();
$blog_style = 'style-1';

while ( $query->have_posts() ) : $query->the_post();

	$blog_params['post_format'] = get_post_format();
	if ( function_exists( 'impeka_grve_get_blog_style' ) ) {
		$blog_style = impeka_grve_get_blog_style( $blog_params );
	}
	if ( function_exists( 'impeka_grve_get_post_inner_attributes' ) ) {
		$inner_wrapper_attributes = impeka_grve_get_post_inner_attributes( $blog_params );
	}
	?>
	<article <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">
		<div <?php echo implode( ' ', $inner_wrapper_attributes ); ?>>
			<?php get_template_part( 'templates/post/' . $blog_style . '/loop-post-content', get_post_format(), $blog_params ); ?>
		</div>
	</article>
	<?php
endwhile;
?>
	</div>
<?php
	if ( 'yes' != $disable_pagination ) {
		impeka_gutenberg_print_pagination( array(
			'total' => $query->max_num_pages,
			'paged' => $paged,
			'display_style' => $display_style,
			'load_more_title' => $load_more_title,
		));
	}
?>
</div>
<?php
else :
	get_template_part( 'templates/post/post', 'none' );
endif;

wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
