<?php
/**
 * Products Template
 */

extract( $atts );

if ( empty( $el_id ) ) {
	$el_id = 'products-default-id';
}

//Element Wrapper
$wrapper_params = array(
	'mode' => $mode,
	'columns_large_screen' => $columns_large_screen,
	'columns' => $columns,
	'columns_tablet_landscape' => $columns_tablet_landscape,
	'columns_tablet_portrait' => $columns_tablet_portrait,
	'columns_mobile' => $columns_mobile,
	'gutter' => $item_gutter,
	'gutter_size' => $gutter_size,
	'display_style' => $display_style,
	'animation' => $animation,
);

$wrapper_attributes = impeka_gutenberg_ext_get_grid_layout_atts( $wrapper_params );

$product_classes = array( 'grve-element', 'grve-product', 'grve-isotope', 'woocommerce' );
if ( 'yes' == $item_gutter && '0' != $gutter_size ) {
	$product_classes[] = 'grve-with-gap';
}
if ( !empty ( $className ) ) {
	$product_classes[] = $className;
}
$product_class_string = implode( ' ', $product_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $product_class_string ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
$css_style = impeka_gutenberg_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$product_cat = "";
$category_ids = array();

if( ! empty( $categories ) ) {
	$category_ids = array_column( $categories, 'id' );
	foreach ( $category_ids as $category_id ) {
		$category_term = get_term( $category_id, 'product_cat' );
		if ( isset( $category_term) ) {
			$product_cat = $product_cat.$category_term->slug . ', ';
		}
	}
}

$paged = 1;

if ( ! empty( $display_style ) ) {
	if ( get_query_var( 'paged' ) ) {
		$paged = get_query_var( 'paged' );
	} elseif ( get_query_var( 'page' ) ) {
		$paged = get_query_var( 'page' );
	}
}

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'product',
		'post_status'=>'publish',
		'paged' => $paged,
		'post__in' => $include_ids,
		'posts_per_page' => $items_per_page,
		'orderby' => $order_by,
		'order' => $order,
	);
	$filter = 'no';
} else {
	$args = array(
		'post_type' => 'product',
		'post_status'=>'publish',
		'paged' => $paged,
		'product_cat' => $product_cat,
		'post__not_in' => $exclude_ids,
		'posts_per_page' => $items_per_page,
		'orderby' => $order_by,
		'order' => $order,
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php

if ( 'yes' == $filter ) {

	$filter_atts = array(
		'query' => $query,
		'category_name' => 'product_cat',
		'category_prefix_class' => 'product_cat',
		'category_ids' => $category_ids,
		'filter_all_text' => $filter_all_text,
		'filter_style' => $filter_style,
		'filter_shape' => $filter_shape,
		'filter_color' => $filter_color,
		'filter_align' => $filter_align,
		'filter_order_by' => $filter_order_by,
		'filter_order' => $filter_order,
		'filter_gototop' => $filter_gototop,
	);
	impeka_gutenberg_print_filters( $filter_atts );
}
?>
	<div class="grve-product-container grve-isotope-container">
		<div class="grve-grid-sizer"></div>
<?php
while ( $query->have_posts() ) :
	$query->the_post();

	$image_size = 'large';
	if ( 'masonry' == $mode ) {
		$image_size = impeka_gutenberg_ext_get_image_size( $masonry_image_mode );
	} else {
		$image_size = impeka_gutenberg_ext_get_image_size( $grid_image_mode );
	}
	$product_params = array(
		'element' => 'product',
		'hover_style' => $hover_style,
		'image_size' => $image_size,
		'second_image_effect' => $second_image_effect,
		'text_color' => $text_color,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'link_type' => $link_type,
		'quick_view_title' => $quick_view_title,
	);
?>
		<div <?php post_class(); ?>>
			<div class="grve-isotope-item-inner">
			<?php get_template_part( 'templates/product/product-hover-item', '', $product_params ); ?>
			</div>
		</div>
<?php
endwhile;
?>
	</div>
<?php
	if ( ! empty( $display_style ) ) {
		impeka_gutenberg_print_pagination( array(
			'total' => $query->max_num_pages,
			'paged' => $paged,
			'display_style' => $display_style,
			'load_more_title' => $load_more_title,
		));
	}
?>
</div>
<?php
else :
endif;
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
