var GRVE_EL = GRVE_EL || {};

(function($){

	"use strict";
	GRVE_EL = {
		init: function() {
		},
		isotopeInit: function() {
			if ( $('body').hasClass('elementor-editor-active') ) {
				GRVE.pageSettings.isotope.init();
			}
		},
		listTitleGridInit: function() {
			if ( $('body').hasClass('elementor-editor-active') ) {
				GRVE.pageSettings.listTitleGrid.init();
			}
		},
		carouselInit: function() {
			if ( $('body').hasClass('elementor-editor-active') ) {
				GRVE.pageSettings.carouselElements.init();
			}
		},
		countdownInit: function() {
			if ( $('body').hasClass('elementor-editor-active') ) {
				GRVE_EXT.basicElements.countdown();
			}
		},
		progressBarsInit: function() {
			if ( $('body').hasClass('elementor-editor-active') ) {
				$('.grve-progress-bar').each(function() {
					var val = $(this).attr('data-value');
					$(this).find('.grve-bar-line').animate({ width: val + '%' }, 1600);
				});
			}
		},
		pieChartInit: function() {
			if ( $('body').hasClass('elementor-editor-active') ) {
			}
		},
	};

	var $document = $(document),
		$window = $(window),
		$body = $('body');

	$window.on('elementor/frontend/init', function () {
		if ( "undefined" !== typeof GRVE ) {
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_list_title.default',  GRVE_EL.listTitleGridInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_blog.default',  GRVE_EL.isotopeInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_blog_carousel.default',  GRVE_EL.carouselInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_portfolio.default',  GRVE_EL.isotopeInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_portfolio_carousel.default',  GRVE_EL.carouselInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_testimonial.default',  GRVE_EL.isotopeInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_testimonial_carousel.default',  GRVE_EL.carouselInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_products.default',  GRVE_EL.isotopeInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_products_carousel.default',  GRVE_EL.carouselInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_events.default',  GRVE_EL.isotopeInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_gallery.default',  GRVE_EL.isotopeInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_slider.default',  GRVE_EL.carouselInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_image_carousel.default',  GRVE_EL.carouselInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_content_slider.default',  GRVE_EL.carouselInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_countdown.default',  GRVE_EL.countdownInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_progress_bar.default',  GRVE_EL.progressBarsInit );
			elementorFrontend.hooks.addAction('frontend/element_ready/impeka_pie_chart.default',  GRVE_EL.pieChartInit );
		}
	});

})(jQuery);