<?php
/**
 * Callout Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-callout' );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Title Classes
$title_classes = array( 'grve-callout-content' );
$title_classes[]  = 'grve-' . $heading;
if ( 'inherit' != $title_color ) {
	$title_classes[]  = 'grve-text-' . $title_color;
}
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
$title_class_string = implode( ' ', $title_classes );

//Text Classes
$text_classes = array();
if ( !empty( $text_style ) && $text_style != 'none' ) {
	$text_classes[] = 'grve-' . $text_style;
}
if( 'inherit' != $text_color ){
	$text_classes[] = 'grve-text-' . $text_color;
}
$text_class_string = implode( ' ', $text_classes );

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
echo '<div class="grve-callout-wrapper">';
if ( !empty( $title ) ) {
	echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . wp_kses_post( $title ) . '</' . tag_escape( $heading_tag ) . '>';
}
if ( !empty( $content ) ) {
	echo '<p class="'. esc_attr( $text_class_string ) . '">' . impeka_elementor_ext_unautop( $content ) . '</p>';
}
echo '</div>';
echo '<div class="grve-button-wrapper">';
echo impeka_elementor_ext_get_button( $atts );
echo '</div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
