<?php
/**
 * Divider Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-divider' );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = '';
$css_style .= impeka_elementor_ext_build_padding_top_style( $padding_top );
$css_style .= impeka_elementor_ext_build_padding_bottom_style( $padding_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
if( 'vertical-line' == $line_type ){

	$vertical_classes = array( 'grve-vertical-divider' );
	$vertical_classes[] = 'grve-align-' . esc_attr( $align );
	if( 'custom' != $vertical_line_height ) {
		$vertical_classes[] = 'grve-height-' . esc_attr( $vertical_line_height );
	}
	if( !empty( $line_loop_animation ) ) {
		$vertical_classes[] = 'grve-line-anim-' . esc_attr( $line_loop_animation );
	}
	$vertical_class_string = implode( ' ', $vertical_classes );

	$line_style = '';
	$line_style .= 'width: '.(preg_match('/(px|em|vw|vh|\%|pt|cm)$/', $line_width) ? $line_width : $line_width.'px').';';
	if( 'custom' == $vertical_line_height ) {
		$line_style .= 'height: '.(preg_match('/(px|em|vw|vh|\%|pt|cm)$/', $vertical_line_height_custom) ? $vertical_line_height_custom : $vertical_line_height_custom.'px').';';
	}

	$line_inner_style = '';
	$vertical_inner_classes = array();
	if( 'custom' != $line_color ) {
		$vertical_inner_classes[] = 'grve-bg-' . esc_attr( $line_color );
	}
	$vertical_inner_class_string = implode( ' ', $vertical_inner_classes );
	$vertical_inner_attributes[] = 'class="' . esc_attr( $vertical_inner_class_string ) . '"';
	if( 'custom' == $line_color ) {
		$line_inner_style .= 'background-color: ' . esc_attr( $line_color_custom ) . ';';
		$vertical_inner_attributes[] = 'style="' . esc_attr( $line_inner_style ) . '"';
	}

	echo '<div class="' . esc_attr( $vertical_class_string ) . '" style="' . esc_attr( $line_style ) . '"><span ' . implode( ' ', $vertical_inner_attributes ) . '></span></div>';

} else if( 'custom-line' == $line_type ) {
	$line_style = '';
	$line_style .= 'width: '.(preg_match('/(px|em|\%|pt|cm)$/', $line_width) ? $line_width : $line_width.'px').';';
	$line_style .= 'height: '. $line_height. 'px;';
	if( 'custom' == $line_color ) {
		$line_style .= 'background-color: ' . esc_attr( $line_color_custom ) . ';';
	}
	echo '<span class="grve-custom-divider grve-bg-' . esc_attr( $line_color ) . ' grve-align-' . esc_attr( $align ) . '" style="' . esc_attr( $line_style ) . '"></span>';
} else {
	echo '<div class="grve-' . $line_type . '-divider grve-border">';
	if ( !empty( $backtotop_title ) && 'top-line' == $line_type ) {
		echo '<span class="grve-divider-backtotop grve-border grve-small-text grve-text-hover-primary-1">' . wp_kses_post( $backtotop_title ) . '</span>';
	}
	echo '</div>';
}
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
