<?php
/**
 * Icon Box Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-box-icon', 'grve-' . $icon_size, 'grve-' . $icon_box_type );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if( 'side-icon' == $icon_box_type ) {
	$element_classes[] = 'grve-vertical-align-' . $icon_vertical_align;
	$element_classes[] = 'grve-' . $icon_box_layout;
}
if ( 'yes' == $icon_animation ) {
	$element_classes[] = 'grve-advanced-hover';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Icon Wrapper
$icon_wrapper_classes = array( 'grve-wrapper-icon' );
if ( 'no-shape' != $icon_shape ) {
	$icon_wrapper_classes[] = 'grve-with-shape';
	$icon_wrapper_classes[] = 'grve-' . $icon_shape;
	$icon_wrapper_classes[] = 'grve-' . $shape_type;
	if ( 'outline' != $shape_type ) {
		$icon_wrapper_classes[] = 'grve-bg-' . $icon_shape_color;
	} else {
		$icon_wrapper_classes[] = 'grve-text-' . $icon_shape_color;
	}
}
if ( 'image' == $icon_type ) {
	$icon_wrapper_classes[] = 'grve-image-icon';
}
$icon_wrapper_class_string = implode( ' ', $icon_wrapper_classes );


//Icon Wrapper Style
$icon_wrapper_style = '';
if( 'custom' == $icon_color ) {
	$icon_wrapper_style .= ' color: ' . esc_attr( $icon_color_custom ) . ';';
}
if( 'custom' == $icon_shape_color ) {
	if ( 'no-shape' != $icon_shape && 'outline' != $shape_type ) {
		if ( 'outline' != $shape_type ) {
			$icon_wrapper_style .= ' background-color: ' . esc_attr( $icon_shape_color_custom ) . ';';
		} else {
			$icon_wrapper_style .= ' border-color: ' . esc_attr( $icon_shape_color_custom ) . ';';
		}
	}
}

//Icon
$icon_output = '';

if ( 'image' == $icon_type ) {

	$image_item_atts = array(
		'image' => $icon_image,
		'retina_image' => $retina_icon_image,
		'image_mode_size' => 'full',
		'fallback_image_mode_size' => 'thumbnail',
		'image_load_mode' => $image_load_mode,
		'wrapper' => 'yes',
	);

	$icon_output .= '<div class="' . esc_attr( $icon_wrapper_class_string ) . '">';
	$icon_output .= impeka_elementor_ext_get_image_html( $image_item_atts );
	$icon_output .= '</div>';

} else if( 'char' == $icon_type ) {
	$icon_output .= '<div class="' . esc_attr( $icon_wrapper_class_string ) . '" style="' . esc_attr( $icon_wrapper_style ) . '"><span class="grve-box-icon grve-text-' . esc_attr( $icon_color ) . '"><span>'. esc_html( $icon_char ) . '</span></span></div>';
} else {
	$icon_classes = array( 'grve-box-icon', 'grve-text-' . $icon_color );
	$icon_class_string = implode( ' ', $icon_classes );

	ob_start();
	echo '<div class="' . esc_attr( $icon_wrapper_class_string ) . '" style="' . esc_attr( $icon_wrapper_style ) . '">';
	if ( 'svg' === $icon['library'] ) {
		echo '<div class="grve-elementor-svg-icon ' . esc_attr( $icon_class_string ) . '">';
		\Elementor\Icons_Manager::render_icon( $icon , [ 'aria-hidden' => 'true' ] );
		echo '</div>';
	} else {
		\Elementor\Icons_Manager::render_icon( $icon , [ 'aria-hidden' => 'true', 'class' => $icon_class_string  ] );
	}
	echo '</div>';		
	$icon_output .= ob_get_clean();
}

//Title Classes
$title_classes = array( 'grve-box-title' );
$title_classes[]  = 'grve-' . $heading;
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
if( 'inherit' != $title_color ){
	$title_classes[] = 'grve-text-' . $title_color;
}
$title_class_string = implode( ' ', $title_classes );

//Text Classes
$text_classes = array();
if ( !empty( $text_style ) && $text_style != 'none' ) {
	$text_classes[] = 'grve-' . $text_style;
}
if( 'inherit' != $text_color ){
	$text_classes[] = 'grve-text-' . $text_color;
}
$text_class_string = implode( ' ', $text_classes );

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

if ( impeka_elementor_ext_has_link( $link ) ) {
	$link_attributes = impeka_elementor_ext_get_link_attributes( $link, $link_class );
	echo '<a ' . implode( ' ', $link_attributes ) . '>';
}

if( 'top-icon' == $icon_box_type ) {
	echo $icon_output;
	echo '<div class="grve-box-content">';
	if ( !empty( $title ) ) {
		echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . $title. '</' . tag_escape( $heading_tag ) . '>';
	}

	if ( !empty( $content ) ) {
		echo '<p class="' . esc_attr( $text_class_string ) . '">' . impeka_elementor_ext_unautop( $content ) . '</p>';
	}
	echo '</div>';
} else {
	if( 'layout-1' == $icon_box_layout ) {
		echo '<div class="grve-box-title-wrapper">';
		echo $icon_output;
		if ( !empty( $title ) ) {
			echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . $title. '</' . tag_escape( $heading_tag ) . '>';
		}
		echo '</div>';
		if ( !empty( $content ) ) {
			echo '<div class="grve-box-content">';
			echo '<p class="' . esc_attr( $text_class_string ) . '">' . impeka_elementor_ext_unautop( $content ) . '</p>';
			echo '</div>';
		}
	} else {
		echo $icon_output;
		echo '<div class="grve-box-content">';
			if ( !empty( $title ) ) {
				echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . $title. '</' . tag_escape( $heading_tag ) . '>';
			}
			if ( !empty( $content ) ) {

				echo '<p class="' . esc_attr( $text_class_string ) . '">' . impeka_elementor_ext_unautop( $content ) . '</p>';
			}
		echo '</div>';
	}
}
if ( impeka_elementor_ext_has_link( $link ) ) {
	echo '</a>';
}
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
