<?php
/**
 * Single Image Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-image' );

if ( !empty( $grve_animation ) ) {
	if( 'clipping-animation' == $grve_animation ) {
		$element_classes[] = 'grve-clipping-animation';
		$element_classes[] = 'grve-advanced-animation';
		if( 'colored-clipping-up' == $clipping_animation || 'colored-clipping-down' == $clipping_animation || 'colored-clipping-left' == $clipping_animation || 'colored-clipping-right' == $clipping_animation ) {
			$element_classes[] = 'grve-colored-clipping';
			$wrapper_attributes[] = 'data-clipping-color="' . esc_attr( $clipping_animation_colors ) . '"';
		}
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $clipping_animation ) . '"';
	} else if('appear-animation' == $grve_animation) {
		$element_classes[] = 'grve-appear-animation';
		$element_classes[] = 'grve-advanced-animation';
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $appear_animation ) . '"';
	} else {
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	}
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}


if ( 'image-content' == $image_type ) {
	$image_column_space = '100';
	$element_classes[] = 'grve-image-content';
}

if ( 'auto' != $image_column_space ) {
	$element_classes[] = 'grve-image-space-' . $image_column_space;
	$element_classes[] = 'grve-image-expand-width';
}
if ( 'auto' != $image_column_space && '100' != $image_column_space ) {
	switch( $image_column_space_reset ) {
		case 'tablet':
			$element_classes[] = 'grve-tablet-reset-image-space';
			$element_classes[] = 'grve-tablet-sm-reset-image-space';
			$element_classes[] = 'grve-mobile-reset-image-space';
		break;
		case 'tablet-sm':
			$element_classes[] = 'grve-tablet-sm-reset-image-space';
			$element_classes[] = 'grve-mobile-reset-image-space';
		break;
		case 'mobile':
			$element_classes[] = 'grve-mobile-reset-image-space';
		break;
		default:
		break;
	}
}

if ( 'image-popup' == $link_type || 'video-popup' == $link_type || 'gallery-popup' == $link_type ) {
	$element_classes[] = 'grve-light-gallery';
}
$element_classes_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_classes_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$image_mode_size = impeka_elementor_ext_get_image_size( $image_mode );
$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );

$image_item_atts = array(
	'image' => $image,
	'retina_image' => $retina_image,
	'image_mode_size' => $image_mode_size,
	'image_popup_size_mode' => $image_popup_size_mode,
	'image_load_mode' => $image_load_mode,
	'column_space' => $image_column_space,
	'wrapper' => 'yes',
);

$full_url = impeka_elementor_ext_get_image_popup_url( $image_item_atts );

$image_atts = array( 'data-column-space' => $image_column_space, 'data-lazyload' => $image_load_mode );

$id = '';
if ( !empty( $image ) ) {

	$id = impeka_elementor_ext_array_value( $image, 'id' );
	$img_src = wp_get_attachment_image_src( $id, $image_mode_size );
	if( $img_src !== false ) {
		$img_url = $img_src[0];
		if ( !empty( $retina_image ) ) {
			$img_retina_id = impeka_elementor_ext_array_value( $retina_image, 'id' );
			$img_retina_src = wp_get_attachment_image_src( $img_retina_id, 'full' );
			if( $img_retina_src !== false ) {
				$retina_url = $img_retina_src[0];
				$image_srcset = $img_url . ' 1x,' . $retina_url . ' 2x';
				$image_atts = array( 'srcset'=> $image_srcset, 'data-column-space' => $image_column_space, 'data-lazyload' => $image_load_mode );
			}
		}
	}

}
//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php
	//Title and Caption
	$title = $custom_title;
	$caption = $custom_caption;

	//Popup Link Data
	$data_html = '';
	if( !empty( $title ) ) {
		$data_html .= '<span class="grve-title">' . $title . '</span>';
	}
	if( !empty( $caption ) ) {
		$data_html .= '<span class="grve-caption">' . $caption . '</span>';
	}

	//Link Attributes
	$link_atts = array();
	$link_wrap = '';
	if ( 'image-popup' == $link_type ) {
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( $full_url ) . '"';
		if ( !empty( $data_html ) ) {
			$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
		}
	} else if ( 'gallery-popup' == $link_type ) {

		$attachments = wp_list_pluck( $img_ids, 'id' );
		if ( !empty( $img_ids ) && !empty( $attachments ) ) {
			$first_id = $attachments[0];
			$first_image_src = wp_get_attachment_image_src( $first_id, $image_popup_size_mode );
			$first_image_url = $first_image_src[0];

			$first_image_title = get_post_field( 'post_title', $id );
			$first_image_caption = get_post_field( 'post_excerpt', $id );
			$data_first_html = '';
			if ( !empty( $first_image_title ) && 'none' != $image_popup_title_caption && 'caption-only' != $image_popup_title_caption ) {
				$data_first_html .= '<span class="grve-title">' . $first_image_title . '</span>';
			}
			if ( !empty( $first_image_caption ) && 'none' != $image_popup_title_caption && 'title-only' != $image_popup_title_caption ) {
				$data_first_html .= '<span class="grve-caption">' . $first_image_caption . '</span>';
			}
			$link_atts[] = 'class="grve-item-url"';
			if ( !empty( $data_first_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_first_html ) . '"';
			}
			$link_atts[] = 'href="' . esc_url( $first_image_url ) . '"';
		} else {
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( $full_url ) . '"';
		}
	} else if ( 'custom-link' == $link_type ) {
		if ( 'image' == $image_type ) {
			$link_atts = impeka_elementor_ext_get_link_attributes( $link, $link_class );
			$link_wrap = 'wrap';
		} else {
			$link_extra_class = 'grve-item-url';
			if ( !empty( $link_class ) ) {
				$link_extra_class.= ' ' . $link_class;
			}
			$link_atts = impeka_elementor_ext_get_link_attributes( $link, $link_extra_class );
		}
	} else if ( 'video-popup' == $link_type ) {
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( $video_link ) . '"';
	}

	$ids = '';
	if ( !empty( $attachments ) ) {
		$ids  = implode( ",", $attachments );
	}

	$img_params = array(
		'element' => 'image',
		'link_atts' => $link_atts,
		'link_wrap' => $link_wrap,
		'style' => $hover_style,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'title_custom_font_family' => $title_custom_font_family,
		'title_color' => $title_color,
		'title_bg_color' => $title_bg_color,
		'image_popup_title_caption' => $image_popup_title_caption,
		'caption' => $caption,
		'text_color' => $text_color,
		'text_bg_color' => $text_bg_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_id' => $id,
		'image_ids' => $ids,
		'image_size' => $image_mode_size,
		'image_popup_size' => $image_popup_size_mode,
		'image_type' => $image_type,
		'link_type' => $link_type,
		'video_icon_color' => $video_icon_color,
		'image_atts' => $image_atts,
	);

?>
	<div class="grve-image-item">
		<?php
			if ( 'image' == $image_type ) {
				get_template_part( 'templates/image/image-default', '', $img_params );
			} else {
				get_template_part( 'templates/hover-item/hover-' . $hover_style, '', $img_params );
			}
		?>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.