<?php
/**
 * List Title Template
 */

extract( $atts );

//Post Type
$post_type_class = '';
$post_cat_slug = '';
if ( 'portfolio' == $post_type ) {
	$post_type_class = 'grve-list-portfolio';
	$post_cat_slug = 'portfolio_category';
} elseif ( 'product' == $post_type ) {
	$post_type_class = 'grve-list-product';
	$post_cat_slug = 'product_cat';
} else {
	$post_type_class = 'grve-list-post';
	$post_cat_slug = 'category';
}

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-list-title-grid', $post_type_class );
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_classes[] = 'grve-text-' . $text_color;
$element_class_string = implode( ' ', $element_classes );


$wrapper_attributes[] = 'data-display-style="' . esc_attr( $display_style ) . '"';
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$paged = 1;
if ( ! empty( $display_style ) ) {
	if ( get_query_var( 'paged' ) ) {
		$paged = get_query_var( 'paged' );
	} elseif ( get_query_var( 'page' ) ) {
		$paged = get_query_var( 'page' );
	}
}

//Query
$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}
$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
}

$category_ids = array();
if ( 'portfolio' == $post_type ) {
	$portfolio_cat = "";
	if( ! empty( $portfolio_categories ) ) {
		if( is_array( $portfolio_categories ) ) {
			$category_ids = $portfolio_categories;
		} else {
			$category_ids = explode( ",", $portfolio_categories );
		}
		foreach ( $category_ids as $category_id ) {
			$category_term = get_term( $category_id, 'portfolio_category' );
			if ( isset( $category_term) ) {
				$portfolio_cat = $portfolio_cat.$category_term->slug . ', ';
			}
		}
	}

	if( !empty( $include_posts ) ){
		$args = array(
			'post_type' => 'portfolio',
			'post_status'=>'publish',
			'paged' => $paged,
			'post__in' => $include_ids,
			'posts_per_page' => $posts_per_page,
			'orderby' => $order_by,
			'order' => $order,
		);
	} else {
		$args = array(
			'post_type' => 'portfolio',
			'post_status'=>'publish',
			'paged' => $paged,
			'portfolio_category' => $portfolio_cat,
			'posts_per_page' => $posts_per_page,
			'post__not_in' => $exclude_ids,
			'orderby' => $order_by,
			'order' => $order,
		);
	}

} elseif ( 'product' == $post_type ) {
	$product_cat = "";
	if( ! empty( $product_categories ) ) {
		if( is_array( $product_categories ) ) {
			$category_ids = $product_categories;
		} else {
			$category_ids = explode( ",", $product_categories );
		}
		foreach ( $category_ids as $category_id ) {
			$category_term = get_term( $category_id, 'product_cat' );
			if ( isset( $category_term) ) {
				$product_cat = $product_cat.$category_term->slug . ', ';
			}
		}
	}

	if( !empty( $include_posts ) ){
		$args = array(
			'post_type' => 'product',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'post__in' => $include_ids,
			'paged' => $paged,
			'orderby' => $order_by,
			'order' => $order,
		);
	} else {
		$args = array(
			'post_type' => 'product',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'post__not_in' => $exclude_ids,
			'product_cat' => $product_cat,
			'paged' => $paged,
			'orderby' => $order_by,
			'order' => $order,
		);
	}
} else {
	if( ! empty( $categories ) ) {
		if( is_array( $categories ) ) {
			$category_ids = $categories;
		} else {
			$category_ids = explode( ",", $categories );
		}
	}
	if( !empty( $include_posts ) ){
		$args = array(
			'post_type' => 'post',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'post__in' => $include_ids,
			'paged' => $paged,
			'ignore_sticky_posts' => 1,
			'orderby' => $order_by,
			'order' => $order,
		);
	} else {
		$args = array(
			'post_type' => 'post',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'cat' => $categories,
			'post__not_in' => $exclude_ids,
			'paged' => $paged,
			'ignore_sticky_posts' => 1,
			'orderby' => $order_by,
			'order' => $order,
		);
	}
}

// Item
$item_attributes = array();
$item_classes = array( 'grve-list-item' );
$item_class_string = implode( ' ', $item_classes );
$item_attributes[] = 'class="' . esc_attr( $item_class_string ) . '"';

$bg_options = array(
	'bg_color' => $overlay_color,
	'overlay_opacity' => $overlay_opacity,
);

//Title
$title_classes = array( 'grve-title' );
$title_classes[]  = 'grve-' . $heading;
$title_classes[]  = 'grve-text-' . $title_color;
$title_class_string = implode( ' ', $title_classes );

$query = new WP_Query( $args );
if ( $query->have_posts() ) {
//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-list-images-wrapper">
<?php
	while ( $query->have_posts() ) {
		$query->the_post();
?>
		<div class="grve-list-image">
		<?php impeka_elementor_ext_post_bg_image_container( $bg_options ); ?>
		</div>
<?php
	}
?>
	</div>
	<div class="grve-list-grid-wrapper">
	<?php
	if ( 'yes' == $filter ) {

		$filter_atts = array(
			'query' => $query,
			'category_name' => $post_cat_slug,
			'category_ids' => $category_ids,
			'filter_all_text' => $filter_all_text,
			'filter_style' => $filter_style,
			'filter_shape' => $filter_shape,
			'filter_color' => $filter_color,
			'filter_align' => $filter_align,
			'filter_order_by' => $filter_order_by,
			'filter_order' => $filter_order,
			'filter_gototop' => $filter_gototop,
		);
		impeka_elementor_print_filters( $filter_atts );
	}
	?>
		<div class="grve-list-grid">
<?php
	$item_index = 0;
	$count = 0;
	while ( $query->have_posts() ) {
		$query->the_post();
		$item_index++;
		if( $item_index > 9 ) {
			$count = $item_index;
		} else {
			$count = '0' . $item_index;
		}
?>
		<div <?php post_class( 'grve-list-item' ); ?>>
			<a class="grve-item-url" href="<?php echo esc_url( get_permalink()); ?>"></a>
			<span class="grve-count grve-text-<?php echo esc_attr( $text_color );?>"><?php echo esc_html( $count ); ?></span>
			<?php the_title( '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">', '<span class="grve-line grve-bg-'. esc_attr( $line_color ) . '"></span></' . tag_escape( $heading_tag ) . '>' ); ?>
		</div>
<?php
	}
?>
		</div>
	</div>
<?php
	if ( ! empty( $display_style ) ) {
		impeka_elementor_print_pagination( array(
			'total' => $query->max_num_pages,
			'paged' => $paged,
			'display_style' => $display_style,
		));
	}
?>
</div>
<?php
}
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
