<?php
/**
 * Products Carousel Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-carousel', 'grve-product-carousel', 'woocommerce' );
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$auto_play = impeka_elementor_ext_get_switcher_value( $auto_play );
$pagination = impeka_elementor_ext_get_switcher_value( $pagination );
$loop = impeka_elementor_ext_get_switcher_value( $loop );
$pause_hover = impeka_elementor_ext_get_switcher_value( $pause_hover );

//Carousel Wrapper
$carousel_attributes = array();
$carousel_attributes[] = 'data-items="' . esc_attr( $items_per_page ) . '"';
$carousel_attributes[] = 'data-items-tablet-landscape="' . esc_attr( $items_tablet_landscape ) . '"';
$carousel_attributes[] = 'data-items-tablet-portrait="' . esc_attr( $items_tablet_portrait ) . '"';
$carousel_attributes[] = 'data-items-mobile="' . esc_attr( $items_mobile ) . '"';
$carousel_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$carousel_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$carousel_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
if ( 'classic' == $type ) {
	$carousel_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
	$carousel_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
	$carousel_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
}
if ( 'classic' == $type && 'yes' == $item_gutter ) {
	$carousel_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
}

$carousel_classes = array( 'grve-carousel-element', 'grve-product-container' );
if ( 'classic' == $type && 'yes' == $item_gutter && '0' != $gutter_size ) {
	$carousel_classes[] = 'grve-with-gap';
}
if ( 'classic' == $type ) {
	$carousel_classes[] = 'grve-classic-carousel';
} else {
	$carousel_classes[] = 'grve-flickity-carousel';
	$carousel_classes[] = 'flickity';
}
$carousel_class_string = implode( ' ', $carousel_classes );
$carousel_attributes[] = 'class="' . esc_attr( $carousel_class_string ) . '"';

$product_cat = "";
$category_ids = array();

if( ! empty( $categories ) ) {
	if( is_array( $categories ) ) {
		$category_ids = $categories;
	} else {
		$category_ids = explode( ",", $categories );
	}
	foreach ( $category_ids as $category_id ) {
		$category_term = get_term( $category_id, 'product_cat' );
		if ( isset( $category_term) ) {
			$product_cat = $product_cat.$category_term->slug . ', ';
		}
	}
}

$paged = 1;

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'product',
		'post_status'=>'publish',
		'paged' => $paged,
		'post__in' => $include_ids,
		'posts_per_page' => $items_to_show,
		'orderby' => $order_by,
		'order' => $order,
	);
	$product_filter = 'no';
} else {
	$args = array(
		'post_type' => 'product',
		'post_status'=>'publish',
		'paged' => $paged,
		'product_cat' => $product_cat,
		'post__not_in' => $exclude_ids,
		'posts_per_page' => $items_to_show,
		'orderby' => $order_by,
		'order' => $order,
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-carousel-wrapper">
		<?php get_template_part( 'templates/navigation/carousel-nav', '', $atts ); ?>
		<div <?php echo implode( ' ', $carousel_attributes ); ?>>
<?php
while ( $query->have_posts() ) :
	$query->the_post();

	$image_size = impeka_elementor_ext_get_image_size( $image_mode );
	$product_params = array(
		'element' => 'product',
		'hover_style' => $hover_style,
		'image_size' => $image_size,
		'second_image_effect' => $second_image_effect,
		'text_color' => $text_color,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'link_type' => $link_type,
		'quick_view_title' => $quick_view_title,
	);
?>
			<div <?php post_class( 'grve-carousel-item' ); ?>>
				<?php get_template_part( 'templates/product/product-hover-item', '', $product_params ); ?>
			</div>
<?php
endwhile;
?>
		</div>
	</div>
</div>
<?php
else :
endif;
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
