<?php
/**
 * Progres Bar Template
 */


extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-progress-bars', 'grve-' . $bar_style );
if ( !empty( $heading ) ) {
	$element_classes[] = 'grve-' . $heading;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
if( 'inherit' != $text_color && 'style-2' == $bar_style ){
	$element_classes[] = 'grve-text-' . $text_color;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Bar Classes
$bar_classes = array( 'grve-bar' );
if ( !empty( $base_color ) ) {
	$bar_classes[] = 'grve-base-bg-' . $base_color;
}
if ( !empty( $bar_line_style ) ) {
	$bar_classes[] = 'grve-' . $bar_line_style;
}
$bar_class_string = implode( ' ', $bar_classes );

$bar_height_style = '';
if( !empty( $bar_height ) && 'style-2' == $bar_style ) {
	$bar_height_style .= 'height: '.(preg_match('/(px|em|\%|pt|cm)$/', $bar_height) ? $bar_height : $bar_height.'px').';';
}


//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';

if( !empty( $bar_values ) ) {
	foreach ( $bar_values as $k => $v ) {

		$bar_value = isset( $v['bar_value'] ) ? $v['bar_value'] : '';
		$bar_label = isset( $v['bar_label'] ) ? $v['bar_label'] : '';
		$bar_color = isset( $v['bar_color'] ) ? $v['bar_color'] : 'inherit';

		if( (float)$bar_value < 0 ) {
			$bar_value = 0;
		} else if ( (float)$bar_value > 100 ) {
			$bar_value = 100;
		}

		$bar_item_classes = array('grve-bar-line');
		if ( 'inherit' == $bar_color ) {
			$bar_color  = $color;
		}
		$bar_item_classes[] = 'grve-bg-' . $bar_color;
		if( 'white' == $bar_color ) {
			$bar_item_classes[] = 'grve-text-black';
		} else {
			$bar_item_classes[] = 'grve-text-white';
		}
		$bar_item_class_string = implode( ' ', $bar_item_classes );

		$progress_bar_classes = array('grve-progress-bar');
		if( 'style-1' == $bar_style ) {
			if( 'white' == $bar_color || 'grey' == $bar_color || 'light-grey' == $bar_color ) {
				$progress_bar_classes[] = 'grve-text-black';
			} else {
				$progress_bar_classes[] = 'grve-text-white';
			}
		}
		$progress_bar_class_string = implode( ' ', $progress_bar_classes );


		echo '<div class="' . esc_attr( $progress_bar_class_string ) . '" data-value="' .  esc_attr( $bar_value ) . '">';
			echo '<div class="grve-bar-title">' . $bar_label . '<span class="grve-percentage">' .  esc_html( $bar_value ) . '%</span> </div>';
			echo '<div class="' . esc_attr( $bar_class_string ) . '">';
				echo '<div class="' .  esc_attr( $bar_item_class_string ) . '" style="' . esc_attr( $bar_height_style ) . '"></div>';
			echo '</div>';
		echo '</div>';
	}
}

echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
