<?php
/**
 * Impeka Elementor Blog Widget.
 *
 * Elementor widget that inserts a blog grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Blog_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_blog';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Blog', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-blog';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'mode',
			[
				'label' => esc_html__( 'Blog Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'large',
				'options' => [
					'large'  => esc_html__( 'Large Media', 'impeka-elementor-extension' ),
					'small'  => esc_html__( 'Small Media', 'impeka-elementor-extension' ),
					'masonry' => esc_html__( 'Masonry', 'impeka-elementor-extension' ),
					'grid' => esc_html__( 'Grid', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( "Select your Blog Mode.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'media_area',
			[
				'label' => esc_html__( 'Media Area Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( "Select if you want to enable/disable media area", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_area' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'image_prio',
			[
				'label' => esc_html__( 'Featured Image Priority', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Featured image is displayed instead of media element", 'impeka-elementor-extension' ),
				'condition' => [
					'media_area' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'image_width',
			[
				'label' => esc_html__( 'Image Width', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'normal',
				'options' => array(
					'normal' => esc_html__( 'Normal', 'impeka-elementor-extension' ),
					'wide' => esc_html__( 'Wide', 'impeka-elementor-extension' ),
				),
				'description' => esc_html__( "Select the feature image width.", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'large' ],
				],
			]
		);
		$this->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'landscape-large-wide',
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'impeka-elementor-extension' ),
					'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'description' => esc_html__( "Select your Blog Image Size.", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'large' ],
				],
			]
		);
		$this->add_control(
			'grid_image_mode',
			[
				'label' => esc_html__( 'Grid Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					'square'  => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape'  => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'landscape-medium'  => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'portrait'  => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'portrait-medium'  => esc_html__( 'Portrait Medium Crop', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'default' => 'landscape',
				'description' => esc_html__( "Select your Blog Grid Image Size.", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'small', 'grid' ],
				],
			]
		);
		$this->add_control(
			'masonry_image_mode',
			[
				'label' => esc_html__( 'Masonry Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					'landscape-large-wide'  => esc_html__( 'Landscape Large Wide Crop', 'impeka-elementor-extension' ),
					'landscape-medium'  => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'default' => 'medium',
				'description' => esc_html__( "Select your Blog Masonry Image Size.", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'masonry' ],
				],
			]
		);
		$this->add_control(
			'columns_large_screen',
			[
				'label' => esc_html__( 'Large Screen Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
				],
				'default' => '3',
				'description' => esc_html__( "Select your Blog Columns", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'columns',
			[
				'label' => esc_html__( 'Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
				],
				'default' => '3',
				'description' => esc_html__( "Select your Blog Columns", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'columns_tablet_landscape',
			[
				'label' => esc_html__( 'Tablet Landscape Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '2',
				'description' => esc_html__( "Select responsive column on tablet devices, landscape orientation.", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'columns_tablet_portrait',
			[
				'label' => esc_html__( 'Tablet Portrait Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '2',
				'description' => esc_html__( "Select responsive column on tablet devices, portrait orientation.", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'columns_mobile',
			[
				'label' => esc_html__( 'Mobile Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
				],
				'default' => '1',
				'description' => esc_html__( "Select responsive column on mobile devices.", 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'item_gutter',
			[
				'label' => esc_html__( 'Gutter between items', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'mode' => [ 'small', 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'gutter_size',
			[
				'label' => esc_html__( 'Gutter Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '40',
				'condition' => [
					'item_gutter' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'auto_excerpt',
			[
				'label' => esc_html__( 'Auto excerpt', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				"description" => esc_html__( "Adds automatic excerpt to all posts in Large Media style. If auto excerpt is not selected, blog will show all content, a desired 'cut-off' point can be inserted in each post with more quicktag.", "impeka-elementor-extension" ),
				'condition' => [
					'mode' => [ 'large' ],
				],
			]
		);
		$this->add_control(
			'excerpt_length_large',
			[
				'label' => esc_html__( 'Excerpt Length', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '55',
				'condition' => [
					'auto_excerpt' => [ 'yes' ],
					'mode' => [ 'large' ],
				],
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label' => esc_html__( 'Excerpt Length', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '30',
				'condition' => [
					'mode' => [ 'small', 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'excerpt_more',
			[
				'label' => esc_html__( 'Read More', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "impeka-elementor-extension" ),

			]
		);
		$this->add_control(
			'excerpt_more_text',
			[
				'label' => esc_html__( 'Read More Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'read more',
				'condition' => [
					'excerpt_more' => [ 'yes' ],
				],
			]
		);
		$this->add_control( 'order_by', impeka_elementor_ext_add_order_by() );
		$this->add_control( 'order', impeka_elementor_ext_add_order() );
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->add_control(
			'el_id',
			[
				'label' => esc_html__( 'Element ID', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter element ID (Note: make sure it is unique)', 'impeka-elementor-extension' ),
				'default' => $this->get_id(),
			]
		);
		$this->end_controls_section();

		//Styles Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Styles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Blog Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__( 'Style 1' , 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Style 2' , 'impeka-elementor-extension' ),
					'style-3' => esc_html__( 'Style 3' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your blog style', 'impeka-elementor-extension' ),
				'default' => 'style-1',
				'condition' => [
					'mode' => [ 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'small_style',
			[
				'label' => esc_html__( 'Blog Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-small-1' => esc_html__( 'Style 1' , 'impeka-elementor-extension' ),
					'style-small-2' => esc_html__( 'Style 2' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your blog style', 'impeka-elementor-extension' ),
				'default' => 'style-small-1',
				'condition' => [
					'mode' => [ 'small' ],
				],
			]
		);
		$this->add_control(
			'custom_overview',
			[
				'label' => esc_html__( 'Custom Overview Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
				"description" => esc_html__( "Select if you want to overwrite the style from each post", "impeka-elementor-extension" ),
				'condition' => [
					'mode' => [ 'grid', 'masonry' ],
				],

			]
		);
		$this->add_control(
			'heading_color',
			[
				'label' => esc_html__( 'Heading Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the heading color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-2', 'style-3' ],
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-2', 'style-3' ],
				],
			]
		);
		$this->add_control(
			'meta_color',
			[
				'label' => esc_html__( 'Meta Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the meta color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-2', 'style-3' ],
				],
			]
		);
		$this->add_control(
			'bg_color',
			[
				'label' => esc_html__( 'Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the background color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-2', 'style-3' ],
				],
			]
		);
		$this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the border color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-2' ],
				],
			]
		);
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the overlay color ( only if Featured Image is set )', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-3' ],
				],
			]
		);
		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => esc_html__( 'Default', 'impeka-elementor-extension' ),
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the overlay opacity ( only if Featured Image is set )', 'impeka-elementor-extension' ),
				'default' => 'default',
				'condition' => [
					'style' => [ 'style-3' ],
				],
			]
		);
		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow() );
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );

		$this->add_control(
			'indicator',
			[
				'label' => esc_html__( 'Indicator', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'arrow' => esc_html__( 'Arrow' , 'impeka-elementor-extension' ),
					'plus' => esc_html__( 'Plus' , 'impeka-elementor-extension' ),
					'text' => esc_html__( 'Text' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the indicator.', 'impeka-elementor-extension' ),
				'default' => 'none',
				'condition' => [
					'style' => [ 'style-2', 'style-3' ],
				],
			]
		);
		$this->add_control(
			'indicator_text',
			[
				'label' => esc_html__( 'Indicator Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the indicator text.', 'impeka-elementor-extension' ),
				'default' => 'More',
				'condition' => [
					'indicator' => [ 'text' ],
				],
			]
		);
		$this->add_control(
			'indicator_color',
			[
				'label' => esc_html__( 'Indicator Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Choose the indicator color.', 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'indicator', 'operator' => '!in', 'value' => [ 'none' ] ],
					],
				],
			]
		);
		$this->end_controls_section();

		//Titles Section
		$this->start_controls_section(
			'titles_section',
			[
				'label' => esc_html__( 'Titles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_heading_tag',
			[
				'label' => esc_html__( 'Post Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Post Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
			]
		);
		$this->add_control(
			'title_heading',
			[
				'label' => esc_html__( 'Post Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'auto' => esc_html__( 'Auto', 'impeka-elementor-extension' ),
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Post Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'default' => 'auto',
			]
		);
		$this->end_controls_section();

		//Pagination & Extras
		$this->start_controls_section(
			'pagination_extras_section',
			[
				'label' => esc_html__( 'Pagination & Extras', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label_pagination',
			[
				'label' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'description' => esc_html__( 'Define the items to show per page or the total items number according to the selected display style.', 'impeka-elementor-extension' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__( 'Posts per Page', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter how many posts per page you want to display.', 'impeka-elementor-extension' ),
				'default' => '12',
			]
		);
		$this->add_control(
			'display_style',
			[
				'label' => esc_html__( 'Display Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Show All', 'impeka-elementor-extension' ),
					'pagination' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
					'load-more' => esc_html__( 'Load More', 'impeka-elementor-extension' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select Show All or define your pagination style.', 'impeka-elementor-extension' ),
				'default' => 'pagination',
				'condition' => [
					'mode' => [ 'small', 'grid', 'masonry' ],
				],
			]
		);
		$this->add_control(
			'display_large_style',
			[
				'label' => esc_html__( 'Display Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Show All', 'impeka-elementor-extension' ),
					'pagination' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select Show All or define your pagination style.', 'impeka-elementor-extension' ),
				'default' => 'pagination',
				'condition' => [
					'mode' => [ 'large' ],
				],
			]
		);
		$this->add_control(
			'load_more_title',
			[
				'label' => esc_html__( 'Load More Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Title for load more.', 'impeka-elementor-extension' ),
				'default' => 'Load More',
				'condition' => [
					'display_style' => [ 'load-more' ],
				],
			]
		);
		$this->add_control(
			'label_extras',
			[
				'label' => esc_html__( 'Extras', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'link_type',
			[
				'label' => esc_html__( 'Link Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'item',
				'options' => array(
					'item' => esc_html__( 'Classic Post', 'impeka-elementor-extension' ),
					'quick-view' => esc_html__( 'Quick View', 'impeka-elementor-extension' ),
				),
				'description' => esc_html__( "Select the link type of your post items.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_author',
			[
				'label' => esc_html__( 'Author Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the author field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_date',
			[
				'label' => esc_html__( 'Date Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the date field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_comments',
			[
				'label' => esc_html__( 'Comments Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the comments field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_like',
			[
				'label' => esc_html__( 'Like Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the like field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'show_categories',
			[
				'label' => esc_html__( 'Categories Field Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'description' => esc_html__( 'Enable or Disable the catgories field of your blog overview.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'categories_mode',
			[
				'label' => esc_html__( 'Categories Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'all'  => esc_html__( 'All', 'impeka-elementor-extension' ),
					'one'  => esc_html__( 'First / Primary', 'impeka-elementor-extension' ),
				),
				'default' => 'all',
				'description' => esc_html__( "Select your category mode.", 'impeka-elementor-extension' ),
				'condition' => [
					'show_categories' => [ 'yes' ],
				],
			]
		);
		$this->end_controls_section();

		//Filters
		$this->start_controls_section(
			'filters_section',
			[
				'label' => esc_html__( 'Filters', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'filter',
			[
				'label' => esc_html__( 'Filter', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( 'If selected, an isotope filter will be displayed.', 'impeka-elementor-extension' ) . ' ' . esc_html__( 'Enable Blog Filter ( Only for All or Multiple Categories )', 'impeka-elementor-extension' ),
				'condition' => [
					'mode' => [ 'small', 'grid', 'masonry' ],
				],
			]
		);

		$this->add_control( 'filter_all_text', impeka_elementor_ext_add_filter_all_text() );
		$this->add_control( 'filter_order_by', impeka_elementor_ext_add_filter_order_by() );
		$this->add_control( 'filter_order', impeka_elementor_ext_add_filter_order() );
		$this->add_control( 'filter_style', impeka_elementor_ext_add_filter_style() );
		$this->add_control( 'filter_shape', impeka_elementor_ext_add_filter_shape() );
		$this->add_control( 'filter_color', impeka_elementor_ext_add_filter_color() );
		$this->add_control( 'filter_align', impeka_elementor_ext_add_filter_align() );
		$this->add_control( 'filter_gototop', impeka_elementor_ext_add_filter_gototop() );

		$this->end_controls_section();

		//Filters
		$this->start_controls_section(
			'categories_section',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'exclude_posts',
			[
				'label' => esc_html__( 'Exclude Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories(),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'include_posts',
			[
				'label' => esc_html__( 'Include Specific Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'blog.php', array( 'atts' => $atts ) );
	}

}