<?php
/**
 * Impeka Elementor Content Slider Widget.
 *
 * Elementor widget that inserts an element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Content_Slider_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_content_slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Content Slider', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-content-slider';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'post_type',
			[
				'label' => esc_html__( 'Post Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'post' => esc_html__( 'Post', 'impeka-elementor-extension' ),
					'portfolio' => esc_html__( 'Portfolio', 'impeka-elementor-extension' ),
					'product' => esc_html__( 'Product', 'impeka-elementor-extension' ),
				),
				'default' => 'post',
				'description' => esc_html__( "Select the post type.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__( 'Number of Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ '2', '3', '4', '5', '6', '7' , '8', '9', '10' ],
				'default' => '4',
				'description' => esc_html__( 'Enter how many posts you want to display.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label' => esc_html__( 'Excerpt Length', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '15',
			]
		);
		$this->add_control(
			'excerpt_more',
			[
				'label' => esc_html__( 'Read More', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				"description" => esc_html__( "Adds a read more button after the excerpt or more quicktag", "impeka-elementor-extension" ),

			]
		);
		$this->add_control(
			'excerpt_more_text',
			[
				'label' => esc_html__( 'Read More Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'read more',
				'condition' => [
					'excerpt_more' => [ 'yes' ],
				],
			]
		);
		$this->add_control( 'order_by', impeka_elementor_ext_add_order_by() );
		$this->add_control( 'order', impeka_elementor_ext_add_order() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Titles and Hovers Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Titles & Hovers', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'description' => esc_html__( 'Choose the image color overlay.', 'impeka-elementor-extension' ),
				'default' => 'default',
			]
		);

		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => esc_html__( 'Default', 'impeka-elementor-extension' ),
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the opacity for the overlay.', 'impeka-elementor-extension' ),
				'default' => 'default',
			]
		);

		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow_alt() );
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );

		$this->end_controls_section();

		//Navigation
		$this->start_controls_section(
			'navigation_section',
			[
				'label' => esc_html__( 'Navigation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'auto_play', impeka_elementor_ext_add_auto_play() );
		$this->add_control(
			'slideshow_speed',
			[
				'label' => esc_html__( 'Slideshow Speed', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '3000',
				'description' => esc_html__( 'Slideshow Speed in ms.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'pause_hover',
			[
				'label' => esc_html__( 'Pause on Hover', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
				'description' => esc_html__( 'If selected, carousel will be paused on hover.', 'impeka-elementor-extension' ),
			]
		);

		$this->end_controls_section();

		//Categories
		$this->start_controls_section(
			'categories_section',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'exclude_posts',
			[
				'label' => esc_html__( 'Exclude Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories(),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
				'condition' => [
					'post_type' => [ 'post' ],
				],
			]
		);
		$this->add_control(
			'portfolio_categories',
			[
				'label' => esc_html__( 'Portfolio Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories( 'portfolio_category' ),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
				'condition' => [
					'post_type' => [ 'portfolio' ],
				],
			]
		);
		$this->add_control(
			'product_categories',
			[
				'label' => esc_html__( 'Product Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories( 'product_cat' ),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
				'condition' => [
					'post_type' => [ 'product' ],
				],
			]
		);
		$this->add_control(
			'include_posts',
			[
				'label' => esc_html__( 'Include Specific Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'content-slider.php', array( 'atts' => $atts ) );
	}

}