<?php
/**
 * Impeka Elementor Countdown Widget.
 *
 * Elementor widget that inserts a countdown element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Countdown_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_countdown';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Countdown', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-countdown';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'final_date',
			[
				'label' => esc_html__( 'Final Date', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Accepted formats: YYYY/MM/DD , MM/DD/YYYY , YYYY/MM/DD hh:mm:ss , MM/DD/YYYY hh:mm:ss ( e.g: 2021/12/25 )', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'countdown_format',
			[
				'label' => esc_html__( 'Countdown Display', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'D|H|M' => esc_html__( 'Days Hours Minutes', 'impeka-elementor-extension' ),
					'D|H|M|S' => esc_html__( 'Days Hours Minutes Seconds', 'impeka-elementor-extension' ),
					'w|d|H' => esc_html__( 'Weeks Days Hours', 'impeka-elementor-extension' ),
					'w|d|H|M|S' => esc_html__( 'Weeks Days Hours Minutes Seconds', 'impeka-elementor-extension' ),
				),
				'default' => 'D|H|M|S',
				'description' => esc_html__( "Select the countdown display.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'countdown_style',
			[
				'label' => esc_html__( 'Countdown Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'Style 1', 'impeka-elementor-extension' ),
					'2' => esc_html__( 'Style 2', 'impeka-elementor-extension' ),
					'3' => esc_html__( 'Style 3', 'impeka-elementor-extension' ),
				),
				'default' => '1',
				'description' => esc_html__( "Select the countdown style.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'numbers_size',
			[
				'label' => esc_html__( 'Numbers size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
					'page-title' => esc_html__( 'Page Title', 'impeka-elementor-extension' ),
					'feature-title' => esc_html__( 'Feature Title', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Numbers size and typography', 'impeka-elementor-extension' ),
				'default' => 'h3',
			]
		);
		$this->add_control( 'increase_heading', impeka_elementor_ext_add_increase_heading() );
		$this->add_control(
			'text_size',
			[
				'label' => esc_html__( 'Text size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Text size and typography', 'impeka-elementor-extension' ),
				'default' => 'small-text',
			]
		);
		$this->add_control(
			'bg_color',
			[
				'label' => esc_html__( 'Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'white',
				'description' => esc_html__( 'Background Color of the counter items.', 'impeka-elementor-extension' ),
				'condition' => [
					'countdown_style' => [ '2' ],
				],
			]
		);
		$this->add_control(
			'numbers_color',
			[
				'label' => esc_html__( 'Numbers Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Color of the numbers.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Color of the text.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'countdown.php', array( 'atts' => $atts ) );
	}

}