<?php
/**
 * Impeka Elementor Menu Widget.
 *
 * Elementor widget that inserts a menu into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Menu_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_menu';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Menu', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-menu';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'nav_menu',
			[
				'label' => esc_html__( 'Menu', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => impeka_elementor_ext_get_menus(),
				'description' => esc_html__( "Select a menu to display.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'orientation',
			[
				'label' => esc_html__( 'Menu Orientation', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'horizontal' => esc_html__( 'Horizontal', 'impeka-elementor-extension' ),
					'vertical' => esc_html__( 'Vertical', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Set the orientation of your menu.', 'impeka-elementor-extension' ),
				'default' => 'horizontal',
			]
		);
		$this->add_control(
			'responsive_orientation',
			[
				'label' => esc_html__( 'Menu Responsive Orientation', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'inherit' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'vertical-tablet' => esc_html__( 'Vertical on 1200px and below', 'impeka-elementor-extension' ),
					'vertical-tablet-sm' => esc_html__( 'Vertical on 959px and below', 'impeka-elementor-extension' ),
					'vertical-mobile' => esc_html__( 'Vertical on 767px and below', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Set the responsive orientation of your menu.', 'impeka-elementor-extension' ),
				'default' => 'inherit',
				'condition' => [
					'orientation' => [ 'horizontal' ],
				],
			]
		);
		$this->add_control(
			'menu_type',
			[
				'label' => esc_html__( 'Menu Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'toggle' => esc_html__( 'Toggle', 'impeka-elementor-extension' ),
					'accordion' => esc_html__( 'Accordion', 'impeka-elementor-extension' ),
					'slide' => esc_html__( 'Slide', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your menu type.', 'impeka-elementor-extension' ),
				'default' => 'toggle',
				'condition' => [
					'orientation' => [ 'vertical' ],
				],
			]
		);
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control(
			'heading',
			[
				'label' => esc_html__( 'Menu Font Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'body-text' => esc_html__( 'Body Text', 'impeka-elementor-extension' ),
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
					'menu-text' => esc_html__( 'Main Menu Fonts', 'impeka-elementor-extension' ),
					'responsive-menu-text' => esc_html__( 'Responsive Menu Fonts', 'impeka-elementor-extension' ),
					'offcanvas-menu-text' => esc_html__( 'Offcanvas Menu Fonts', 'impeka-elementor-extension' ),
					'page-title' => esc_html__( "Page Title Fonts", "impeka-elementor-extension" ),
					'feature-title'	=> esc_html__( "Feature Title Fonts", "impeka-elementor-extension" ),
				],
				'description' => esc_html__( 'Post Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'default' => 'menu-text',
			]
		);
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_control( 'item_space', impeka_elementor_ext_add_item_space() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();


		echo impeka_elementor_ext_locate_template( 'menu.php', array( 'atts' => $atts ) );
	}

}