<?php
/**
 * Impeka Elementor Portfolio Broken Widget.
 *
 * Elementor widget that inserts a portfolio element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Portfolio_Broken_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_portfolio_broken';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Portfolio Broken', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-portfolio';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'layout-1' => esc_html__( 'Layout 1' , 'impeka-elementor-extension' ),
					'layout-2' => esc_html__( 'Layout 2' , 'impeka-elementor-extension' ),
					'layout-3' => esc_html__( 'Layout 3' , 'impeka-elementor-extension' ),
					'layout-4' => esc_html__( 'Layout 4' , 'impeka-elementor-extension' ),
				],
				'default' => 'layout-1',
				'description' => esc_html__( "Select your layout.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
			]
		);
	
		$this->add_control( 'order_by', impeka_elementor_ext_add_order_by() );
		$this->add_control( 'order', impeka_elementor_ext_add_order() );
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->add_control(
			'el_id',
			[
				'label' => esc_html__( 'Element ID', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter element ID (Note: make sure it is unique)', 'impeka-elementor-extension' ),
				'default' => $this->get_id(),
			]
		);
		$this->end_controls_section();

		//Styles Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Styles & Titles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Portfolio Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__( 'Text below image' , 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Split text on hover' , 'impeka-elementor-extension' ),
					'style-3' => esc_html__( 'Text on media' , 'impeka-elementor-extension' ),
					'style-4' => esc_html__( 'Tilt media on hover' , 'impeka-elementor-extension' ),
					'style-5' => esc_html__( 'Cursor effect' , 'impeka-elementor-extension' ),
					'style-6' => esc_html__( 'Mouse move effect' , 'impeka-elementor-extension' ),
					'style-7' => esc_html__( 'Gradient Overlay' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select the hover style for the portfolio overview.', 'impeka-elementor-extension' ),
				'default' => 'style-1',
			]
		);
		$this->add_control(
			'indicator',
			[
				'label' => esc_html__( 'Indicator', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'arrow' => esc_html__( 'Arrow' , 'impeka-elementor-extension' ),
					'plus' => esc_html__( 'Plus' , 'impeka-elementor-extension' ),
					'text' => esc_html__( 'Text' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the indicator.', 'impeka-elementor-extension' ),
				'default' => 'none',
				'conditions' => [
					'terms' => [
						[ 'name' => 'style', 'operator' => '!in', 'value' => [ 'style-5' ] ],
					],
				],
			]
		);
		$this->add_control(
			'indicator_text',
			[
				'label' => esc_html__( 'Indicator Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the indicator text.', 'impeka-elementor-extension' ),
				'default' => 'More',
				'condition' => [
					'indicator' => [ 'text' ],
				],
			]
		);
		$this->add_control(
			'indicator_color',
			[
				'label' => esc_html__( 'Indicator Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Choose the indicator color.', 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'indicator', 'operator' => '!in', 'value' => [ 'none' ] ],
					],
				],
			]
		);		

		$this->add_control(
			'image_effect',
			[
				'label' => esc_html__( 'Image Effect', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'grayscale-image' => esc_html__( 'Grayscale Image' , 'impeka-elementor-extension' ),
					'grayscale-image-hover' => esc_html__( 'Colored on Hover' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the grayscale effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);


		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'gradient', 'standard', 'dominant'] ),
				'description' => esc_html__( 'Choose the image color overlay.', 'impeka-elementor-extension' ),
				'default' => 'black',
				'conditions' => [
					'terms' => [
						[ 'name' => 'style', 'operator' => '!in', 'value' => [ 'style-7' ] ],
					],
				],
			]
		);

		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the overlay opacity ', 'impeka-elementor-extension' ),
				'default' => '10',
			]
		);
		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow() );
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );

		$this->add_control(
			'title_caption',
			[
				'label' => esc_html__( 'Title & Description Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'title-caption' => esc_html__( 'Title and Description' , 'impeka-elementor-extension' ),
					'title-only' => esc_html__( 'Title Only' , 'impeka-elementor-extension' ),
					'caption-only' => esc_html__( 'Description Only' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Define the visibility for your title - description.', 'impeka-elementor-extension' ),
				'default' => 'title-caption',
			]
		);


		$this->add_control(
			'title_heading_tag',
			[
				'label' => esc_html__( 'Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'default' => 'h4',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);
		$this->add_control(
			'title_bg_color',
			[
				'label' => esc_html__( 'Title Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
				'default' => 'transparent',
				'description' => esc_html__( 'Choose the title background color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-5'],
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Description/Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the description/text color.', 'impeka-elementor-extension' ),
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);
		$this->add_control(
			'text_bg_color',
			[
				'label' => esc_html__( 'Description/Text Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
				'default' => 'transparent',
				'description' => esc_html__( 'Choose the description/text background color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-5'],
					'title_caption' => [ 'title-caption', 'caption-only'],
				],
			]
		);
		$this->end_controls_section();

		//Extras
		$this->start_controls_section(
			'extras_section',
			[
				'label' => esc_html__( 'Pagination & Extras', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'link_type',
			[
				'label' => esc_html__( 'Link Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'item' => esc_html__( 'Classic Portfolio', 'impeka-elementor-extension' ),
					'quick-view' => esc_html__( 'Quick View', 'impeka-elementor-extension' ),
					'popup' => esc_html__( 'Gallery Usage', 'impeka-elementor-extension' ),
					'custom-link' => esc_html__( 'Custom Link', 'impeka-elementor-extension' ),
				),
				'default' => 'item',
				'description' => esc_html__( "Select the link type of your post items.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'image_popup_size',
			[
				'label' => esc_html__( 'Image Popup Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka-elementor-extension' ),
					'full' => esc_html__( 'Full', 'impeka-elementor-extension' ),
				),
				'default' => 'extra-extra-large',
				'description' => esc_html__( "Select size for your popup image.", 'impeka-elementor-extension' ),
				'condition' => [
					'link_type' => [ 'popup' ],
				],
			]
		);
		$this->add_control(
			'overview_type',
			[
				'label' => esc_html__( 'Overview Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'impeka-elementor-extension' ),
					'custom-overview' => esc_html__( 'Custom Overview', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Select the overview type of your portfolio items.", 'impeka-elementor-extension' ),
			]
		);
		
		$this->add_control(
			'items_per_page',
			[
				'label' => esc_html__( 'Items per Page', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '12',
				'description' => esc_html__( 'Enter how many items per page you want to display.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'display_style',
			[
				'label' => esc_html__( 'Display Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Show All', 'impeka-elementor-extension' ),
					'pagination' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
				],
				'default' => 'pagination',
				'description' => esc_html__( 'Select Show All or define your pagination style.', 'impeka-elementor-extension' ),
			]
		);	

		$this->end_controls_section();

		//Categories
		$this->start_controls_section(
			'categories_section',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'exclude_posts',
			[
				'label' => esc_html__( 'Exclude Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Portfolio Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories( 'portfolio_category' ),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'include_posts',
			[
				'label' => esc_html__( 'Include Specific Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'portfolio-broken.php', array( 'atts' => $atts ) );
	}

}