<?php
/**
 * Impeka Elementor Progress Bar Widget.
 *
 * Elementor widget that inserts a progress bar into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Progress_Bar_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_progress_bar';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Progress Bar', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-bars';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'bar_style',
			[
				'label' => esc_html__( 'Progress Bar Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'style-1' => esc_html__( 'Style 1', 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Style 2', 'impeka-elementor-extension' ),
				),
				'default' => 'style-1',
				'description' => esc_html__( "Style of the bar line.", 'impeka-elementor-extension' ),
			]
		);

		$repeater = new \Elementor\Repeater();


		$repeater->add_control(
			'bar_value',
			[
				'label' => esc_html__( 'Bar Value', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '100',
			]
		);

		$repeater->add_control(
			'bar_label',
			[
				'label' => esc_html__( 'Bar Label', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Sample Label',
			]
		);

		$repeater->add_control(
			'bar_color',
			[
				'label' => esc_html__( 'Bar Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'gradient', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( "Select the bar color..", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'bar_values',
			[
				'label' => esc_html__( 'Bar values', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'bar_value' => '90',
						'bar_label' => 'Development',
						'bar_color' => 'inherit',
					],
					[
						'bar_value' => '80',
						'bar_label' => 'Design',
						'bar_color' => 'inherit',
					],
					[
						'bar_value' => '70',
						'bar_label' => 'Marketing',
						'bar_color' => 'inherit',
					],
				],
				'description' => esc_html__( "Configure your progress bar values.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'color',
			[
				'label' => esc_html__( 'Bars Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
				'default' => 'primary-1',
				'description' => esc_html__( "Use single color for all bars ( If not specified in Bar values ).", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'base_color',
			[
				'label' => esc_html__( 'Base Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['none', 'black-white'] ),
				'default' => 'black',
				'description' => esc_html__( "Select the base color for your bars.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
				'condition' => [
					'bar_style' => [ 'style-2' ],
				],
			]
		);
		$this->add_control(
			'bar_height',
			[
				'label' => esc_html__( 'Progress Bar Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '6',
				'description' => esc_html__( "Enter progress bar height.", 'impeka-elementor-extension' ),
				'condition' => [
					'bar_style' => [ 'style-2' ],
				],
			]
		);
		$this->add_control(
			'bar_line_style',
			[
				'label' => esc_html__( 'Bars Line Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Square', 'impeka-elementor-extension' ),
					'round' => esc_html__( 'Round', 'impeka-elementor-extension' ),
					'extra-round' => esc_html__( 'Extra Round', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Style of the bar line.", 'impeka-elementor-extension' ),
			]
		);


		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'small-text' ) );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'progress-bar.php', array( 'atts' => $atts ) );
	}

}