<?php
/**
 * Impeka Elementor Social Widget.
 *
 * Elementor widget that inserts a social element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Social_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_social';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Social', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-socials';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'social_email',
			[
				'label' => esc_html__( 'E-mail', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share with E-mail", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'social_facebook',
			[
				'label' => esc_html__( 'Facebook', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share in Facebook", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'social_twitter',
			[
				'label' => esc_html__( 'Twitter', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share in Twitter", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'social_linkedin',
			[
				'label' => esc_html__( 'Linkedin', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share in Linkedin", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'social_reddit',
			[
				'label' => esc_html__( 'reddit', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share in reddit", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'social_pinterest',
			[
				'label' => esc_html__( 'Pinterest', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share in Pinterest", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'social_tumblr',
			[
				'label' => esc_html__( 'Tumblr', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share in Tumblr", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'likes',
			[
				'label' => esc_html__( '(Greatives) Likes', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'Hide', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => '',
				'description' => esc_html__( "Share in (Greatives) Likes", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'extra-large' => esc_html__( 'Extra Large', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
					'extra-small' => esc_html__( 'Extra Small', 'impeka-elementor-extension' ),
				],
				'default' => 'medium',
				'description' => esc_html__( "Select icon size.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'item_space', impeka_elementor_ext_add_item_space( '15' ) );
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Color of the icon.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'icon_shape',
			[
				'label' => esc_html__( 'Icon Shape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no-shape'  => esc_html__( 'None', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square', 'impeka-elementor-extension' ),
					'round'  => esc_html__( 'Round', 'impeka-elementor-extension' ),
					'circle'  => esc_html__( 'Circle', 'impeka-elementor-extension' ),
				),
				'default' => 'no-shape',
				'description' => esc_html__( "Select icon shape.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'shape_type',
			[
				'label' => esc_html__( 'Shape Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'simple'  => esc_html__( 'Simple', 'impeka-elementor-extension' ),
					'outline'  => esc_html__( 'Outline', 'impeka-elementor-extension' ),
				),
				'default' => 'simple',
				'description' => esc_html__( "Select shape type.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape' => [ 'square', 'round', 'circle' ],
				],
			]
		);
		$this->add_control(
			'shape_color',
			[
				'label' => esc_html__( 'Shape Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Select the color of your icon.', 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape' => [ 'square', 'round', 'circle' ],
				],
			]
		);

		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );

		$this->add_control(
			'el_id',
			[
				'label' => esc_html__( 'Element ID', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter element ID (Note: make sure it is unique)', 'impeka-elementor-extension' ),
				'default' => $this->get_id(),
			]
		);

		$this->end_controls_section();


		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'social.php', array( 'atts' => $atts ) );
	}

}