<?php
/**
 * Impeka Elementor Title Widget.
 *
 * Elementor widget that inserts a title element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Title_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_title';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Title', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-title';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => 'Sample Title',
				'description' => esc_html__( 'Enter your title.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'increase_heading', impeka_elementor_ext_add_increase_heading() );
		$this->add_control( 'increase_heading_reset', impeka_elementor_ext_add_increase_heading_reset() );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'gradient', 'standard', 'custom'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_color_custom',
			[
				'label' => esc_html__( 'Custom Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#e1e1e1',
				'description' => esc_html__( "Select a custom color for your title", 'impeka-elementor-extension' ),
				'condition' => [
					'title_color' => [ 'custom' ],
				],
			]
		);
		$this->add_control(
			'line_type',
			[
				'label' => esc_html__( 'Line Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'No Line', 'impeka-elementor-extension' ),
					'top-line' => esc_html__( 'Top Line', 'impeka-elementor-extension' ),
					'left-line' => esc_html__( 'Left Line', 'impeka-elementor-extension' ),
					'right-line' => esc_html__( 'Right Line', 'impeka-elementor-extension' ),
					'bottom-line' => esc_html__( 'Bottom Line', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( 'Line Type of the title.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'line_width',
			[
				'label' => esc_html__( 'Line Width', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '50',
				'description' => esc_html__( "Enter the width for your line (Note: CSS measurement units allowed).", 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'line_type', 'operator' => '!in', 'value' => [ '' ] ],
					],
				],
			]
		);
		$this->add_control(
			'line_height',
			[
				'label' => esc_html__( 'Line Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10' ],
				'default' => '2',
				'description' => esc_html__( 'Enter the hight for your line in px.', 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'line_type', 'operator' => '!in', 'value' => [ '' ] ],
					],
				],
			]
		);
		
		$this->add_control(
			'line_color',
			[
				'label' => esc_html__( 'Line Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Color for the line.', 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'line_type', 'operator' => '!in', 'value' => [ '' ] ],
					],
				],
			]
		);
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation_all() );
		$this->add_control( 'clipping_animation', impeka_elementor_ext_add_clipping() );
		$this->add_control( 'clipping_animation_colors', impeka_elementor_ext_add_clipping_colors( 'black' ) );
		$this->add_control( 'appear_animation', impeka_elementor_ext_add_appear() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'title.php', array( 'atts' => $atts ) );
	}

}