<?php
/**
 * Impeka Elementor Video Widget.
 *
 * Elementor widget that inserts a video element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Video_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_video';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Video', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-video';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'video_type',
			[
				'label' => esc_html__( 'Video Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'link' => esc_html__( 'YouTube/Vimeo Video', 'impeka-elementor-extension' ),
					'html5' => esc_html__( 'HTML5 Video', 'impeka-elementor-extension' ),
				],
				'default' => 'link',
				'description' => esc_html__( 'Select your Video Type', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'video_link',
			[
				'label' => esc_html__( 'Video Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Type a YouTube/Vimeo URL.", 'impeka-elementor-extension' ),
				'condition' => [
					'video_type' => [ 'link' ],
				],
			]
		);

		$this->add_control(
			'video_mp4',
			[
				'label' => esc_html__( 'MP4 File URL', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Fill .mp4 format URL', 'impeka-elementor-extension' ),
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);
		$this->add_control(
			'video_webm',
			[
				'label' => esc_html__( 'WebM File URL ( optional )', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Fill .webm format for browser compatibility.', 'impeka-elementor-extension' ),
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);
		$this->add_control(
			'video_ogv',
			[
				'label' => esc_html__( 'OGV File URL ( optional )', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Fill .ogg format for browser compatibility.', 'impeka-elementor-extension' ),
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);

		$this->add_control(
			'video_poster',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select a poster image.", 'impeka-elementor-extension' ),
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);

		$this->add_control(
			'video_controls',
			[
				'label' => esc_html__( 'Show Video Controls', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);
		$this->add_control(
			'video_loop',
			[
				'label' => esc_html__( 'Video Loop', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);
		$this->add_control(
			'video_autoplay',
			[
				'label' => esc_html__( 'Video Autoplay', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);
		$this->add_control(
			'video_sound',
			[
				'label' => esc_html__( 'Video Sound', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'video_type' => [ 'html5' ],
				],
			]
		);

		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'video.php', array( 'atts' => $atts ) );
	}

}