<?php
namespace DPWAP;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

use DPWAP\Plugins\Base as pluginBase;
use DPWAP\Themes\Base as themeBase;

class Main {
    protected static $instance = null;
    public $extensions = array();

    public function __construct(){
        $this->addActions();
        $this->loadTextdomain();

        add_action( 'admin_enqueue_scripts', array( $this, 'dpwap_load_common_admin_scripts' ) );

        $plugins = new pluginBase();
        $plugins->setup();

        $themes = new themeBase();
        $themes->setup();
    }

    public function addActions() {
        add_action( 'admin_init', array( $this, 'dpwap_plugin_redirect' ) );
        add_action( 'admin_menu', array( $this, 'dpwap_load_menus' ) );
    }

    public function loadTextdomain(){
        load_textdomain( 'download-plugin', WP_LANG_DIR . '/download-plugin/download_plugin-' . get_locale() . '.mo' );
    }

    /**
     * redirect plugin to menu on activation
     */
    public function dpwap_plugin_redirect() {
        if ( get_option( 'download_plugin_do_activation_redirect', false ) ) {
            delete_option( 'download_plugin_do_activation_redirect' );
            wp_redirect( admin_url( "admin.php?page=dpwap_plugin" ) );
            exit;
        }
    }

    public function dpwap_load_menus() {
        add_menu_page( __( 'Download', 'download-plugin' ), __( 'Download', 'download-plugin' ), 'manage_options', "dpwap_plugin", array( $this, 'dpwap_plugin' ), 'dashicons-media-archive', '25' );
        // download plugin menu
        add_submenu_page( "dpwap_plugin", __( 'Download Plugins', 'download-plugin' ), __( 'Download Plugins', 'download-plugin' ), "manage_options", "dpwap_plugin", array( $this, 'dpwap_plugin' ) );
        // download theme menu
        add_submenu_page( "dpwap_plugin", __( 'Download Themes', 'download-plugin' ), __( 'Download Themes', 'download-plugin' ), "manage_options", "dpwap_theme", array( $this, 'dpwap_theme' ) );
        // load all extensions
        $dpwap = dpwap_plugin_loaded();
        // show default download user menu
        if ( !in_array( 'download-users', $dpwap->extensions ) ) {
            add_submenu_page( "dpwap_plugin", __('Download Users', 'download-plugin'), __('Download Users', 'download-plugin'), "manage_options", "dpwap_users", array( $this, 'duwap_users_check' ) );
        }
        
        do_action( 'dpwap_downlad_plugin_menus' );
    }

    public function dpwap_plugin() {
        $plugin_info_file = DPWAP_DIR.DS.'app'.DS.'Plugins'.DS.'templates'.DS.'dpwap_plugin_info.php';
        include_once $plugin_info_file;
    }

    public function dpwap_theme() {
        $theme_info_file = DPWAP_DIR.DS.'app'.DS.'Themes'.DS.'templates'.DS.'dpwap_theme_info.php';
        include_once $theme_info_file;
    }

    public function duwap_users_check() {
        $users_info_file = DPWAP_DIR.DS.'app'.DS.'Users'.DS.'templates'.DS.'dpwap_users_info.php';
        include_once $users_info_file;
    }

    public function dpwap_load_common_admin_scripts() {
        wp_enqueue_script( 'dpwap_common_js', DPWAP_URL.'assets/js/dpwap-common.js',array(), DPWAP_VERSION );
        wp_enqueue_style( 'dpwap_common_css', DPWAP_URL.'assets/css/dpwap-common.css',array(), DPWAP_VERSION );
    }
    
    public static function instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }
}