<?php
/*
 * Plugin Name: Impeka Dummy Importer
 * Description: Import Impeka Demo Content
 * Author: Greatives Team
 * Author URI: https://greatives.eu
 * Version: 1.3.6
 * Text Domain: impeka-importer
 */

/** Display verbose errors */
if ( ! defined( 'IMPEKA_IMPORT_DEBUG' ) ) {
	define( 'IMPEKA_IMPORT_DEBUG', false );
}
if ( ! defined( 'IMPEKA_IMPORT_SPLIT_ATTACHMENTS' ) ) {
	define( 'IMPEKA_IMPORT_SPLIT_ATTACHMENTS', true );
}
if ( ! defined( 'IMPEKA_IMPORT_MIN_PHP_VERSION' ) ) {
	define( 'IMPEKA_IMPORT_MIN_PHP_VERSION', '5.6.0' );
}

/** WordPress Import Administration API */
require_once ABSPATH . 'wp-admin/includes/import.php';

if ( ! class_exists( 'WP_Importer' ) ) {
	$class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
	if ( file_exists( $class_wp_importer ) )
		require $class_wp_importer;
}

/** Functions missing in older WordPress/PHP versions. */
require_once dirname( __FILE__ ) . '/compat.php';

/** WXR_Parser class */
require_once dirname( __FILE__ ) . '/parsers/class-wxr-parser.php';

/** WXR_Parser_SimpleXML class */
require_once dirname( __FILE__ ) . '/parsers/class-wxr-parser-simplexml.php';

/** WXR_Parser_XML class */
require_once dirname( __FILE__ ) . '/parsers/class-wxr-parser-xml.php';

/** WXR_Parser_Regex class */
require_once dirname( __FILE__ ) . '/parsers/class-wxr-parser-regex.php';

/** WP_Import class */
require_once dirname( __FILE__ ) . '/class-impeka-importer.php';

function impeka_importer_menu_page(){
	if ( function_exists( 'impeka_grve_info') ) {
		$link = 'admin.php?page=impeka-import';
	} else {
		$link = 'admin.php?import=impeka-demo-importer';
	}
	add_menu_page( 'Impeka Demos', 'Impeka Demos', 'manage_options', $link, '', plugin_dir_url(__FILE__).'/assets/images/grve-import.svg');
}
add_action( 'admin_menu', 'impeka_importer_menu_page' );

function impeka_importer_init() {
	load_plugin_textdomain( 'impeka-importer', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	$GLOBALS['impeka_importer'] = new Impeka_Importer();
	register_importer( 'impeka-demo-importer', 'Impeka Demo Importer', esc_html__('Import Impeka Demos, Dummy Content, Theme Options and Widgets.', 'impeka-importer'), array( $GLOBALS['impeka_importer'], 'dispatch' ) );
}
add_action( 'admin_init', 'impeka_importer_init' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
