<?php

/*
 *	Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */


/**
 * Helper function to return trimmed css code
 */
if ( ! function_exists( 'impeka_elementor_compress_css' ) ) {
	function impeka_elementor_compress_css( $css ) {
		$css_trim =  preg_replace( '/\s+/', ' ', $css );
		return $css_trim;
	}
}

/**
 * Helper function to get dynamic css
 */
function impeka_elementor_dynamic_css() {

$css = "";
$mobile_breakpoint = \Elementor\Plugin::$instance->breakpoints->get_breakpoints( 'mobile' )->get_value();
$tablet_breakpoint = \Elementor\Plugin::$instance->breakpoints->get_breakpoints( 'tablet' )->get_value();

$css .= "
.grve-elementor-align-left {
	text-align: left;
}
.grve-elementor-align-right {
	text-align: right;
}
.grve-elementor-align-center {
	text-align: center;
}

.grve-elementor-align-left .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper,
.grve-elementor-align-left .grve-box-icon.grve-side-icon.grve-layout-2 {
	justify-content: flex-start;
	flex-direction: row;
}
.grve-elementor-align-left .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
.grve-elementor-align-left .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
	margin-left: 0;
	margin-right: 0.500em;
}
.grve-elementor-align-center .grve-box-icon.grve-side-icon .grve-box-title-wrapper {
	justify-content: center;
}
.grve-elementor-align-right .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper,
.grve-elementor-align-right .grve-box-icon.grve-side-icon.grve-layout-2 {
	justify-content: flex-start;
	flex-direction: row-reverse;
}
.grve-elementor-align-right .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
.grve-elementor-align-right .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
	margin-left: 0.500em;
	margin-right: 0;
}
body.rtl .grve-elementor-align-right .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
body.rtl .grve-elementor-align-right .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
	margin-right: 0;
	margin-left: 0.500em;
}

.grve-elementor-align-center .grve-fluid-button {
	margin-left: auto;
	margin-right: auto;
}
.grve-elementor-align-left .grve-fluid-button {
	margin-left: 0;
	margin-right: auto;
}
.grve-elementor-align-right .grve-fluid-button {
	margin-left: auto;
	margin-right: 0;
}

.grve-elementor-align-center .grve-element.grve-social ul {
	justify-content: center;
}

.grve-elementor-align-left .grve-element.grve-social ul {
	justify-content: flex-start;
}

.grve-elementor-align-right .grve-element.grve-social ul {
	justify-content: flex-end;
}

.grve-elementor-align-center .grve-pricing-table.grve-layout-1 .grve-price {
	justify-content: center;
}
.grve-elementor-align-right .grve-pricing-table.grve-layout-1 .grve-price {
	justify-content: flex-end;
}

.grve-elementor-align-right .grve-menu-element .grve-vertical-menu .grve-link-wrapper {
	justify-content: flex-end;
}
.grve-elementor-align-center .grve-menu-element .grve-vertical-menu .grve-link-wrapper {
	justify-content: center;
}

.grve-elementor-align-left .grve-title.grve-with-line.grve-top-line .grve-title-line {
	margin: 0 auto 18px 0;
}
.grve-elementor-align-left .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
	margin: 18px auto 0 0;
}
.grve-elementor-align-left .grve-title.grve-with-line.grve-left-line {
	justify-content: flex-end;
}
.grve-elementor-align-left .grve-title.grve-with-line.grve-right-line {
	justify-content: flex-start;
}
.grve-elementor-align-right .grve-title.grve-with-line.grve-top-line .grve-title-line {
	margin: 0 0 18px auto;
}
.grve-elementor-align-right .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
	margin: 18px 0 0 auto;
}
.grve-elementor-align-right .grve-title.grve-with-line.grve-right-line {
	justify-content: flex-end;
}
.grve-elementor-align-center .grve-title.grve-with-line.grve-top-line .grve-title-line {
	margin: 0 auto 18px auto;
}
.grve-elementor-align-center .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
	margin: 18px auto 0 auto;
}
.grve-elementor-align-center .grve-title.grve-with-line.grve-right-line,
.grve-elementor-align-center .grve-title.grve-with-line.grve-left-line {
	justify-content: center;
}

@media only screen and (max-width: " . esc_attr( $tablet_breakpoint ) . "px) {
	.grve-elementor-align--tabletleft {
		text-align: left;
	}
	.grve-elementor-align--tabletright {
		text-align: right;
	}
	.grve-elementor-align--tabletcenter {
		text-align: center;
	}

	.grve-elementor-align--tabletleft .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper,
	.grve-elementor-align--tabletleft .grve-box-icon.grve-side-icon.grve-layout-2 {
		justify-content: flex-start;
		flex-direction: row;
	}
	.grve-elementor-align--tabletleft .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	.grve-elementor-align--tabletleft .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-left: 0;
		margin-right: 0.500em;
	}
	body.rtl .grve-elementor-align--tabletleft .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	body.rtl .grve-elementor-align--tabletleft .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-left: 0.500em;
		margin-right: 0;
	}
	.grve-elementor-align--tabletcenter .grve-box-icon.grve-side-icon .grve-box-title-wrapper {
		justify-content: center;
	}
	.grve-elementor-align--tabletright .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper,
	.grve-elementor-align--tabletright .grve-box-icon.grve-side-icon.grve-layout-2 {
		justify-content: flex-start;
		flex-direction: row-reverse;
	}
	.grve-elementor-align--tabletright .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	.grve-elementor-align--tabletright .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-left: 0.500em;
		margin-right: 0;
	}
	body.rtl .grve-elementor-align--tabletright .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	body.rtl .grve-elementor-align--tabletright .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-right: 0;
		margin-left: 0.500em;
	}

	.grve-elementor-align--tabletcenter .grve-fluid-button {
		margin-left: auto;
		margin-right: auto;
	}
	.grve-elementor-align--tabletleft .grve-fluid-button {
		margin-left: 0;
		margin-right: auto;
	}
	.grve-elementor-align--tabletright .grve-fluid-button {
		margin-left: auto;
		margin-right: 0;
	}

	.grve-elementor-align--tabletcenter .grve-element.grve-social ul {
		justify-content: center;
	}
	.grve-elementor-align--tabletleft .grve-element.grve-social ul {
		justify-content: flex-start;
	}
	.grve-elementor-align--tabletright .grve-element.grve-social ul {
		justify-content: flex-end;
	}

	.grve-elementor-align--tabletcenter .grve-pricing-table.grve-layout-1 .grve-price {
		justify-content: center;
	}
	.grve-elementor-align--tabletleft .grve-pricing-table.grve-layout-1 .grve-price {
		justify-content: flex-start;
	}
	.grve-elementor-align--tabletright .grve-pricing-table.grve-layout-1 .grve-price {
		justify-content: flex-end;
	}

	.grve-elementor-align--tabletcenter .grve-menu-element .grve-vertical-menu .grve-link-wrapper,
	.grve-elementor-align--tabletcenter .grve-menu-element.grve-vertical-mobile .grve-horizontal-menu .grve-link-wrapper {
		justify-content: center;
	}
	.grve-elementor-align--tabletleft .grve-menu-element .grve-vertical-menu .grve-link-wrapper,
	.grve-elementor-align--tabletleft .grve-menu-element.grve-vertical-mobile .grve-horizontal-menu .grve-link-wrapper {
		justify-content: flex-start;
	}
	.grve-elementor-align--tabletright .grve-menu-element .grve-vertical-menu .grve-link-wrapper,
	.grve-elementor-align--tabletright .grve-menu-element.grve-vertical-mobile .grve-horizontal-menu .grve-link-wrapper {
		justify-content: flex-end;
	}

	.grve-elementor-align--tabletleft .grve-title.grve-with-line.grve-top-line .grve-title-line {
		margin: 0 auto 18px 0;
	}
	.grve-elementor-align--tabletleft .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
		margin: 18px auto 0 0;
	}
	.grve-elementor-align--tabletleft .grve-title.grve-with-line.grve-left-line {
		justify-content: flex-end;
	}
	.grve-elementor-align--tabletleft .grve-title.grve-with-line.grve-right-line {
		justify-content: flex-start;
	}
	.grve-elementor-align--tabletright .grve-title.grve-with-line.grve-top-line .grve-title-line {
		margin: 0 0 18px auto;
	}
	.grve-elementor-align--tabletright .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
		margin: 18px 0 0 auto;
	}
	.grve-elementor-align--tabletright .grve-title.grve-with-line.grve-right-line {
		justify-content: flex-end;
	}
	.grve-elementor-align--tabletcenter .grve-title.grve-with-line.grve-top-line .grve-title-line {
		margin: 0 auto 18px auto;
	}
	.grve-elementor-align--tabletcenter .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
		margin: 18px auto 0 auto;
	}
	.grve-elementor-align--tabletcenter .grve-title.grve-with-line.grve-right-line,
	.grve-elementor-align--tabletcenter .grve-title.grve-with-line.grve-left-line {
		justify-content: center;
	}
}
@media only screen and (max-width: " . esc_attr( $mobile_breakpoint ) . "px) {
	.grve-elementor-align--mobileleft {
		text-align: left;
	}
	.grve-elementor-align--mobileright {
		text-align: right;
	}
	.grve-elementor-align--mobilecenter {
		text-align: center;
	}

	.grve-elementor-align--mobileleft .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper,
	.grve-elementor-align--mobileleft .grve-box-icon.grve-side-icon.grve-layout-2 {
		justify-content: flex-start;
		flex-direction: row;
	}
	.grve-elementor-align--mobileleft .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	.grve-elementor-align--mobileleft .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-left: 0;
		margin-right: 0.500em;
	}
	body.rtl .grve-elementor-align--mobileleft .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	body.rtl .grve-elementor-align--mobileleft .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-left: 0.500em;
		margin-right: 0;
	}
	.grve-elementor-align--mobilecenter .grve-box-icon.grve-side-icon .grve-box-title-wrapper {
		justify-content: center;
	}
	.grve-elementor-align--mobileright .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper,
	.grve-elementor-align--mobileright .grve-box-icon.grve-side-icon.grve-layout-2 {
		justify-content: flex-start;
		flex-direction: row-reverse;
	}
	.grve-elementor-align--mobileright .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	.grve-elementor-align--mobileright .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-left: 0.500em;
		margin-right: 0;
	}
	body.rtl .grve-elementor-align--mobileright .grve-box-icon.grve-side-icon.grve-layout-1 .grve-box-title-wrapper .grve-wrapper-icon,
	body.rtl .grve-elementor-align--mobileright .grve-box-icon.grve-side-icon.grve-layout-2 .grve-wrapper-icon {
		margin-right: 0;
		margin-left: 0.500em;
	}

	.grve-elementor-align--mobilecenter .grve-fluid-button {
		margin-left: auto;
		margin-right: auto;
	}
	.grve-elementor-align--mobileleft .grve-fluid-button {
		margin-left: 0;
		margin-right: auto;
	}
	.grve-elementor-align--mobileright .grve-fluid-button {
		margin-left: auto;
		margin-right: 0;
	}

	.grve-elementor-align--mobilecenter .grve-element.grve-social ul {
		justify-content: center;
	}
	.grve-elementor-align--mobileleft .grve-element.grve-social ul {
		justify-content: flex-start;
	}
	.grve-elementor-align--mobileright .grve-element.grve-social ul {
		justify-content: flex-end;
	}

	.grve-elementor-align--mobilecenter .grve-pricing-table.grve-layout-1 .grve-price {
		justify-content: center;
	}
	.grve-elementor-align--mobileleft .grve-pricing-table.grve-layout-1 .grve-price {
		justify-content: flex-start;
	}
	.grve-elementor-align--mobileright .grve-pricing-table.grve-layout-1 .grve-price {
		justify-content: flex-end;
	}

	.grve-elementor-align--mobilecenter .grve-menu-element .grve-vertical-menu .grve-link-wrapper,
	.grve-elementor-align--mobilecenter .grve-menu-element.grve-vertical-mobile .grve-horizontal-menu .grve-link-wrapper {
		justify-content: center;
	}
	.grve-elementor-align--mobileleft .grve-menu-element .grve-vertical-menu .grve-link-wrapper,
	.grve-elementor-align--mobileleft .grve-menu-element.grve-vertical-mobile .grve-horizontal-menu .grve-link-wrapper {
		justify-content: flex-start;
	}
	.grve-elementor-align--mobileright .grve-menu-element .grve-vertical-menu .grve-link-wrapper,
	.grve-elementor-align--mobileright .grve-menu-element.grve-vertical-mobile .grve-horizontal-menu .grve-link-wrapper {
		justify-content: flex-end;
	}

	.grve-elementor-align--mobileleft .grve-title.grve-with-line.grve-top-line .grve-title-line {
		margin: 0 auto 18px 0;
	}
	.grve-elementor-align--mobileleft .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
		margin: 18px auto 0 0;
	}
	.grve-elementor-align--mobileleft .grve-title.grve-with-line.grve-left-line {
		justify-content: flex-end;
	}
	.grve-elementor-align--mobileleft .grve-title.grve-with-line.grve-right-line {
		justify-content: flex-start;
	}
	.grve-elementor-align--mobileright .grve-title.grve-with-line.grve-top-line .grve-title-line {
		margin: 0 0 18px auto;
	}
	.grve-elementor-align--mobileright .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
		margin: 18px 0 0 auto;
	}
	.grve-elementor-align--mobileright .grve-title.grve-with-line.grve-right-line {
		justify-content: flex-end;
	}
	.grve-elementor-align--mobilecenter .grve-title.grve-with-line.grve-top-line .grve-title-line {
		margin: 0 auto 18px auto;
	}
	.grve-elementor-align--mobilecenter .grve-title.grve-with-line.grve-bottom-line .grve-title-line {
		margin: 18px auto 0 auto;
	}
	.grve-elementor-align--mobilecenter .grve-title.grve-with-line.grve-right-line,
	.grve-elementor-align--mobilecenter .grve-title.grve-with-line.grve-left-line {
		justify-content: center;
	}
}
";

$css .= impeka_elementor_get_space_size();
return $css;

}

function impeka_elementor_get_space_size() {

	$space_size_array = array ( '100', '125', '150', '175', '200', '225', '250' );

	$css = '';
	$mobile_breakpoint = \Elementor\Plugin::$instance->breakpoints->get_breakpoints( 'mobile' )->get_value();
	$tablet_breakpoint = \Elementor\Plugin::$instance->breakpoints->get_breakpoints( 'tablet' )->get_value();
	foreach ( $space_size_array as $space_size ) {
		$space_size_center = ( $space_size - 100 )/2;
		$space_size_right = ( $space_size - 100 );
		$css .= "
			.grve-elementor-align-left .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
			.grve-elementor-align-left .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
				margin-left: 0;
			}
			.grve-elementor-align-center .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
			.grve-elementor-align-center .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
				margin-left: -" . esc_attr( $space_size_center ) . "%;
			}
			.grve-elementor-align-right .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
			.grve-elementor-align-right .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
				margin-left: -" . esc_attr( $space_size_right ) . "%;
			}
			@media only screen and (max-width: " . esc_attr( $tablet_breakpoint ) . "px) {
				.grve-elementor-align--tabletleft .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
				.grve-elementor-align--tabletleft .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
					margin-left: 0;
				}
				.grve-elementor-align--tabletcenter .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
				.grve-elementor-align--tabletcenter .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
					margin-left: -" . esc_attr( $space_size_center ) . "%;
				}
				.grve-elementor-align--tabletright .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
				.grve-elementor-align--tabletright .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
					margin-left: -" . esc_attr( $space_size_right ) . "%;
				}
			}
			@media only screen and (max-width: " . esc_attr( $mobile_breakpoint ) . "px) {
				.grve-elementor-align--mobileleft .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
				.grve-elementor-align--mobileleft .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
					margin-left: 0;
				}
				.grve-elementor-align--mobilecenter .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
				.grve-elementor-align--mobilecenter .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
					margin-left: -" . esc_attr( $space_size_center ) . "%;
				}
				.grve-elementor-align--mobileright .grve-image.grve-image-space-" . esc_attr( $space_size ) . ":not(.grve-advanced-animation) .grve-image-wrapper,
				.grve-elementor-align--mobileright .grve-image.grve-image-space-" . esc_attr( $space_size ) . ".grve-advanced-animation .grve-animation-wrapper {
					margin-left: -" . esc_attr( $space_size_right ) . "%;
				}
			}
		";
	}
	return $css;
}




//Omit closing PHP tag to avoid accidental whitespace output errors.
