<?php
/**
 * Image Carousel Template
 */

extract( $atts );

if( 'default' == $images_mode ) {
	$attachments = wp_list_pluck( $img_ids, 'id' );
} else {
	$attachments = $single_image_ids;
}

if ( empty( $attachments ) ) {
	return '';
}


//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-carousel', 'grve-image-carousel' );
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}


$auto_play = impeka_elementor_ext_get_switcher_value( $auto_play );
$pagination = impeka_elementor_ext_get_switcher_value( $pagination );
$loop = impeka_elementor_ext_get_switcher_value( $loop );
$pause_hover = impeka_elementor_ext_get_switcher_value( $pause_hover );

//Carousel Wrapper
$carousel_attributes = array();
$carousel_attributes[] = 'data-items="' . esc_attr( $items_per_page ) . '"';
$carousel_attributes[] = 'data-items-tablet-landscape="' . esc_attr( $items_tablet_landscape ) . '"';
$carousel_attributes[] = 'data-items-tablet-portrait="' . esc_attr( $items_tablet_portrait ) . '"';
$carousel_attributes[] = 'data-items-mobile="' . esc_attr( $items_mobile ) . '"';
$carousel_attributes[] = 'data-pagination="' . esc_attr( $pagination ) . '"';
$carousel_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$carousel_attributes[] = 'data-slider-loop="' . esc_attr( $loop ) . '"';
$carousel_attributes[] = 'data-slider-autoheight="no"';
$carousel_attributes[] = 'data-stage-padding="0"';

if ( 'classic' == $type ) {
	$carousel_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
	$carousel_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
	$carousel_attributes[] = 'data-pagination-speed="' . esc_attr( $pagination_speed ) . '"';
}
if ( 'classic' == $type && 'yes' == $item_gutter ) {
	$carousel_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
}

$carousel_classes = array( 'grve-carousel-element' );
if ( 'default' == $images_mode ) {
	$carousel_classes[] = 'grve-gallery-popup';
} else {
	$carousel_classes[] = 'grve-multi-popup';
}

if ( 'classic' == $type && 'yes' == $item_gutter && '0' != $gutter_size ) {
	$carousel_classes[] = 'grve-with-gap';
}
if ( 'classic' == $type ) {
	$carousel_classes[] = 'grve-classic-carousel';
} else {
	$carousel_classes[] = 'grve-flickity-carousel';
	$carousel_classes[] = 'flickity';
}
$carousel_class_string = implode( ' ', $carousel_classes );
$carousel_attributes[] = 'class="' . esc_attr( $carousel_class_string ) . '"';


//Image Size
$image_size = impeka_elementor_ext_get_image_size( $image_mode );

$overlay_opacity = ( '0' == $overlay_opacity ) ? 'none' : $overlay_opacity;

//OUTPUT

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-carousel-wrapper">
		<?php get_template_part( 'templates/navigation/carousel-nav', '', $atts ); ?>
		<div <?php echo implode( ' ', $carousel_attributes ); ?>>
<?php

$gallery_index = 0;
$i = -1;
$image_size_class = '';

$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );

foreach ( $attachments as $image_item ) {

	$gallery_index++;
	$i++;

	if( 'default' == $images_mode ) {
		$id = $image_item;
	} else {
		$image = impeka_elementor_ext_array_value( $image_item, 'img' );
		$id = impeka_elementor_ext_array_value( $image, 'id' );

		$img_full_url = impeka_elementor_ext_array_value( $image, 'url' );

		$link_type = impeka_elementor_ext_array_value( $image_item, 'img_link_type' );
		$image_popup_size = impeka_elementor_ext_array_value( $image_item, 'img_popup_size' );
		$link = impeka_elementor_ext_array_value( $image_item, 'img_link' );
		$video_link = impeka_elementor_ext_array_value( $image_item, 'img_video_link' );
		$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );
	}

	//Title and Caption
	$caption = $title = '';

	if( !empty( $id ) ) {
		$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );
		if ( $full_src ) {
			$img_full_url = $full_src[0];
		}

		if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
			$title = get_post_field( 'post_title', $id );
		}
		if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
			$caption = get_post_field( 'post_excerpt', $id );
		}
	}

	//Popup Link Data
	$data_html = '';
	if( !empty( $title ) ) {
		$data_html .= '<span class="grve-title">' . $title . '</span>';
	}
	if( !empty( $caption ) ) {
		$data_html .= '<span class="grve-caption">' . $caption . '</span>';
	}

	//Link Attributes
	$link_atts = array();
	if( 'default' == $images_mode ) {
		if ( 'popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( $img_full_url ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		}
	} else {
		if ( 'popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url grve-multi-url"';
			$link_atts[] = 'href="' . esc_url( $img_full_url ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		} elseif ( 'custom-link' == $link_type ) {
			$link_atts = impeka_elementor_ext_get_link_attributes( $link );
			$link_atts[] = 'class="grve-item-url"';
		} elseif ( 'video-popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url grve-multi-url"';
			if( !empty( $video_link ) ) {
				$link_atts[] = 'href="' . esc_url( $video_link  ) . '"';
			}
		}
	}

	$hover_params = array(
		'element' => 'image-carousel',
		'link_atts' => $link_atts,
		'style' => $hover_style,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'title_custom_font_family' => $title_custom_font_family,
		'title_color' => $title_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_id' => $id,
		'image_size' => $image_size,
		'image_atts' => array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ),
	);
?>
			<div class="grve-entry-item grve-carousel-item">
				<div class="grve-image-item">
					<?php get_template_part( 'templates/hover-item/hover-' . $hover_style, '', $hover_params ); ?>
				</div>
			</div>
<?php	}
?>
		</div>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
