<?php
/**
 * Image Gallery Broken Template
 */

extract( $atts );

if( 'default' == $images_mode ) {
	$attachments = wp_list_pluck( $img_ids, 'id' );
} else {
	$attachments = $single_image_ids;
}

if ( empty( $attachments ) ) {
	return '';
}

//Element Wrapper
$element_classes = array( 'grve-element', 'grve-broken-gallery' );
$element_classes[] = 'grve-' . $layout;
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php
$container_classes = array( 'grve-broken-container' );
if ( 'default' == $images_mode ) {
	$container_classes[] = 'grve-gallery-popup';
} else {
	$container_classes[] = 'grve-multi-popup';
}
$container_class_string = implode( ' ', $container_classes );
?>
	<div class="<?php echo esc_attr( $container_class_string ); ?>">
<?php

$gallery_index = 0;
$i = -1;

// Item Class
$item_classes = array( 'grve-broken-item' );
if ( !empty( $grve_animation ) ) {
	$item_classes[] = 'grve-animated-item';
	$item_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
}
$item_class_string = implode( ' ', $item_classes );
$item_attributes[] = 'class="' . esc_attr( $item_class_string ) . '"';

$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );
foreach ( $attachments as $image_item ) {

	$item_extra_class = '';
	$gallery_index++;
	$i++;

	$broken_grid_data = impeka_elementor_ext_get_broken_grid_data( $gallery_index, $layout );
	$image_size = $broken_grid_data['image_size'];

	if( 'default' == $images_mode ) {
		$id = $image_item;
	} else {
		$image = impeka_elementor_ext_array_value( $image_item, 'img' );
		$id = impeka_elementor_ext_array_value( $image, 'id' );

		$img_full_url = impeka_elementor_ext_array_value( $image, 'url' );

		$link_type = impeka_elementor_ext_array_value( $image_item, 'img_link_type' );
		$image_popup_size = impeka_elementor_ext_array_value( $image_item, 'img_popup_size' );
		$link = impeka_elementor_ext_array_value( $image_item, 'img_link' );
		$video_link = impeka_elementor_ext_array_value( $image_item, 'img_video_link' );

		$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );
	}

	//Title and Caption
	$caption = $title = '';

	if( !empty( $id ) ) {
		$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );
		if ( $full_src ) {
			$img_full_url = $full_src[0];
		}

		if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
			$title = get_post_field( 'post_title', $id );
		}
		if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
			$caption = get_post_field( 'post_excerpt', $id );
		}
	}

	//Popup Link Data
	$data_html = '';
	if( !empty( $title ) ) {
		$data_html .= '<span class="grve-title">' . $title . '</span>';
	}
	if( !empty( $caption ) ) {
		$data_html .= '<span class="grve-caption">' . $caption . '</span>';
	}

	//Link Attributes
	$link_atts = array();
	if( 'default' == $images_mode ) {
		if ( 'popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( $img_full_url ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		}
	} else {
		if ( 'popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url grve-multi-url"';
			$link_atts[] = 'href="' . esc_url( $img_full_url ) . '"';
			if ( !empty( $data_html ) ) {
				$link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
			}
		} elseif ( 'custom-link' == $link_type ) {
			$link_atts = impeka_elementor_ext_get_link_attributes( $link );
			$link_atts[] = 'class="grve-item-url"';
		} elseif ( 'video-popup' == $link_type ) {
			$link_atts[] = 'class="grve-item-url grve-multi-url"';
			if( !empty( $video_link ) ) {
				$link_atts[] = 'href="' . esc_url( $video_link  ) . '"';
			}
		}
	}

	$hover_params = array(
		'element' => 'image-gallery-broken',
		'link_atts' => $link_atts,
		'style' => $hover_style,
		'overlay_color' => $overlay_color,
		'overlay_opacity' => $overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $title_heading,
		'title_color' => $title_color,
		'title_bg_color' => $title_bg_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'text_bg_color' => $text_bg_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_id' => $id,
		'image_size' => $image_size,
		'image_atts' => array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ),
		'indicator' => $indicator,
		'indicator_text' => $indicator_text,
		'indicator_color' => $indicator_color,
	);
?>
		<div <?php echo implode( ' ', $item_attributes ); ?>>
			<div class="grve-gallery-item-inner">
				<?php get_template_part( 'templates/hover-item/hover-' . $hover_style, '', $hover_params ); ?>
			</div>
		</div>
<?php
}
?>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
