<?php
/**
 * Message Box Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-message' );
if ( !empty( $grve_animation ) ) {
	if( 'clipping-animation' == $grve_animation ) {
		$element_classes[] = 'grve-clipping-animation';
		$element_classes[] = 'grve-advanced-animation';
		if( 'colored-clipping-up' == $clipping_animation || 'colored-clipping-down' == $clipping_animation || 'colored-clipping-left' == $clipping_animation || 'colored-clipping-right' == $clipping_animation ) {
			$element_classes[] = 'grve-colored-clipping';
			$wrapper_attributes[] = 'data-clipping-color="' . esc_attr( $clipping_animation_colors ) . '"';
		}
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $clipping_animation ) . '"';
	} else if('appear-animation' == $grve_animation) {
		$element_classes[] = 'grve-appear-animation';
		$element_classes[] = 'grve-advanced-animation';
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $appear_animation ) . '"';
	} else {
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	}
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if( 'white' == $bg_color || 'grey' == $bg_color || 'light-grey' == $bg_color ) {
	$element_classes[] = 'grve-text-dark-grey';
} else {
	$element_classes[] = 'grve-text-white';
}

if ( !empty( $shadow ) && 'none' != $shadow ) {
	$element_classes[] = 'grve-' . $shadow;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<div class="grve-message-inner grve-bg-'. esc_attr( $bg_color ) . '">';
		if( 'yes' == $add_icon ) {
			if ( 'svg' === $icon['library'] ) {
				echo '<div class="grve-message-icon">';
				\Elementor\Icons_Manager::render_icon( $icon , [ 'aria-hidden' => 'true' ] );
				echo '</div>';
			} else {
				\Elementor\Icons_Manager::render_icon( $icon , [ 'aria-hidden' => 'true', 'class' => 'grve-message-icon' ] );
			}
		}
		echo '<div class="grve-content-wrapper">';
			echo '<p>' . do_shortcode( $content ) . '</p>';
		echo '</div>';
		if ( 'yes' != $remove_close ) {
			echo '<div class="grve-close-btn">' . impeka_elementor_ext_get_svg_icon( 'close' ) . '</div>';
		}
	echo '</div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
