<?php
/**
 * Pie Chart Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-pie-chart', 'grve-' . $pie_chart_size );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Title Classes
$title_classes = array( 'grve-chart-title' );
$title_classes[]  = 'grve-' . $heading;
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
if( 'inherit' != $title_color ){
	$title_classes[] = 'grve-text-' . $title_color;
}
$title_class_string = implode( ' ', $title_classes );

//Text Classes
$text_classes = array();
if( 'inherit' != $text_color ){
	$text_classes[] = 'grve-text-' . $text_color;
}
$text_class_string = implode( ' ', $text_classes );

$chart_number_wrapper = array();
$chart_number_wrapper[] = 'data-percent="' . esc_attr( $pie_chart_val ) . '"';
$chart_number_wrapper[] = 'data-pie-active-color="' . esc_attr( $pie_active_color ) . '"';
$chart_number_wrapper[] = 'data-pie-color="' . esc_attr( $pie_chart_color ) . '"';
$chart_number_wrapper[] = 'data-pie-line-cap="' . esc_attr( $pie_line_style ) . '"';
$chart_number_wrapper[] = 'data-pie-size="' . esc_attr( $pie_chart_size ) . '"';
$chart_number_wrapper[] = 'data-pie-line-size="' . esc_attr( $pie_chart_line_size ) . '"';
$chart_number_wrapper[] = 'class="grve-chart-number"';

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<div ' . implode( ' ', $chart_number_wrapper ) . '>';
		echo '<span class="grve-counter" style="color:' . esc_attr( $pie_chart_val_color ) . '">' . wp_kses_post( $pie_chart_prefix . $pie_chart_val . $pie_chart_suffix ) . '</span>';
	echo '</div>';
	if ( !empty( $title ) ) {
		echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . wp_kses_post( $title ) . '</' . tag_escape( $heading_tag ) . '>';
	}
	if ( !empty( $pie_chart_text ) ) {
		echo '<p class="' . esc_attr( $text_class_string ) . '">' . wp_kses_post( $pie_chart_text ). '</p>';
	}
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
