<?php
/**
 * Quote Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-quote-element' );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
if ( 'inherit' != $text_color ) {
	$element_classes[] = 'grve-text-' . $text_color;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT

echo '<blockquote ' . implode( ' ', $wrapper_attributes ) . '>';
echo '<p>' . wp_kses_post( $content ) . '</p>';
echo '</blockquote>';

//Omit closing PHP tag to avoid accidental whitespace output errors.