<?php
/**
 * Title Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element' , 'grve-title' );
if ( !empty( $grve_animation ) ) {
	if( 'clipping-animation' == $grve_animation ) {
		$element_classes[] = 'grve-clipping-animation';
		$element_classes[] = 'grve-advanced-animation';
		if( 'colored-clipping-up' == $clipping_animation || 'colored-clipping-down' == $clipping_animation || 'colored-clipping-left' == $clipping_animation || 'colored-clipping-right' == $clipping_animation ) {
			$element_classes[] = 'grve-colored-clipping';
			$wrapper_attributes[] = 'data-clipping-color="' . esc_attr( $clipping_animation_colors ) . '"';
		}
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $clipping_animation ) . '"';
	} else if('appear-animation' == $grve_animation) {
		$element_classes[] = 'grve-appear-animation';
		$element_classes[] = 'grve-advanced-animation';
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $appear_animation ) . '"';
	} else {
		$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	}
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $heading ) ) {
	$element_classes[] = 'grve-' . $heading;
}
if ( !empty( $custom_font_family ) ) {
	$element_classes[] = 'grve-' . $custom_font_family;
}
if( '100' != $increase_heading ){
	if( !empty( $increase_heading_reset ) ) {
		$element_classes = impeka_elementor_ext_increase_heading_reset( $increase_heading_reset, $element_classes );
	}
	$element_classes[] =  'grve-increase-heading';
	$element_classes[] = 'grve-heading-' . $increase_heading;
}
if( !empty( $line_type ) ) {
	$element_classes[] = 'grve-with-line';
	$element_classes[] = 'grve-' . $line_type;
}
if( 'inherit' != $title_color && 'custom' != $title_color ){
	$element_classes[] = 'grve-text-' . $title_color;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if( 'custom' == $title_color ){
	$css_style .= ' color: ' . esc_attr( $title_color_custom ) . ';';
}
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//OUTPUT

echo '<' . tag_escape( $heading_tag ) . ' ' . implode( ' ', $wrapper_attributes ) . '>';
if( !empty( $line_type ) ) {
	$line_style = '';
	$line_style .= 'width: '.(preg_match('/(px|em|\%|pt|cm)$/', $line_width) ? $line_width : $line_width.'px').';';
	$line_style .= 'height: '. $line_height. 'px;';
	echo '<span>';
	echo impeka_elementor_ext_auto_br( $content );
	echo '</span>';
	echo '<span class="grve-title-line grve-bg-' . esc_attr( $line_color ) . '" style="' . esc_attr( $line_style ) . '"></span>';
} else {
	echo '<span>';
	echo impeka_elementor_ext_auto_br( $content );
	echo '</span>';
}
echo '</' . tag_escape( $heading_tag ) . '>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
